/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;

public class KryoHelpers {
    private KryoHelpers() {
    }

    public static <T> T roundTripSerialize(T obj) throws IOException {
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (Output out = new Output((OutputStream)new ObjectOutputStream(bytes));){
            kryo.writeClassAndObject(out, obj);
        }
        try (Input in = new Input((InputStream)new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())));){
            Object object = kryo.readClassAndObject(in);
            return (T)object;
        }
    }
}

