/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataTableScanTestBase;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SparkDistributedDataScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class SparkDistributedDataScanTestBase
extends DataTableScanTestBase<BatchScan, ScanTask, ScanTaskGroup<ScanTask>> {
    protected static SparkSession spark = null;
    @Parameter(index=1)
    private PlanningMode dataMode;
    @Parameter(index=2)
    private PlanningMode deleteMode;

    @Parameters(name="formatVersion = {0}, dataMode = {1}, deleteMode = {2}")
    public static List<Object> parameters() {
        return Arrays.asList(new Object[]{1, PlanningMode.LOCAL, PlanningMode.LOCAL}, new Object[]{1, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, new Object[]{1, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, new Object[]{1, PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED}, new Object[]{2, PlanningMode.LOCAL, PlanningMode.LOCAL}, new Object[]{2, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, new Object[]{2, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, new Object[]{2, PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED});
    }

    @BeforeEach
    public void configurePlanningModes() {
        this.table.updateProperties().set("read.data-planning-mode", this.dataMode.modeName()).set("read.delete-planning-mode", this.deleteMode.modeName()).commit();
    }

    protected BatchScan useRef(BatchScan scan, String ref) {
        return scan.useRef(ref);
    }

    protected BatchScan useSnapshot(BatchScan scan, long snapshotId) {
        return scan.useSnapshot(snapshotId);
    }

    protected BatchScan asOfTime(BatchScan scan, long timestampMillis) {
        return scan.asOfTime(timestampMillis);
    }

    protected BatchScan newScan() {
        SparkReadConf readConf = new SparkReadConf(spark, (Table)this.table, (Map)ImmutableMap.of());
        return new SparkDistributedDataScan(spark, (Table)this.table, readConf);
    }

    protected static SparkSession initSpark(String serializer) {
        return SparkSession.builder().master("local[2]").config("spark.serializer", serializer).config(SQLConf.SHUFFLE_PARTITIONS().key(), "4").getOrCreate();
    }
}

