/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestManifestFileSerialization {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("double").build();
    private static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{1.0})).withPartitionPath("double=1").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(4L)))).build();
    private static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{Double.NaN})).withPartitionPath("double=NaN").withMetrics(new Metrics(Long.valueOf(1L), null, (Map)ImmutableMap.of((Object)1, (Object)1L, (Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), (Map)ImmutableMap.of((Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(1L)))).build();
    private static final FileIO FILE_IO = new HadoopFileIO(new Configuration());
    @TempDir
    private Path temp;

    @Test
    public void testManifestFileKryoSerialization() throws IOException {
        File data = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)data.delete()).isTrue();
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        try (Output out = new Output((OutputStream)new FileOutputStream(data));){
            kryo.writeClassAndObject(out, (Object)manifest);
            kryo.writeClassAndObject(out, (Object)manifest.copy());
            kryo.writeClassAndObject(out, (Object)GenericManifestFile.copyOf((ManifestFile)manifest).build());
        }
        try (Input in = new Input((InputStream)new FileInputStream(data));){
            for (int i = 0; i < 3; ++i) {
                Object obj = kryo.readClassAndObject(in);
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a ManifestFile", new Object[0])).isInstanceOf(ManifestFile.class);
                this.checkManifestFile(manifest, (ManifestFile)obj);
            }
        }
    }

    @Test
    public void testManifestFileJavaSerialization() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(manifest);
            out.writeObject(manifest.copy());
            out.writeObject(GenericManifestFile.copyOf((ManifestFile)manifest).build());
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            for (int i = 0; i < 3; ++i) {
                Object obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a ManifestFile", new Object[0])).isInstanceOf(ManifestFile.class);
                this.checkManifestFile(manifest, (ManifestFile)obj);
            }
        }
    }

    private void checkManifestFile(ManifestFile expected, ManifestFile actual) {
        ((AbstractStringAssert)Assertions.assertThat((String)actual.path()).as("Path must match", new Object[0])).isEqualTo(expected.path());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.length()).as("Length must match", new Object[0])).isEqualTo(expected.length());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.partitionSpecId()).as("Spec id must match", new Object[0])).isEqualTo(expected.partitionSpecId());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.snapshotId()).as("Snapshot id must match", new Object[0])).isEqualTo((Object)expected.snapshotId());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasAddedFiles()).as("Added files flag must match", new Object[0])).isEqualTo(expected.hasAddedFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.addedFilesCount()).as("Added files count must match", new Object[0])).isEqualTo((Object)expected.addedFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.addedRowsCount()).as("Added rows count must match", new Object[0])).isEqualTo((Object)expected.addedRowsCount());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasExistingFiles()).as("Existing files flag must match", new Object[0])).isEqualTo(expected.hasExistingFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.existingFilesCount()).as("Existing files count must match", new Object[0])).isEqualTo((Object)expected.existingFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.existingRowsCount()).as("Existing rows count must match", new Object[0])).isEqualTo((Object)expected.existingRowsCount());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.hasDeletedFiles()).as("Deleted files flag must match", new Object[0])).isEqualTo(expected.hasDeletedFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actual.deletedFilesCount()).as("Deleted files count must match", new Object[0])).isEqualTo((Object)expected.deletedFilesCount());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.deletedRowsCount()).as("Deleted rows count must match", new Object[0])).isEqualTo((Object)expected.deletedRowsCount());
        ManifestFile.PartitionFieldSummary expectedPartition = (ManifestFile.PartitionFieldSummary)expected.partitions().get(0);
        ManifestFile.PartitionFieldSummary actualPartition = (ManifestFile.PartitionFieldSummary)actual.partitions().get(0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualPartition.containsNull()).as("Null flag in partition must match", new Object[0])).isEqualTo(expectedPartition.containsNull());
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)actualPartition.containsNaN()).as("NaN flag in partition must match", new Object[0])).isEqualTo((Object)expectedPartition.containsNaN());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualPartition.lowerBound()).as("Lower bounds in partition must match", new Object[0])).isEqualTo((Object)expectedPartition.lowerBound());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualPartition.upperBound()).as("Upper bounds in partition must match", new Object[0])).isEqualTo((Object)expectedPartition.upperBound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeManifest(DataFile ... files) throws IOException {
        File manifestFile = File.createTempFile("input.m0", ".avro", this.temp.toFile());
        Assertions.assertThat((boolean)manifestFile.delete()).isTrue();
        OutputFile outputFile = FILE_IO.newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((PartitionSpec)SPEC, (OutputFile)outputFile);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

