/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TaskCheckHelper;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestScanTaskSerialization
extends TestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    @TempDir
    private Path temp;
    @TempDir
    private File tableDir;
    private String tableLocation = null;

    @BeforeEach
    public void setupTableLocation() throws Exception {
        this.tableLocation = this.tableDir.toURI().toString();
    }

    @Test
    public void testBaseCombinedScanTaskKryoSerialization() throws Exception {
        BaseCombinedScanTask scanTask = this.prepareBaseCombinedScanTaskForSerDeTest();
        File data = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)data.delete()).isTrue();
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        try (Output out = new Output((OutputStream)new FileOutputStream(data));){
            kryo.writeClassAndObject(out, (Object)scanTask);
        }
        try (Input in = new Input((InputStream)new FileInputStream(data));){
            Object obj = kryo.readClassAndObject(in);
            ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a BaseCombinedScanTask", new Object[0])).isInstanceOf(BaseCombinedScanTask.class);
            TaskCheckHelper.assertEquals((ScanTaskGroup<FileScanTask>)scanTask, (ScanTaskGroup<FileScanTask>)((BaseCombinedScanTask)obj));
        }
    }

    @Test
    public void testBaseCombinedScanTaskJavaSerialization() throws Exception {
        BaseCombinedScanTask scanTask = this.prepareBaseCombinedScanTaskForSerDeTest();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(scanTask);
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object obj = in.readObject();
            ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a BaseCombinedScanTask", new Object[0])).isInstanceOf(BaseCombinedScanTask.class);
            TaskCheckHelper.assertEquals((ScanTaskGroup<FileScanTask>)scanTask, (ScanTaskGroup<FileScanTask>)((BaseCombinedScanTask)obj));
        }
    }

    @Test
    public void testBaseScanTaskGroupKryoSerialization() throws Exception {
        BaseScanTaskGroup<FileScanTask> taskGroup = this.prepareBaseScanTaskGroupForSerDeTest();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)taskGroup.tasks()).as("Task group can't be empty", new Object[0])).isNotEmpty();
        File data = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)data.delete()).isTrue();
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        try (Output out = new Output(Files.newOutputStream(data.toPath(), new OpenOption[0]));){
            kryo.writeClassAndObject(out, taskGroup);
        }
        try (Input in = new Input(Files.newInputStream(data.toPath(), new OpenOption[0]));){
            Object obj = kryo.readClassAndObject(in);
            ((ObjectAssert)Assertions.assertThat((Object)obj).as("should be a BaseScanTaskGroup", new Object[0])).isInstanceOf(BaseScanTaskGroup.class);
            TaskCheckHelper.assertEquals(taskGroup, (ScanTaskGroup<FileScanTask>)((BaseScanTaskGroup)obj));
        }
    }

    @Test
    public void testBaseScanTaskGroupJavaSerialization() throws Exception {
        BaseScanTaskGroup<FileScanTask> taskGroup = this.prepareBaseScanTaskGroupForSerDeTest();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)taskGroup.tasks()).as("Task group can't be empty", new Object[0])).isNotEmpty();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(taskGroup);
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object obj = in.readObject();
            ((ObjectAssert)Assertions.assertThat((Object)obj).as("should be a BaseScanTaskGroup", new Object[0])).isInstanceOf(BaseScanTaskGroup.class);
            TaskCheckHelper.assertEquals(taskGroup, (ScanTaskGroup<FileScanTask>)((BaseScanTaskGroup)obj));
        }
    }

    private BaseCombinedScanTask prepareBaseCombinedScanTaskForSerDeTest() {
        Table table = this.initTable();
        CloseableIterable tasks = table.newScan().planFiles();
        return new BaseCombinedScanTask((List)Lists.newArrayList((Iterable)tasks));
    }

    private BaseScanTaskGroup<FileScanTask> prepareBaseScanTaskGroupForSerDeTest() {
        Table table = this.initTable();
        CloseableIterable tasks = table.newScan().planFiles();
        return new BaseScanTaskGroup((Collection)ImmutableList.copyOf((Iterable)tasks));
    }

    private Table initTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        return table;
    }

    private void writeRecords(List<ThreeColumnRecord> records) {
        Dataset df = spark.createDataFrame(records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeDF(Dataset<Row> df) {
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
    }
}

