/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DeleteFileIndexTestBase;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SparkDistributedDataScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSparkDistributedDataScanDeletes
extends DeleteFileIndexTestBase<BatchScan, ScanTask, ScanTaskGroup<ScanTask>> {
    private static SparkSession spark = null;
    @Parameter(index=1)
    private PlanningMode dataMode;
    @Parameter(index=2)
    private PlanningMode deleteMode;

    @Parameters(name="formatVersion = {0}, dataMode = {1}, deleteMode = {2}")
    public static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, PlanningMode.LOCAL, PlanningMode.LOCAL}, new Object[]{2, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, new Object[]{2, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, new Object[]{2, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, new Object[]{3, PlanningMode.LOCAL, PlanningMode.LOCAL}, new Object[]{3, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, new Object[]{3, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, new Object[]{3, PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED});
    }

    @BeforeEach
    public void configurePlanningModes() {
        this.table.updateProperties().set("read.data-planning-mode", this.dataMode.modeName()).set("read.delete-planning-mode", this.deleteMode.modeName()).commit();
    }

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config(SQLConf.SHUFFLE_PARTITIONS().key(), "4").getOrCreate();
    }

    @AfterAll
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    protected BatchScan newScan(Table table) {
        SparkReadConf readConf = new SparkReadConf(spark, table, (Map)ImmutableMap.of());
        return new SparkDistributedDataScan(spark, table, readConf);
    }
}

