/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class ValidationHelpers {
    private ValidationHelpers() {
    }

    public static List<Long> dataSeqs(Long ... seqs) {
        return Arrays.asList(seqs);
    }

    public static List<Long> fileSeqs(Long ... seqs) {
        return Arrays.asList(seqs);
    }

    public static List<Long> snapshotIds(Long ... ids) {
        return Arrays.asList(ids);
    }

    public static List<String> files(ContentFile<?> ... files) {
        return Arrays.stream(files).map(ContentFile::location).collect(Collectors.toList());
    }

    public static void validateDataManifest(Table table, ManifestFile manifest, List<Long> dataSeqs, List<Long> fileSeqs, List<Long> snapshotIds, List<String> files) {
        ArrayList actualDataSeqs = Lists.newArrayList();
        ArrayList actualFileSeqs = Lists.newArrayList();
        ArrayList actualSnapshotIds = Lists.newArrayList();
        ArrayList actualFiles = Lists.newArrayList();
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io()).entries()) {
            actualDataSeqs.add(entry.dataSequenceNumber());
            actualFileSeqs.add(entry.fileSequenceNumber());
            actualSnapshotIds.add(entry.snapshotId());
            actualFiles.add(((DataFile)entry.file()).location());
        }
        ValidationHelpers.assertSameElements("data seqs", actualDataSeqs, dataSeqs);
        ValidationHelpers.assertSameElements("file seqs", actualFileSeqs, fileSeqs);
        ValidationHelpers.assertSameElements("snapshot IDs", actualSnapshotIds, snapshotIds);
        ValidationHelpers.assertSameElements("files", actualFiles, files);
    }

    private static <T> void assertSameElements(String context, List<T> actual, List<T> expected) {
        String errorMessage = String.format("%s must match", context);
        ((ListAssert)Assertions.assertThat(actual).as(errorMessage, new Object[0])).hasSameElementsAs(expected);
    }
}

