/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import scala.collection.Map;
import scala.collection.Seq;

public class SparkTestHelperBase {
    protected static final Object ANY = new Object();

    protected List<Object[]> rowsToJava(List<Row> rows) {
        return rows.stream().map(this::toJava).collect(Collectors.toList());
    }

    private Object[] toJava(Row row) {
        return IntStream.range(0, row.size()).mapToObj(pos -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            Object value = row.get(pos);
            if (value instanceof Row) {
                return this.toJava((Row)value);
            }
            if (value instanceof Seq) {
                return row.getList(pos);
            }
            if (value instanceof Map) {
                return row.getJavaMap(pos);
            }
            return value;
        }).toArray(Object[]::new);
    }

    protected void assertEquals(String context, List<Object[]> expectedRows, List<Object[]> actualRows) {
        ((ListAssert)Assertions.assertThat(actualRows).as(context + ": number of results should match", new Object[0])).hasSameSizeAs(expectedRows);
        for (int row = 0; row < expectedRows.size(); ++row) {
            Object[] expected = expectedRows.get(row);
            Object[] actual = actualRows.get(row);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).as("Number of columns should match", new Object[0])).hasSameSizeAs((Object)expected);
            for (int col = 0; col < actualRows.get(row).length; ++col) {
                String newContext = String.format("%s: row %d col %d", context, row + 1, col + 1);
                this.assertEquals(newContext, expected, actual);
            }
        }
    }

    protected void assertEquals(String context, Object[] expectedRow, Object[] actualRow) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualRow).as("Number of columns should match", new Object[0])).hasSameSizeAs((Object)expectedRow);
        for (int col = 0; col < actualRow.length; ++col) {
            Object expectedValue = expectedRow[col];
            Object actualValue = actualRow[col];
            if (expectedValue != null && expectedValue.getClass().isArray()) {
                String newContext = String.format("%s (nested col %d)", context, col + 1);
                if (expectedValue instanceof byte[]) {
                    ((ObjectAssert)Assertions.assertThat((Object)actualValue).as(newContext, new Object[0])).isEqualTo(expectedValue);
                    continue;
                }
                this.assertEquals(newContext, (Object[])expectedValue, (Object[])actualValue);
                continue;
            }
            if (expectedValue == ANY) continue;
            ((ObjectAssert)Assertions.assertThat((Object)actualValue).as(context + " contents should match", new Object[0])).isEqualTo(expectedValue);
        }
    }
}

