/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.inmemory.InMemoryCatalog;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTServerExtension;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.util.PropertyUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestBaseWithCatalog
extends TestBase {
    protected static File warehouse = null;
    @RegisterExtension
    private static final RESTServerExtension REST_SERVER_EXTENSION = new RESTServerExtension(Map.of("rest.port", "0", "clients", "1"));
    protected static RESTCatalog restCatalog;
    @TempDir
    protected java.nio.file.Path temp;
    @Parameter(index=0)
    protected String catalogName;
    @Parameter(index=1)
    protected String implementation;
    @Parameter(index=2)
    protected Map<String, String> catalogConfig;
    protected Catalog validationCatalog;
    protected SupportsNamespaces validationNamespaceCatalog;
    protected TableIdentifier tableIdent = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"table");
    protected String tableName;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties()}};
    }

    @BeforeAll
    public static void setUpAll() throws IOException {
        warehouse = File.createTempFile("warehouse", null);
        Assertions.assertThat((boolean)warehouse.delete()).isTrue();
        restCatalog = REST_SERVER_EXTENSION.client();
    }

    @AfterAll
    public static void tearDownAll() throws IOException {
        if (warehouse != null && warehouse.exists()) {
            Path warehousePath = new Path(warehouse.getAbsolutePath());
            FileSystem fs = warehousePath.getFileSystem((Configuration)hiveConf);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(warehousePath, true)).as("Failed to delete " + warehousePath, new Object[0])).isTrue();
        }
    }

    private void configureValidationCatalog() {
        if (this.catalogConfig.containsKey("type")) {
            switch (this.catalogConfig.get("type")) {
                case "hadoop": {
                    this.validationCatalog = new HadoopCatalog(spark.sessionState().newHadoopConf(), "file:" + warehouse);
                    break;
                }
                case "rest": {
                    this.validationCatalog = restCatalog;
                    break;
                }
                case "hive": {
                    this.validationCatalog = catalog;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown catalog type");
                }
            }
        } else if (this.catalogConfig.containsKey("catalog-impl")) {
            switch (this.catalogConfig.get("catalog-impl")) {
                case "org.apache.iceberg.inmemory.InMemoryCatalog": {
                    this.validationCatalog = new InMemoryCatalog();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown catalog impl");
                }
            }
        }
        this.validationNamespaceCatalog = (SupportsNamespaces)this.validationCatalog;
    }

    @BeforeEach
    public void before() {
        this.configureValidationCatalog();
        spark.conf().set("spark.sql.catalog." + this.catalogName, this.implementation);
        this.catalogConfig.forEach((key, value) -> spark.conf().set("spark.sql.catalog." + this.catalogName + "." + key, value));
        if ("hadoop".equalsIgnoreCase(this.catalogConfig.get("type"))) {
            spark.conf().set("spark.sql.catalog." + this.catalogName + ".warehouse", "file:" + warehouse);
        }
        this.tableName = (String)(this.catalogName.equals("spark_catalog") ? "" : this.catalogName + ".") + "default.table";
        this.sql("CREATE NAMESPACE IF NOT EXISTS default", new Object[0]);
    }

    protected String tableName(String name) {
        return (String)(this.catalogName.equals("spark_catalog") ? "" : this.catalogName + ".") + "default." + name;
    }

    protected String commitTarget() {
        return this.tableName;
    }

    protected String selectTarget() {
        return this.tableName;
    }

    protected boolean cachingCatalogEnabled() {
        return PropertyUtil.propertyAsBoolean(this.catalogConfig, (String)"cache-enabled", (boolean)true);
    }

    protected void configurePlanningMode(PlanningMode planningMode) {
        this.configurePlanningMode(this.tableName, planningMode);
    }

    protected void configurePlanningMode(String table, PlanningMode planningMode) {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s', '%s' '%s')", table, "read.data-planning-mode", planningMode.modeName(), "read.delete-planning-mode", planningMode.modeName());
    }
}

