/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.ChangelogIterator;
import org.apache.iceberg.spark.SparkTestHelperBase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChangelogIterator
extends SparkTestHelperBase {
    private static final String DELETE = ChangelogOperation.DELETE.name();
    private static final String INSERT = ChangelogOperation.INSERT.name();
    private static final String UPDATE_BEFORE = ChangelogOperation.UPDATE_BEFORE.name();
    private static final String UPDATE_AFTER = ChangelogOperation.UPDATE_AFTER.name();
    private static final StructType SCHEMA = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("name", DataTypes.StringType, false, Metadata.empty()), new StructField("data", DataTypes.StringType, true, Metadata.empty()), new StructField(MetadataColumns.CHANGE_TYPE.name(), DataTypes.StringType, false, Metadata.empty()), new StructField(MetadataColumns.CHANGE_ORDINAL.name(), DataTypes.IntegerType, false, Metadata.empty()), new StructField(MetadataColumns.COMMIT_SNAPSHOT_ID.name(), DataTypes.LongType, false, Metadata.empty())});
    private static final String[] IDENTIFIER_FIELDS = new String[]{"id", "name"};

    @Test
    public void testIterator() {
        ArrayList permutations = Lists.newArrayList();
        this.permute(Arrays.asList(RowType.DELETED, RowType.INSERTED, RowType.CARRY_OVER, RowType.UPDATED), 0, permutations);
        Assertions.assertThat((List)permutations).hasSize(24);
        for (Object[] permutation : permutations) {
            this.validate(permutation);
        }
    }

    private void validate(Object[] permutation) {
        ArrayList rows = Lists.newArrayList();
        ArrayList expectedRows = Lists.newArrayList();
        for (int i = 0; i < permutation.length; ++i) {
            rows.addAll(this.toOriginalRows((RowType)((Object)permutation[i]), i));
            expectedRows.addAll(this.toExpectedRows((RowType)((Object)permutation[i]), i));
        }
        Iterator iterator = ChangelogIterator.computeUpdates(rows.iterator(), (StructType)SCHEMA, (String[])IDENTIFIER_FIELDS);
        ArrayList result = Lists.newArrayList((Iterator)iterator);
        this.assertEquals("Rows should match", expectedRows, this.rowsToJava(result));
    }

    private List<Row> toOriginalRows(RowType rowType, int index) {
        switch (rowType) {
            case DELETED: {
                return Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{index, "b", "data", DELETE, 0, 0}, null)});
            }
            case INSERTED: {
                return Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{index, "c", "data", INSERT, 0, 0}, null)});
            }
            case CARRY_OVER: {
                return Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{index, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{index, "d", "data", INSERT, 0, 0}, null)});
            }
            case UPDATED: {
                return Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{index, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{index, "a", "new_data", INSERT, 0, 0}, null)});
            }
        }
        throw new IllegalArgumentException("Unknown row type: " + rowType);
    }

    private List<Object[]> toExpectedRows(RowType rowType, int order) {
        switch (rowType) {
            case DELETED: {
                ArrayList rows = Lists.newArrayList();
                rows.add(new Object[]{order, "b", "data", DELETE, 0, 0});
                return rows;
            }
            case INSERTED: {
                ArrayList insertedRows = Lists.newArrayList();
                insertedRows.add(new Object[]{order, "c", "data", INSERT, 0, 0});
                return insertedRows;
            }
            case CARRY_OVER: {
                return Lists.newArrayList();
            }
            case UPDATED: {
                return Lists.newArrayList((Object[])new Object[][]{{order, "a", "data", UPDATE_BEFORE, 0, 0}, {order, "a", "new_data", UPDATE_AFTER, 0, 0}});
            }
        }
        throw new IllegalArgumentException("Unknown row type: " + rowType);
    }

    private void permute(List<RowType> arr, int start, List<Object[]> pm) {
        for (int i = start; i < arr.size(); ++i) {
            Collections.swap(arr, i, start);
            this.permute(arr, start + 1, pm);
            Collections.swap(arr, start, i);
        }
        if (start == arr.size() - 1) {
            pm.add(arr.toArray());
        }
    }

    @Test
    public void testRowsWithNullValue() {
        ArrayList rowsWithNull = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{2, null, null, DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{3, null, null, INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{4, null, null, DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{4, null, null, INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{5, null, null, DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{5, null, "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{6, null, null, DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{6, "name", null, INSERT, 0, 0}, null)});
        Iterator iterator = ChangelogIterator.computeUpdates(rowsWithNull.iterator(), (StructType)SCHEMA, (String[])IDENTIFIER_FIELDS);
        ArrayList result = Lists.newArrayList((Iterator)iterator);
        this.assertEquals("Rows should match", Lists.newArrayList((Object[])new Object[][]{{2, null, null, DELETE, 0, 0}, {3, null, null, INSERT, 0, 0}, {5, null, null, UPDATE_BEFORE, 0, 0}, {5, null, "data", UPDATE_AFTER, 0, 0}, {6, null, null, DELETE, 0, 0}, {6, "name", null, INSERT, 0, 0}}), this.rowsToJava(result));
    }

    @Test
    public void testUpdatedRowsWithDuplication() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{1, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "new_data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "new_data", INSERT, 0, 0}, null)});
        Iterator iterator = ChangelogIterator.computeUpdates(rowsWithDuplication.iterator(), (StructType)SCHEMA, (String[])IDENTIFIER_FIELDS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Lists.newArrayList((Iterator)iterator)).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot compute updates because there are multiple rows with the same identifier fields([id,name]). Please make sure the rows are unique.");
        rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{1, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "new_data1", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "new_data2", INSERT, 0, 0}, null)});
        Iterator iterator1 = ChangelogIterator.computeUpdates(rowsWithDuplication.iterator(), (StructType)SCHEMA, (String[])IDENTIFIER_FIELDS);
        this.assertEquals("Rows should match.", Lists.newArrayList((Object[])new Object[][]{{1, "a", "data", UPDATE_BEFORE, 0, 0}, {1, "a", "new_data1", UPDATE_AFTER, 0, 0}, {1, "a", "new_data2", INSERT, 0, 0}}), this.rowsToJava(Lists.newArrayList((Iterator)iterator1)));
    }

    @Test
    public void testCarryRowsRemoveWithDuplicates() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{0, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{0, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{0, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "old_data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "a", "old_data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{2, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{2, "a", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{2, "a", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{2, "a", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{3, "a", "new_data", INSERT, 0, 0}, null)});
        ArrayList expectedRows = Lists.newArrayList((Object[])new Object[][]{{0, "a", "data", DELETE, 0, 0}, {0, "a", "data", DELETE, 0, 0}, {0, "a", "data", DELETE, 0, 0}, {1, "a", "old_data", DELETE, 0, 0}, {1, "a", "old_data", DELETE, 0, 0}, {3, "a", "new_data", INSERT, 0, 0}});
        this.validateIterators(rowsWithDuplication, expectedRows);
    }

    @Test
    public void testCarryRowsRemoveLessInsertRows() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{2, "d", "data", INSERT, 0, 0}, null)});
        ArrayList expectedRows = Lists.newArrayList((Object[])new Object[][]{{1, "d", "data", DELETE, 0, 0}, {2, "d", "data", INSERT, 0, 0}});
        this.validateIterators(rowsWithDuplication, expectedRows);
    }

    @Test
    public void testCarryRowsRemoveMoreInsertRows() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{0, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null)});
        ArrayList expectedRows = Lists.newArrayList((Object[])new Object[][]{{0, "d", "data", DELETE, 0, 0}, {1, "d", "data", INSERT, 0, 0}});
        this.validateIterators(rowsWithDuplication, expectedRows);
    }

    @Test
    public void testCarryRowsRemoveNoInsertRows() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null)});
        ArrayList expectedRows = Lists.newArrayList((Object[])new Object[][]{{1, "d", "data", DELETE, 0, 0}, {1, "d", "data", DELETE, 0, 0}});
        this.validateIterators(rowsWithDuplication, expectedRows);
    }

    private void validateIterators(List<Row> rowsWithDuplication, List<Object[]> expectedRows) {
        Iterator iterator = ChangelogIterator.removeCarryovers(rowsWithDuplication.iterator(), (StructType)SCHEMA);
        ArrayList result = Lists.newArrayList((Iterator)iterator);
        this.assertEquals("Rows should match.", expectedRows, this.rowsToJava(result));
        iterator = ChangelogIterator.removeNetCarryovers(rowsWithDuplication.iterator(), (StructType)SCHEMA);
        result = Lists.newArrayList((Iterator)iterator);
        this.assertEquals("Rows should match.", expectedRows, this.rowsToJava(result));
    }

    @Test
    public void testRemoveNetCarryovers() {
        ArrayList rowsWithDuplication = Lists.newArrayList((Object[])new Row[]{new GenericRowWithSchema(new Object[]{0, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 0, 0}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 1, 1}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 1, 1}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 1, 1}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 1, 1}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 2, 2}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", DELETE, 3, 3}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 4, 4}, null), new GenericRowWithSchema(new Object[]{1, "d", "data", INSERT, 4, 4}, null), new GenericRowWithSchema(new Object[]{2, "d", "data", DELETE, 4, 4}, null)});
        ArrayList expectedRows = Lists.newArrayList((Object[])new Object[][]{{0, "d", "data", DELETE, 0, 0}, {1, "d", "data", INSERT, 4, 4}, {1, "d", "data", INSERT, 4, 4}, {2, "d", "data", DELETE, 4, 4}});
        Iterator iterator = ChangelogIterator.removeNetCarryovers(rowsWithDuplication.iterator(), (StructType)SCHEMA);
        ArrayList result = Lists.newArrayList((Iterator)iterator);
        this.assertEquals("Rows should match.", expectedRows, this.rowsToJava(result));
    }

    private static enum RowType {
        DELETED,
        INSERTED,
        CARRY_OVER,
        UPDATED;

    }
}

