/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSpark3Util
extends TestBase {
    @Test
    public void testDescribeSortOrder() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"time", (Type)Types.TimestampType.withoutZone())});
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("Identity", schema, 1))).as("Sort order isn't correct.", new Object[0])).isEqualTo("data DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("bucket[1]", schema, 1))).as("Sort order isn't correct.", new Object[0])).isEqualTo("bucket(1, data) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("truncate[3]", schema, 1))).as("Sort order isn't correct.", new Object[0])).isEqualTo("truncate(data, 3) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("year", schema, 2))).as("Sort order isn't correct.", new Object[0])).isEqualTo("years(time) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("month", schema, 2))).as("Sort order isn't correct.", new Object[0])).isEqualTo("months(time) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("day", schema, 2))).as("Sort order isn't correct.", new Object[0])).isEqualTo("days(time) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("hour", schema, 2))).as("Sort order isn't correct.", new Object[0])).isEqualTo("hours(time) DESC NULLS FIRST");
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)this.buildSortOrder("unknown", schema, 1))).as("Sort order isn't correct.", new Object[0])).isEqualTo("unknown(data) DESC NULLS FIRST");
        SortOrder multiOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("time", NullOrder.NULLS_FIRST)).asc("data", NullOrder.NULLS_LAST)).build();
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((SortOrder)multiOrder)).as("Sort order isn't correct.", new Object[0])).isEqualTo("time ASC NULLS FIRST, data ASC NULLS LAST");
    }

    @Test
    public void testDescribeSchema() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.ListType.ofRequired((int)2, (Type)Types.StringType.get())), Types.NestedField.optional((int)3, (String)"pairs", (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.LongType.get())), Types.NestedField.required((int)6, (String)"time", (Type)Types.TimestampType.withoutZone())});
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((Schema)schema)).as("Schema description isn't correct.", new Object[0])).isEqualTo("struct<data: list<string> not null,pairs: map<string, bigint>,time: timestamp not null>");
    }

    @Test
    public void testLoadIcebergTable() throws Exception {
        spark.conf().set("spark.sql.catalog.hive", SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog.hive.type", "hive");
        spark.conf().set("spark.sql.catalog.hive.default-namespace", "default");
        String tableFullName = "hive.default.tbl";
        this.sql("CREATE TABLE %s (c1 bigint, c2 string, c3 string) USING iceberg", tableFullName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)tableFullName);
        Assertions.assertThat((String)table.name()).isEqualTo(tableFullName);
    }

    @Test
    public void testLoadIcebergCatalog() throws Exception {
        spark.conf().set("spark.sql.catalog.test_cat", SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog.test_cat.type", "hive");
        Catalog catalog = Spark3Util.loadIcebergCatalog((SparkSession)spark, (String)"test_cat");
        ((ObjectAssert)Assertions.assertThat((Object)catalog).as("Should retrieve underlying catalog class", new Object[0])).isInstanceOf(CachingCatalog.class);
    }

    @Test
    public void testDescribeExpression() {
        UnboundPredicate refExpression = Expressions.equal((String)"id", (Object)1);
        Assertions.assertThat((String)Spark3Util.describe((Expression)refExpression)).isEqualTo("id = 1");
        UnboundPredicate yearExpression = Expressions.greaterThan((UnboundTerm)Expressions.year((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)yearExpression)).isEqualTo("year(ts) > 10");
        UnboundPredicate monthExpression = Expressions.greaterThanOrEqual((UnboundTerm)Expressions.month((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)monthExpression)).isEqualTo("month(ts) >= 10");
        UnboundPredicate dayExpression = Expressions.lessThan((UnboundTerm)Expressions.day((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)dayExpression)).isEqualTo("day(ts) < 10");
        UnboundPredicate hourExpression = Expressions.lessThanOrEqual((UnboundTerm)Expressions.hour((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)hourExpression)).isEqualTo("hour(ts) <= 10");
        UnboundPredicate bucketExpression = Expressions.in((UnboundTerm)Expressions.bucket((String)"id", (int)5), (Object[])new Integer[]{3});
        Assertions.assertThat((String)Spark3Util.describe((Expression)bucketExpression)).isEqualTo("bucket[5](id) IN (3)");
        UnboundPredicate truncateExpression = Expressions.notIn((UnboundTerm)Expressions.truncate((String)"name", (int)3), (Object[])new String[]{"abc"});
        Assertions.assertThat((String)Spark3Util.describe((Expression)truncateExpression)).isEqualTo("truncate[3](name) NOT IN ('abc')");
        Expression andExpression = Expressions.and((Expression)refExpression, (Expression)yearExpression);
        Assertions.assertThat((String)Spark3Util.describe((Expression)andExpression)).isEqualTo("(id = 1 AND year(ts) > 10)");
    }

    private SortOrder buildSortOrder(String transform, Schema schema, int sourceId) {
        String jsonString = "{\n  \"order-id\" : 10,\n  \"fields\" : [ {\n    \"transform\" : \"" + transform + "\",\n    \"source-id\" : " + sourceId + ",\n    \"direction\" : \"desc\",\n    \"null-order\" : \"nulls-first\"\n  } ]\n}";
        return SortOrderParser.fromJson((Schema)schema, (String)jsonString);
    }
}

