/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.BaseCatalog;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkCatalogOperations
extends CatalogTestBase {
    private static final boolean USE_NULLABLE_QUERY_SCHEMA = ThreadLocalRandom.current().nextBoolean();

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"use-nullable-query-schema", (Object)Boolean.toString(USE_NULLABLE_QUERY_SCHEMA))}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"cache-enabled", (Object)"false", (Object)"use-nullable-query-schema", (Object)Boolean.toString(USE_NULLABLE_QUERY_SCHEMA))}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false", (Object)"use-nullable-query-schema", (Object)Boolean.toString(USE_NULLABLE_QUERY_SCHEMA))}};
    }

    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testAlterTable() throws NoSuchTableException {
        BaseCatalog catalog = (BaseCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        String fieldName = "location";
        String propsKey = "note";
        String propsValue = "jazz";
        org.apache.spark.sql.connector.catalog.Table table = catalog.alterTable(identifier, new TableChange[]{TableChange.addColumn((String[])new String[]{fieldName}, (DataType)DataTypes.StringType, (boolean)true), TableChange.setProperty((String)propsKey, (String)propsValue)});
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should return updated table", new Object[0])).isNotNull();
        StructField expectedField = DataTypes.createStructField((String)fieldName, (DataType)DataTypes.StringType, (boolean)true);
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().fields()[2]).as("Adding a column to a table should return the updated table with the new column", new Object[0])).isEqualTo((Object)expectedField);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Adding a property to a table should return the updated table with the new property with the new correct value", new Object[0])).containsEntry((Object)propsKey, (Object)propsValue);
    }

    @TestTemplate
    public void testInvalidateTable() {
        this.sql("SELECT count(1) FROM %s", this.tableName);
        Catalog anotherCatalog = this.validationCatalog;
        Schema schema = anotherCatalog.loadTable(this.tableIdent).schema();
        anotherCatalog.dropTable(this.tableIdent);
        anotherCatalog.createTable(this.tableIdent, schema);
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("SELECT count(1) FROM %s", this.tableName);
    }

    @TestTemplate
    public void testCTASUseNullableQuerySchema() {
        this.sql("INSERT INTO %s VALUES(1, 'abc'), (2, null)", this.tableName);
        String ctasTableName = this.tableName("ctas_table");
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", ctasTableName, this.tableName);
        Table ctasTable = this.validationCatalog.loadTable(TableIdentifier.parse((String)"default.ctas_table"));
        Schema expectedSchema = new Schema(new Types.NestedField[]{USE_NULLABLE_QUERY_SCHEMA ? Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()) : Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.schema().asStruct()).as("Should have expected schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        this.sql("DROP TABLE IF EXISTS %s", ctasTableName);
    }

    @TestTemplate
    public void testRTASUseNullableQuerySchema() {
        this.sql("INSERT INTO %s VALUES(1, 'abc'), (2, null)", this.tableName);
        String rtasTableName = this.tableName("rtas_table");
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", rtasTableName);
        this.sql("REPLACE TABLE %s USING iceberg AS SELECT * FROM %s", rtasTableName, this.tableName);
        Table rtasTable = this.validationCatalog.loadTable(TableIdentifier.parse((String)"default.rtas_table"));
        Schema expectedSchema = new Schema(new Types.NestedField[]{USE_NULLABLE_QUERY_SCHEMA ? Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()) : Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", rtasTableName));
        this.sql("DROP TABLE IF EXISTS %s", rtasTableName);
    }
}

