/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.FileFormat;
import org.apache.iceberg.spark.SparkCompressionUtil;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestSparkCompressionUtil {
    private SparkSession spark;
    private SparkConf sparkConf;

    @BeforeEach
    public void initSpark() {
        this.spark = (SparkSession)Mockito.mock(SparkSession.class);
        this.sparkConf = (SparkConf)Mockito.mock(SparkConf.class);
        SparkContext sparkContext = (SparkContext)Mockito.mock(SparkContext.class);
        Mockito.when((Object)this.spark.sparkContext()).thenReturn((Object)sparkContext);
        Mockito.when((Object)sparkContext.conf()).thenReturn((Object)this.sparkConf);
    }

    @Test
    public void testParquetCompressionRatios() {
        this.configureShuffle("lz4", true);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.PARQUET, "zstd");
        Assertions.assertThat((double)ratio1).isEqualTo(3.0);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.PARQUET, "gzip");
        Assertions.assertThat((double)ratio2).isEqualTo(3.0);
        double ratio3 = this.shuffleCompressionRatio(FileFormat.PARQUET, "snappy");
        Assertions.assertThat((double)ratio3).isEqualTo(2.0);
    }

    @Test
    public void testOrcCompressionRatios() {
        this.configureShuffle("lz4", true);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.ORC, "zlib");
        Assertions.assertThat((double)ratio1).isEqualTo(3.0);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.ORC, "lz4");
        Assertions.assertThat((double)ratio2).isEqualTo(2.0);
    }

    @Test
    public void testAvroCompressionRatios() {
        this.configureShuffle("lz4", true);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.AVRO, "gzip");
        Assertions.assertThat((double)ratio1).isEqualTo(1.5);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.AVRO, "zstd");
        Assertions.assertThat((double)ratio2).isEqualTo(1.5);
    }

    @Test
    public void testCodecNameNormalization() {
        this.configureShuffle("zStD", true);
        double ratio = this.shuffleCompressionRatio(FileFormat.PARQUET, "ZstD");
        Assertions.assertThat((double)ratio).isEqualTo(2.0);
    }

    @Test
    public void testUnknownCodecNames() {
        this.configureShuffle("SOME_SPARK_CODEC", true);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.PARQUET, "SOME_PARQUET_CODEC");
        Assertions.assertThat((double)ratio1).isEqualTo(2.0);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.ORC, "SOME_ORC_CODEC");
        Assertions.assertThat((double)ratio2).isEqualTo(2.0);
        double ratio3 = this.shuffleCompressionRatio(FileFormat.AVRO, "SOME_AVRO_CODEC");
        Assertions.assertThat((double)ratio3).isEqualTo(1.0);
    }

    @Test
    public void testOtherFileFormats() {
        this.configureShuffle("lz4", true);
        double ratio = this.shuffleCompressionRatio(FileFormat.METADATA, "zstd");
        Assertions.assertThat((double)ratio).isEqualTo(1.0);
    }

    @Test
    public void testNullFileCodec() {
        this.configureShuffle("lz4", true);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.PARQUET, null);
        Assertions.assertThat((double)ratio1).isEqualTo(2.0);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.ORC, null);
        Assertions.assertThat((double)ratio2).isEqualTo(2.0);
        double ratio3 = this.shuffleCompressionRatio(FileFormat.AVRO, null);
        Assertions.assertThat((double)ratio3).isEqualTo(1.0);
    }

    @Test
    public void testUncompressedShuffles() {
        this.configureShuffle("zstd", false);
        double ratio1 = this.shuffleCompressionRatio(FileFormat.PARQUET, "zstd");
        Assertions.assertThat((double)ratio1).isEqualTo(4.0);
        double ratio2 = this.shuffleCompressionRatio(FileFormat.ORC, "zlib");
        Assertions.assertThat((double)ratio2).isEqualTo(4.0);
        double ratio3 = this.shuffleCompressionRatio(FileFormat.AVRO, "gzip");
        Assertions.assertThat((double)ratio3).isEqualTo(2.0);
    }

    @Test
    public void testSparkDefaults() {
        Assertions.assertThat((String)package$.MODULE$.SHUFFLE_COMPRESS().defaultValueString()).isEqualTo("true");
        Assertions.assertThat((String)package$.MODULE$.IO_COMPRESSION_CODEC().defaultValueString()).isEqualTo("lz4");
    }

    private void configureShuffle(String codec, boolean compress) {
        Mockito.when((Object)this.sparkConf.getBoolean((String)ArgumentMatchers.eq((Object)"spark.shuffle.compress"), ArgumentMatchers.anyBoolean())).thenReturn((Object)compress);
        Mockito.when((Object)this.sparkConf.get((String)ArgumentMatchers.eq((Object)"spark.io.compression.codec"), ArgumentMatchers.anyString())).thenReturn((Object)codec);
    }

    private double shuffleCompressionRatio(FileFormat fileFormat, String codec) {
        return SparkCompressionUtil.shuffleCompressionRatio((SparkSession)this.spark, (FileFormat)fileFormat, (String)codec);
    }
}

