/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSparkFilters {
    @Test
    public void testQuotedAttributes() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            IsNull isNull = IsNull.apply((String)quoted);
            UnboundPredicate expectedIsNull = Expressions.isNull((String)unquoted);
            Expression actualIsNull = SparkFilters.convert((Filter)isNull);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIsNull.toString()).as("IsNull must match", new Object[0])).isEqualTo(expectedIsNull.toString());
            IsNotNull isNotNull = IsNotNull.apply((String)quoted);
            UnboundPredicate expectedIsNotNull = Expressions.notNull((String)unquoted);
            Expression actualIsNotNull = SparkFilters.convert((Filter)isNotNull);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIsNotNull.toString()).as("IsNotNull must match", new Object[0])).isEqualTo(expectedIsNotNull.toString());
            LessThan lt = LessThan.apply((String)quoted, (Object)1);
            UnboundPredicate expectedLt = Expressions.lessThan((String)unquoted, (Object)1);
            Expression actualLt = SparkFilters.convert((Filter)lt);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLt.toString()).as("LessThan must match", new Object[0])).isEqualTo(expectedLt.toString());
            LessThanOrEqual ltEq = LessThanOrEqual.apply((String)quoted, (Object)1);
            UnboundPredicate expectedLtEq = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            Expression actualLtEq = SparkFilters.convert((Filter)ltEq);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLtEq.toString()).as("LessThanOrEqual must match", new Object[0])).isEqualTo(expectedLtEq.toString());
            GreaterThan gt = GreaterThan.apply((String)quoted, (Object)1);
            UnboundPredicate expectedGt = Expressions.greaterThan((String)unquoted, (Object)1);
            Expression actualGt = SparkFilters.convert((Filter)gt);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGt.toString()).as("GreaterThan must match", new Object[0])).isEqualTo(expectedGt.toString());
            GreaterThanOrEqual gtEq = GreaterThanOrEqual.apply((String)quoted, (Object)1);
            UnboundPredicate expectedGtEq = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            Expression actualGtEq = SparkFilters.convert((Filter)gtEq);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGtEq.toString()).as("GreaterThanOrEqual must match", new Object[0])).isEqualTo(expectedGtEq.toString());
            EqualTo eq = EqualTo.apply((String)quoted, (Object)1);
            UnboundPredicate expectedEq = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEq = SparkFilters.convert((Filter)eq);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEq.toString()).as("EqualTo must match", new Object[0])).isEqualTo(expectedEq.toString());
            EqualNullSafe eqNullSafe = EqualNullSafe.apply((String)quoted, (Object)1);
            UnboundPredicate expectedEqNullSafe = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEqNullSafe = SparkFilters.convert((Filter)eqNullSafe);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEqNullSafe.toString()).as("EqualNullSafe must match", new Object[0])).isEqualTo(expectedEqNullSafe.toString());
            In in = In.apply((String)quoted, (Object[])new Integer[]{1});
            UnboundPredicate expectedIn = Expressions.in((String)unquoted, (Object[])new Integer[]{1});
            Expression actualIn = SparkFilters.convert((Filter)in);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIn.toString()).as("In must match", new Object[0])).isEqualTo(expectedIn.toString());
        });
    }

    @Test
    public void testTimestampFilterConversion() {
        Instant instant = Instant.parse("2018-10-18T00:00:57.907Z");
        Timestamp timestamp = Timestamp.from(instant);
        long epochMicros = ChronoUnit.MICROS.between(Instant.EPOCH, instant);
        Expression instantExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)instant));
        Expression timestampExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)timestamp));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        ((AbstractStringAssert)Assertions.assertThat((String)timestampExpression.toString()).as("Generated Timestamp expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
        ((AbstractStringAssert)Assertions.assertThat((String)instantExpression.toString()).as("Generated Instant expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
    }

    @Test
    public void testLocalDateTimeFilterConversion() {
        LocalDateTime ldt = LocalDateTime.parse("2018-10-18T00:00:57");
        long epochMicros = ChronoUnit.MICROS.between(LocalDateTime.ofInstant(Instant.EPOCH, ZoneId.of("UTC")), ldt);
        Expression instantExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)ldt));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        ((AbstractStringAssert)Assertions.assertThat((String)instantExpression.toString()).as("Generated Instant expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
    }

    @Test
    public void testDateFilterConversion() {
        LocalDate localDate = LocalDate.parse("2018-10-18");
        Date date = Date.valueOf(localDate);
        long epochDay = localDate.toEpochDay();
        Expression localDateExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)localDate));
        Expression dateExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)date));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochDay);
        ((AbstractStringAssert)Assertions.assertThat((String)localDateExpression.toString()).as("Generated localdate expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
        ((AbstractStringAssert)Assertions.assertThat((String)dateExpression.toString()).as("Generated date expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
    }

    @Test
    public void testNestedInInsideNot() {
        Not filter = Not.apply((Filter)And.apply((Filter)EqualTo.apply((String)"col1", (Object)1), (Filter)In.apply((String)"col2", (Object[])new Integer[]{1, 2})));
        Expression converted = SparkFilters.convert((Filter)filter);
        ((ObjectAssert)Assertions.assertThat((Object)converted).as("Expression should not be converted", new Object[0])).isNull();
    }

    @Test
    public void testNotIn() {
        Not filter = Not.apply((Filter)In.apply((String)"col", (Object[])new Integer[]{1, 2}));
        Expression actual = SparkFilters.convert((Filter)filter);
        Expression expected = Expressions.and((Expression)Expressions.notNull((String)"col"), (Expression)Expressions.notIn((String)"col", (Object[])new Integer[]{1, 2}));
        ((AbstractStringAssert)Assertions.assertThat((String)actual.toString()).as("Expressions should match", new Object[0])).isEqualTo(expected.toString());
    }
}

