/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.spark.TestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSparkSessionCatalog
extends TestBase {
    private final String envHmsUriKey;
    private final String catalogHmsUriKey = "spark.sql.catalog.spark_catalog.uri";
    private final String hmsUri;

    public TestSparkSessionCatalog() {
        this.envHmsUriKey = "spark.hadoop." + HiveConf.ConfVars.METASTOREURIS.varname;
        this.catalogHmsUriKey = "spark.sql.catalog.spark_catalog.uri";
        this.hmsUri = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    @BeforeAll
    public static void setUpCatalog() {
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
        spark.conf().set("spark.sql.catalog.spark_catalog.type", "hive");
    }

    @BeforeEach
    public void setupHmsUri() {
        spark.sessionState().catalogManager().reset();
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", this.hmsUri);
    }

    @Test
    public void testValidateHmsUri() {
        Assertions.assertThat((String)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0]).isEqualTo("default");
        spark.sessionState().catalogManager().reset();
        String catalogHmsUri = "RandomString";
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", catalogHmsUri);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sessionState().catalogManager().v2SessionCatalog()).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Inconsistent Hive metastore URIs: %s (Spark session) != %s (spark_catalog)", this.hmsUri, catalogHmsUri));
        spark.sessionState().catalogManager().reset();
        spark.conf().set("spark.sql.catalog.spark_catalog.uri", this.hmsUri);
        spark.conf().unset(this.envHmsUriKey);
        Assertions.assertThat((String)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0]).isEqualTo("default");
        spark.sessionState().catalogManager().reset();
        spark.conf().set(this.envHmsUriKey, this.hmsUri);
        spark.conf().unset("spark.sql.catalog.spark_catalog.uri");
        Assertions.assertThat((String)spark.sessionState().catalogManager().v2SessionCatalog().defaultNamespace()[0]).isEqualTo("default");
    }

    @Test
    public void testLoadFunction() {
        String functionClass = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
        spark.sql(String.format("CREATE FUNCTION perm_upper AS '%s'", functionClass));
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT perm_upper('xyz')", new Object[0])).as("Load permanent UDF in Hive", new Object[0])).isEqualTo((Object)"XYZ");
        spark.sql(String.format("CREATE TEMPORARY FUNCTION temp_upper AS '%s'", functionClass));
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT temp_upper('xyz')", new Object[0])).as("Load temporary UDF in Hive", new Object[0])).isEqualTo((Object)"XYZ");
    }
}

