/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkTableUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSparkTableUtil {
    @Test
    public void testSparkPartitionOKryoSerialization() throws IOException {
        ImmutableMap values = ImmutableMap.of((Object)"id", (Object)"2");
        String uri = "s3://bucket/table/data/id=2";
        String format = "parquet";
        SparkTableUtil.SparkPartition sparkPartition = new SparkTableUtil.SparkPartition((Map)values, uri, format);
        SparkTableUtil.SparkPartition deserialized = KryoHelpers.roundTripSerialize(sparkPartition);
        Assertions.assertThat((Object)sparkPartition).isEqualTo((Object)deserialized);
    }

    @Test
    public void testSparkPartitionJavaSerialization() throws IOException, ClassNotFoundException {
        ImmutableMap values = ImmutableMap.of((Object)"id", (Object)"2");
        String uri = "s3://bucket/table/data/id=2";
        String format = "parquet";
        SparkTableUtil.SparkPartition sparkPartition = new SparkTableUtil.SparkPartition((Map)values, uri, format);
        SparkTableUtil.SparkPartition deserialized = (SparkTableUtil.SparkPartition)TestHelpers.roundTripSerialize((Object)sparkPartition);
        Assertions.assertThat((Object)sparkPartition).isEqualTo((Object)deserialized);
    }

    @Test
    public void testMetricsConfigKryoSerialization() throws Exception {
        ImmutableMap metricsConfig = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"counts", (Object)"write.metadata.metrics.column.col1", (Object)"full", (Object)"write.metadata.metrics.column.col2", (Object)"truncate(16)");
        MetricsConfig config = MetricsConfig.fromProperties((Map)metricsConfig);
        MetricsConfig deserialized = KryoHelpers.roundTripSerialize(config);
        Assertions.assertThat((String)deserialized.columnMode("col1").toString()).isEqualTo(MetricsModes.Full.get().toString());
        Assertions.assertThat((String)deserialized.columnMode("col2").toString()).isEqualTo(MetricsModes.Truncate.withLength((int)16).toString());
        Assertions.assertThat((String)deserialized.columnMode("col3").toString()).isEqualTo(MetricsModes.Counts.get().toString());
    }

    @Test
    public void testMetricsConfigJavaSerialization() throws Exception {
        ImmutableMap metricsConfig = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"counts", (Object)"write.metadata.metrics.column.col1", (Object)"full", (Object)"write.metadata.metrics.column.col2", (Object)"truncate(16)");
        MetricsConfig config = MetricsConfig.fromProperties((Map)metricsConfig);
        MetricsConfig deserialized = (MetricsConfig)TestHelpers.roundTripSerialize((Object)config);
        Assertions.assertThat((String)deserialized.columnMode("col1").toString()).isEqualTo(MetricsModes.Full.get().toString());
        Assertions.assertThat((String)deserialized.columnMode("col2").toString()).isEqualTo(MetricsModes.Truncate.withLength((int)16).toString());
        Assertions.assertThat((String)deserialized.columnMode("col3").toString()).isEqualTo(MetricsModes.Counts.get().toString());
    }
}

