/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkV2Filters;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.DaysFunction;
import org.apache.iceberg.spark.functions.HoursFunction;
import org.apache.iceberg.spark.functions.IcebergVersionFunction;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.iceberg.spark.functions.YearsFunction;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.UserDefinedScalarFunc;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSparkV2Filters {
    private static final Types.StructType STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"dateCol", (Type)Types.DateType.get()), Types.NestedField.optional((int)2, (String)"tsCol", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)3, (String)"tsNtzCol", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)4, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"strCol", (Type)Types.StringType.get())});

    @Test
    public void testV2Filters() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            NamedReference namedReference = FieldReference.apply((String)quoted);
            org.apache.spark.sql.connector.expressions.Expression[] attrOnly = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference};
            LiteralValue value = new LiteralValue((Object)1, DataTypes.IntegerType);
            org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, value};
            org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{value, namedReference};
            Predicate isNull = new Predicate("IS_NULL", attrOnly);
            UnboundPredicate expectedIsNull = Expressions.isNull((String)unquoted);
            Expression actualIsNull = SparkV2Filters.convert((Predicate)isNull);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIsNull.toString()).as("IsNull must match", new Object[0])).isEqualTo(expectedIsNull.toString());
            Predicate isNotNull = new Predicate("IS_NOT_NULL", attrOnly);
            UnboundPredicate expectedIsNotNull = Expressions.notNull((String)unquoted);
            Expression actualIsNotNull = SparkV2Filters.convert((Predicate)isNotNull);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIsNotNull.toString()).as("IsNotNull must match", new Object[0])).isEqualTo(expectedIsNotNull.toString());
            Predicate lt1 = new Predicate("<", attrAndValue);
            UnboundPredicate expectedLt1 = Expressions.lessThan((String)unquoted, (Object)1);
            Expression actualLt1 = SparkV2Filters.convert((Predicate)lt1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLt1.toString()).as("LessThan must match", new Object[0])).isEqualTo(expectedLt1.toString());
            Predicate lt2 = new Predicate("<", valueAndAttr);
            UnboundPredicate expectedLt2 = Expressions.greaterThan((String)unquoted, (Object)1);
            Expression actualLt2 = SparkV2Filters.convert((Predicate)lt2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLt2.toString()).as("LessThan must match", new Object[0])).isEqualTo(expectedLt2.toString());
            Predicate ltEq1 = new Predicate("<=", attrAndValue);
            UnboundPredicate expectedLtEq1 = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            Expression actualLtEq1 = SparkV2Filters.convert((Predicate)ltEq1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLtEq1.toString()).as("LessThanOrEqual must match", new Object[0])).isEqualTo(expectedLtEq1.toString());
            Predicate ltEq2 = new Predicate("<=", valueAndAttr);
            UnboundPredicate expectedLtEq2 = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            Expression actualLtEq2 = SparkV2Filters.convert((Predicate)ltEq2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualLtEq2.toString()).as("LessThanOrEqual must match", new Object[0])).isEqualTo(expectedLtEq2.toString());
            Predicate gt1 = new Predicate(">", attrAndValue);
            UnboundPredicate expectedGt1 = Expressions.greaterThan((String)unquoted, (Object)1);
            Expression actualGt1 = SparkV2Filters.convert((Predicate)gt1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGt1.toString()).as("GreaterThan must match", new Object[0])).isEqualTo(expectedGt1.toString());
            Predicate gt2 = new Predicate(">", valueAndAttr);
            UnboundPredicate expectedGt2 = Expressions.lessThan((String)unquoted, (Object)1);
            Expression actualGt2 = SparkV2Filters.convert((Predicate)gt2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGt2.toString()).as("GreaterThan must match", new Object[0])).isEqualTo(expectedGt2.toString());
            Predicate gtEq1 = new Predicate(">=", attrAndValue);
            UnboundPredicate expectedGtEq1 = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            Expression actualGtEq1 = SparkV2Filters.convert((Predicate)gtEq1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGtEq1.toString()).as("GreaterThanOrEqual must match", new Object[0])).isEqualTo(expectedGtEq1.toString());
            Predicate gtEq2 = new Predicate(">=", valueAndAttr);
            UnboundPredicate expectedGtEq2 = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            Expression actualGtEq2 = SparkV2Filters.convert((Predicate)gtEq2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualGtEq2.toString()).as("GreaterThanOrEqual must match", new Object[0])).isEqualTo(expectedGtEq2.toString());
            Predicate eq1 = new Predicate("=", attrAndValue);
            UnboundPredicate expectedEq1 = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEq1 = SparkV2Filters.convert((Predicate)eq1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEq1.toString()).as("EqualTo must match", new Object[0])).isEqualTo(expectedEq1.toString());
            Predicate eq2 = new Predicate("=", valueAndAttr);
            UnboundPredicate expectedEq2 = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEq2 = SparkV2Filters.convert((Predicate)eq2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEq2.toString()).as("EqualTo must match", new Object[0])).isEqualTo(expectedEq2.toString());
            Predicate notEq1 = new Predicate("<>", attrAndValue);
            UnboundPredicate expectedNotEq1 = Expressions.notEqual((String)unquoted, (Object)1);
            Expression actualNotEq1 = SparkV2Filters.convert((Predicate)notEq1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualNotEq1.toString()).as("NotEqualTo must match", new Object[0])).isEqualTo(expectedNotEq1.toString());
            Predicate notEq2 = new Predicate("<>", valueAndAttr);
            UnboundPredicate expectedNotEq2 = Expressions.notEqual((String)unquoted, (Object)1);
            Expression actualNotEq2 = SparkV2Filters.convert((Predicate)notEq2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualNotEq2.toString()).as("NotEqualTo must match", new Object[0])).isEqualTo(expectedNotEq2.toString());
            Predicate eqNullSafe1 = new Predicate("<=>", attrAndValue);
            UnboundPredicate expectedEqNullSafe1 = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEqNullSafe1 = SparkV2Filters.convert((Predicate)eqNullSafe1);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEqNullSafe1.toString()).as("EqualNullSafe must match", new Object[0])).isEqualTo(expectedEqNullSafe1.toString());
            Predicate eqNullSafe2 = new Predicate("<=>", valueAndAttr);
            UnboundPredicate expectedEqNullSafe2 = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEqNullSafe2 = SparkV2Filters.convert((Predicate)eqNullSafe2);
            ((AbstractStringAssert)Assertions.assertThat((String)actualEqNullSafe2.toString()).as("EqualNullSafe must match", new Object[0])).isEqualTo(expectedEqNullSafe2.toString());
            LiteralValue str = new LiteralValue((Object)UTF8String.fromString((String)"iceberg"), DataTypes.StringType);
            org.apache.spark.sql.connector.expressions.Expression[] attrAndStr = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, str};
            Predicate startsWith = new Predicate("STARTS_WITH", attrAndStr);
            UnboundPredicate expectedStartsWith = Expressions.startsWith((String)unquoted, (String)"iceberg");
            Expression actualStartsWith = SparkV2Filters.convert((Predicate)startsWith);
            ((AbstractStringAssert)Assertions.assertThat((String)actualStartsWith.toString()).as("StartsWith must match", new Object[0])).isEqualTo(expectedStartsWith.toString());
            Predicate in = new Predicate("IN", attrAndValue);
            UnboundPredicate expectedIn = Expressions.in((String)unquoted, (Object[])new Integer[]{1});
            Expression actualIn = SparkV2Filters.convert((Predicate)in);
            ((AbstractStringAssert)Assertions.assertThat((String)actualIn.toString()).as("In must match", new Object[0])).isEqualTo(expectedIn.toString());
            And and = new And(lt1, eq1);
            Expression expectedAnd = Expressions.and((Expression)expectedLt1, (Expression)expectedEq1);
            Expression actualAnd = SparkV2Filters.convert((Predicate)and);
            ((AbstractStringAssert)Assertions.assertThat((String)actualAnd.toString()).as("And must match", new Object[0])).isEqualTo(expectedAnd.toString());
            org.apache.spark.sql.connector.expressions.Expression[] attrAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, namedReference};
            Predicate invalid = new Predicate("<", attrAndAttr);
            And andWithInvalidLeft = new And(invalid, eq1);
            Expression convertedAnd = SparkV2Filters.convert((Predicate)andWithInvalidLeft);
            ((ObjectAssert)Assertions.assertThat((Object)convertedAnd).as("And must match", new Object[0])).isNull();
            Or or = new Or(lt1, eq1);
            Expression expectedOr = Expressions.or((Expression)expectedLt1, (Expression)expectedEq1);
            Expression actualOr = SparkV2Filters.convert((Predicate)or);
            ((AbstractStringAssert)Assertions.assertThat((String)actualOr.toString()).as("Or must match", new Object[0])).isEqualTo(expectedOr.toString());
            Or orWithInvalidLeft = new Or(invalid, eq1);
            Expression convertedOr = SparkV2Filters.convert((Predicate)orWithInvalidLeft);
            ((ObjectAssert)Assertions.assertThat((Object)convertedOr).as("Or must match", new Object[0])).isNull();
            Not not = new Not(lt1);
            Expression expectedNot = Expressions.not((Expression)expectedLt1);
            Expression actualNot = SparkV2Filters.convert((Predicate)not);
            ((AbstractStringAssert)Assertions.assertThat((String)actualNot.toString()).as("Not must match", new Object[0])).isEqualTo(expectedNot.toString());
        });
    }

    @Test
    public void testEqualToNull() {
        String col = "col";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue value = new LiteralValue(null, DataTypes.IntegerType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, value};
        org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{value, namedReference};
        Predicate eq1 = new Predicate("=", attrAndValue);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SparkV2Filters.convert((Predicate)eq1)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Expression is always false");
        Predicate eq2 = new Predicate("=", valueAndAttr);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SparkV2Filters.convert((Predicate)eq2)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Expression is always false");
        Predicate eqNullSafe1 = new Predicate("<=>", attrAndValue);
        UnboundPredicate expectedEqNullSafe = Expressions.isNull((String)col);
        Expression actualEqNullSafe1 = SparkV2Filters.convert((Predicate)eqNullSafe1);
        Assertions.assertThat((String)actualEqNullSafe1.toString()).isEqualTo(expectedEqNullSafe.toString());
        Predicate eqNullSafe2 = new Predicate("<=>", valueAndAttr);
        Expression actualEqNullSafe2 = SparkV2Filters.convert((Predicate)eqNullSafe2);
        Assertions.assertThat((String)actualEqNullSafe2.toString()).isEqualTo(expectedEqNullSafe.toString());
    }

    @Test
    public void testEqualToNaN() {
        String col = "col";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue value = new LiteralValue((Object)Float.valueOf(Float.NaN), DataTypes.FloatType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, value};
        org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{value, namedReference};
        Predicate eqNaN1 = new Predicate("=", attrAndValue);
        UnboundPredicate expectedEqNaN = Expressions.isNaN((String)col);
        Expression actualEqNaN1 = SparkV2Filters.convert((Predicate)eqNaN1);
        Assertions.assertThat((String)actualEqNaN1.toString()).isEqualTo(expectedEqNaN.toString());
        Predicate eqNaN2 = new Predicate("=", valueAndAttr);
        Expression actualEqNaN2 = SparkV2Filters.convert((Predicate)eqNaN2);
        Assertions.assertThat((String)actualEqNaN2.toString()).isEqualTo(expectedEqNaN.toString());
    }

    @Test
    public void testNotEqualToNull() {
        String col = "col";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue value = new LiteralValue(null, DataTypes.IntegerType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, value};
        org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{value, namedReference};
        Predicate notEq1 = new Predicate("<>", attrAndValue);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SparkV2Filters.convert((Predicate)notEq1)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Expression is always false");
        Predicate notEq2 = new Predicate("<>", valueAndAttr);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SparkV2Filters.convert((Predicate)notEq2)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Expression is always false");
    }

    @Test
    public void testNotEqualToNaN() {
        String col = "col";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue value = new LiteralValue((Object)Float.valueOf(Float.NaN), DataTypes.FloatType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, value};
        org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = new org.apache.spark.sql.connector.expressions.Expression[]{value, namedReference};
        Predicate notEqNaN1 = new Predicate("<>", attrAndValue);
        UnboundPredicate expectedNotEqNaN = Expressions.notNaN((String)col);
        Expression actualNotEqNaN1 = SparkV2Filters.convert((Predicate)notEqNaN1);
        Assertions.assertThat((String)actualNotEqNaN1.toString()).isEqualTo(expectedNotEqNaN.toString());
        Predicate notEqNaN2 = new Predicate("<>", valueAndAttr);
        Expression actualNotEqNaN2 = SparkV2Filters.convert((Predicate)notEqNaN2);
        Assertions.assertThat((String)actualNotEqNaN2.toString()).isEqualTo(expectedNotEqNaN.toString());
    }

    @Test
    public void testInValuesContainNull() {
        String col = "strCol";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue nullValue = new LiteralValue(null, DataTypes.StringType);
        LiteralValue value1 = new LiteralValue((Object)"value1", DataTypes.StringType);
        LiteralValue value2 = new LiteralValue((Object)"value2", DataTypes.StringType);
        Predicate inNull = new Predicate("IN", this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, nullValue}));
        UnboundPredicate expectedInNull = Expressions.in((String)col, (Object[])new Object[0]);
        Expression actualInNull = SparkV2Filters.convert((Predicate)inNull);
        TestSparkV2Filters.assertEquals((Expression)expectedInNull, actualInNull);
        Predicate in = new Predicate("IN", this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, nullValue, value1, value2}));
        UnboundPredicate expectedIn = Expressions.in((String)col, (Object[])new String[]{"value1", "value2"});
        Expression actualIn = SparkV2Filters.convert((Predicate)in);
        TestSparkV2Filters.assertEquals((Expression)expectedIn, actualIn);
    }

    @Test
    public void testNotInNull() {
        String col = "strCol";
        NamedReference namedReference = FieldReference.apply((String)col);
        LiteralValue nullValue = new LiteralValue(null, DataTypes.StringType);
        LiteralValue value1 = new LiteralValue((Object)"value1", DataTypes.StringType);
        LiteralValue value2 = new LiteralValue((Object)"value2", DataTypes.StringType);
        Not notInNull = new Not(new Predicate("IN", this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, nullValue})));
        Expression expectedNotInNull = Expressions.and((Expression)Expressions.notNull((String)col), (Expression)Expressions.notIn((String)col, (Object[])new Object[0]));
        Expression actualNotInNull = SparkV2Filters.convert((Predicate)notInNull);
        TestSparkV2Filters.assertEquals(expectedNotInNull, actualNotInNull);
        Not notIn = new Not(new Predicate("IN", this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, nullValue, value1, value2})));
        Expression expectedNotIn = Expressions.and((Expression)Expressions.notNull((String)col), (Expression)Expressions.notIn((String)col, (Object[])new String[]{"value1", "value2"}));
        Expression actualNotIn = SparkV2Filters.convert((Predicate)notIn);
        TestSparkV2Filters.assertEquals(expectedNotIn, actualNotIn);
    }

    @Test
    public void testTimestampFilterConversion() {
        Instant instant = Instant.parse("2018-10-18T00:00:57.907Z");
        long epochMicros = ChronoUnit.MICROS.between(Instant.EPOCH, instant);
        NamedReference namedReference = FieldReference.apply((String)"x");
        LiteralValue ts = new LiteralValue((Object)epochMicros, DataTypes.TimestampType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, ts};
        Predicate predicate = new Predicate(">", attrAndValue);
        Expression tsExpression = SparkV2Filters.convert((Predicate)predicate);
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        ((AbstractStringAssert)Assertions.assertThat((String)tsExpression.toString()).as("Generated Timestamp expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
    }

    @Test
    public void testDateFilterConversion() {
        LocalDate localDate = LocalDate.parse("2018-10-18");
        long epochDay = localDate.toEpochDay();
        NamedReference namedReference = FieldReference.apply((String)"x");
        LiteralValue ts = new LiteralValue((Object)epochDay, DataTypes.DateType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, ts};
        Predicate predicate = new Predicate(">", attrAndValue);
        Expression dateExpression = SparkV2Filters.convert((Predicate)predicate);
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochDay);
        ((AbstractStringAssert)Assertions.assertThat((String)dateExpression.toString()).as("Generated date expression should be correct", new Object[0])).isEqualTo(rawExpression.toString());
    }

    @Test
    public void testNestedInInsideNot() {
        NamedReference namedReference1 = FieldReference.apply((String)"col1");
        LiteralValue v1 = new LiteralValue((Object)1, DataTypes.IntegerType);
        LiteralValue v2 = new LiteralValue((Object)2, DataTypes.IntegerType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue1 = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference1, v1};
        Predicate equal = new Predicate("=", attrAndValue1);
        NamedReference namedReference2 = FieldReference.apply((String)"col2");
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue2 = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference2, v1, v2};
        Predicate in = new Predicate("IN", attrAndValue2);
        Not filter = new Not((Predicate)new And(equal, in));
        Expression converted = SparkV2Filters.convert((Predicate)filter);
        ((ObjectAssert)Assertions.assertThat((Object)converted).as("Expression should not be converted", new Object[0])).isNull();
    }

    @Test
    public void testNotIn() {
        NamedReference namedReference = FieldReference.apply((String)"col");
        LiteralValue v1 = new LiteralValue((Object)1, DataTypes.IntegerType);
        LiteralValue v2 = new LiteralValue((Object)2, DataTypes.IntegerType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = new org.apache.spark.sql.connector.expressions.Expression[]{namedReference, v1, v2};
        Predicate in = new Predicate("IN", attrAndValue);
        Not not = new Not(in);
        Expression actual = SparkV2Filters.convert((Predicate)not);
        Expression expected = Expressions.and((Expression)Expressions.notNull((String)"col"), (Expression)Expressions.notIn((String)"col", (Object[])new Integer[]{1, 2}));
        ((AbstractStringAssert)Assertions.assertThat((String)actual.toString()).as("Expressions should match", new Object[0])).isEqualTo(expected.toString());
    }

    @Test
    public void testDateToYears() {
        YearsFunction.DateToYearsFunction dateToYearsFunc = new YearsFunction.DateToYearsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(dateToYearsFunc.name(), dateToYearsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"dateCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.year((String)"dateCol"), TestSparkV2Filters.dateToYears("2023-06-25"), DataTypes.IntegerType);
    }

    @Test
    public void testTsToYears() {
        YearsFunction.TimestampToYearsFunction tsToYearsFunc = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsToYearsFunc.name(), tsToYearsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.year((String)"tsCol"), TestSparkV2Filters.timestampToYears("2023-12-03T10:15:30+01:00"), DataTypes.IntegerType);
    }

    @Test
    public void testTsNtzToYears() {
        YearsFunction.TimestampNtzToYearsFunction tsNtzToYearsFunc = new YearsFunction.TimestampNtzToYearsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsNtzToYearsFunc.name(), tsNtzToYearsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsNtzCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.year((String)"tsNtzCol"), TestSparkV2Filters.timestampNtzToYears("2023-06-25T13:15:30"), DataTypes.IntegerType);
    }

    @Test
    public void testDateToMonths() {
        MonthsFunction.DateToMonthsFunction dateToMonthsFunc = new MonthsFunction.DateToMonthsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(dateToMonthsFunc.name(), dateToMonthsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"dateCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.month((String)"dateCol"), TestSparkV2Filters.dateToMonths("2023-06-25"), DataTypes.IntegerType);
    }

    @Test
    public void testTsToMonths() {
        MonthsFunction.TimestampToMonthsFunction tsToMonthsFunc = new MonthsFunction.TimestampToMonthsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsToMonthsFunc.name(), tsToMonthsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.month((String)"tsCol"), TestSparkV2Filters.timestampToMonths("2023-12-03T10:15:30+01:00"), DataTypes.IntegerType);
    }

    @Test
    public void testTsNtzToMonths() {
        MonthsFunction.TimestampNtzToMonthsFunction tsNtzToMonthsFunc = new MonthsFunction.TimestampNtzToMonthsFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsNtzToMonthsFunc.name(), tsNtzToMonthsFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsNtzCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.month((String)"tsNtzCol"), TestSparkV2Filters.timestampNtzToMonths("2023-12-03T10:15:30"), DataTypes.IntegerType);
    }

    @Test
    public void testDateToDays() {
        DaysFunction.DateToDaysFunction dateToDayFunc = new DaysFunction.DateToDaysFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(dateToDayFunc.name(), dateToDayFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"dateCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.day((String)"dateCol"), TestSparkV2Filters.dateToDays("2023-06-25"), DataTypes.IntegerType);
    }

    @Test
    public void testTsToDays() {
        DaysFunction.TimestampToDaysFunction tsToDaysFunc = new DaysFunction.TimestampToDaysFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsToDaysFunc.name(), tsToDaysFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.day((String)"tsCol"), TestSparkV2Filters.timestampToDays("2023-12-03T10:15:30+01:00"), DataTypes.IntegerType);
    }

    @Test
    public void testTsNtzToDays() {
        DaysFunction.TimestampNtzToDaysFunction tsNtzToDaysFunc = new DaysFunction.TimestampNtzToDaysFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsNtzToDaysFunc.name(), tsNtzToDaysFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsNtzCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.day((String)"tsNtzCol"), TestSparkV2Filters.timestampNtzToDays("2023-12-03T10:15:30"), DataTypes.IntegerType);
    }

    @Test
    public void testTsToHours() {
        HoursFunction.TimestampToHoursFunction tsToHourFunc = new HoursFunction.TimestampToHoursFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsToHourFunc.name(), tsToHourFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.hour((String)"tsCol"), TestSparkV2Filters.timestampToHours("2023-12-03T10:15:30+01:00"), DataTypes.IntegerType);
    }

    @Test
    public void testTsNtzToHours() {
        HoursFunction.TimestampNtzToHoursFunction tsNtzToHourFunc = new HoursFunction.TimestampNtzToHoursFunction();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(tsNtzToHourFunc.name(), tsNtzToHourFunc.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{FieldReference.apply((String)"tsNtzCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.hour((String)"tsNtzCol"), TestSparkV2Filters.timestampNtzToHours("2023-12-03T10:15:30"), DataTypes.IntegerType);
    }

    @Test
    public void testBucket() {
        BucketFunction.BucketInt bucketInt = new BucketFunction.BucketInt(DataTypes.IntegerType);
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(bucketInt.name(), bucketInt.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{LiteralValue.apply((Object)4, (DataType)DataTypes.IntegerType), FieldReference.apply((String)"intCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.bucket((String)"intCol", (int)4), 2, DataTypes.IntegerType);
    }

    @Test
    public void testTruncate() {
        TruncateFunction.TruncateString truncate = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(truncate.name(), truncate.canonicalName(), this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{LiteralValue.apply((Object)6, (DataType)DataTypes.IntegerType), FieldReference.apply((String)"strCol")}));
        this.testUDF((org.apache.spark.sql.connector.expressions.Expression)udf, Expressions.truncate((String)"strCol", (int)6), "prefix", DataTypes.StringType);
    }

    @Test
    public void testUnsupportedUDFConvert() {
        ScalarFunction icebergVersionFunc = (ScalarFunction)new IcebergVersionFunction().bind(new StructType());
        UserDefinedScalarFunc udf = new UserDefinedScalarFunc(icebergVersionFunc.name(), icebergVersionFunc.canonicalName(), new org.apache.spark.sql.connector.expressions.Expression[0]);
        LiteralValue literalValue = new LiteralValue((Object)"1.3.0", DataTypes.StringType);
        Predicate predicate = new Predicate("=", this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{udf, literalValue}));
        Expression icebergExpr = SparkV2Filters.convert((Predicate)predicate);
        Assertions.assertThat((Object)icebergExpr).isNull();
    }

    private <T> void testUDF(org.apache.spark.sql.connector.expressions.Expression udf, UnboundTerm<T> expectedTerm, T value, DataType dataType) {
        org.apache.spark.sql.connector.expressions.Expression[] attrOnly = this.expressions(udf);
        LiteralValue literalValue = new LiteralValue(value, dataType);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndValue = this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{udf, literalValue});
        org.apache.spark.sql.connector.expressions.Expression[] valueAndAttr = this.expressions(new org.apache.spark.sql.connector.expressions.Expression[]{literalValue, udf});
        Predicate isNull = new Predicate("IS_NULL", attrOnly);
        UnboundPredicate expectedIsNull = Expressions.isNull(expectedTerm);
        Expression actualIsNull = SparkV2Filters.convert((Predicate)isNull);
        TestSparkV2Filters.assertEquals((Expression)expectedIsNull, actualIsNull);
        Predicate isNotNull = new Predicate("IS_NOT_NULL", attrOnly);
        UnboundPredicate expectedIsNotNull = Expressions.notNull(expectedTerm);
        Expression actualIsNotNull = SparkV2Filters.convert((Predicate)isNotNull);
        TestSparkV2Filters.assertEquals((Expression)expectedIsNotNull, actualIsNotNull);
        Predicate lt1 = new Predicate("<", attrAndValue);
        UnboundPredicate expectedLt1 = Expressions.lessThan(expectedTerm, value);
        Expression actualLt1 = SparkV2Filters.convert((Predicate)lt1);
        TestSparkV2Filters.assertEquals((Expression)expectedLt1, actualLt1);
        Predicate lt2 = new Predicate("<", valueAndAttr);
        UnboundPredicate expectedLt2 = Expressions.greaterThan(expectedTerm, value);
        Expression actualLt2 = SparkV2Filters.convert((Predicate)lt2);
        TestSparkV2Filters.assertEquals((Expression)expectedLt2, actualLt2);
        Predicate ltEq1 = new Predicate("<=", attrAndValue);
        UnboundPredicate expectedLtEq1 = Expressions.lessThanOrEqual(expectedTerm, value);
        Expression actualLtEq1 = SparkV2Filters.convert((Predicate)ltEq1);
        TestSparkV2Filters.assertEquals((Expression)expectedLtEq1, actualLtEq1);
        Predicate ltEq2 = new Predicate("<=", valueAndAttr);
        UnboundPredicate expectedLtEq2 = Expressions.greaterThanOrEqual(expectedTerm, value);
        Expression actualLtEq2 = SparkV2Filters.convert((Predicate)ltEq2);
        TestSparkV2Filters.assertEquals((Expression)expectedLtEq2, actualLtEq2);
        Predicate gt1 = new Predicate(">", attrAndValue);
        UnboundPredicate expectedGt1 = Expressions.greaterThan(expectedTerm, value);
        Expression actualGt1 = SparkV2Filters.convert((Predicate)gt1);
        TestSparkV2Filters.assertEquals((Expression)expectedGt1, actualGt1);
        Predicate gt2 = new Predicate(">", valueAndAttr);
        UnboundPredicate expectedGt2 = Expressions.lessThan(expectedTerm, value);
        Expression actualGt2 = SparkV2Filters.convert((Predicate)gt2);
        TestSparkV2Filters.assertEquals((Expression)expectedGt2, actualGt2);
        Predicate gtEq1 = new Predicate(">=", attrAndValue);
        UnboundPredicate expectedGtEq1 = Expressions.greaterThanOrEqual(expectedTerm, value);
        Expression actualGtEq1 = SparkV2Filters.convert((Predicate)gtEq1);
        TestSparkV2Filters.assertEquals((Expression)expectedGtEq1, actualGtEq1);
        Predicate gtEq2 = new Predicate(">=", valueAndAttr);
        UnboundPredicate expectedGtEq2 = Expressions.lessThanOrEqual(expectedTerm, value);
        Expression actualGtEq2 = SparkV2Filters.convert((Predicate)gtEq2);
        TestSparkV2Filters.assertEquals((Expression)expectedGtEq2, actualGtEq2);
        Predicate eq1 = new Predicate("=", attrAndValue);
        UnboundPredicate expectedEq1 = Expressions.equal(expectedTerm, value);
        Expression actualEq1 = SparkV2Filters.convert((Predicate)eq1);
        TestSparkV2Filters.assertEquals((Expression)expectedEq1, actualEq1);
        Predicate eq2 = new Predicate("=", valueAndAttr);
        UnboundPredicate expectedEq2 = Expressions.equal(expectedTerm, value);
        Expression actualEq2 = SparkV2Filters.convert((Predicate)eq2);
        TestSparkV2Filters.assertEquals((Expression)expectedEq2, actualEq2);
        Predicate notEq1 = new Predicate("<>", attrAndValue);
        UnboundPredicate expectedNotEq1 = Expressions.notEqual(expectedTerm, value);
        Expression actualNotEq1 = SparkV2Filters.convert((Predicate)notEq1);
        TestSparkV2Filters.assertEquals((Expression)expectedNotEq1, actualNotEq1);
        Predicate notEq2 = new Predicate("<>", valueAndAttr);
        UnboundPredicate expectedNotEq2 = Expressions.notEqual(expectedTerm, value);
        Expression actualNotEq2 = SparkV2Filters.convert((Predicate)notEq2);
        TestSparkV2Filters.assertEquals((Expression)expectedNotEq2, actualNotEq2);
        Predicate eqNullSafe1 = new Predicate("<=>", attrAndValue);
        UnboundPredicate expectedEqNullSafe1 = Expressions.equal(expectedTerm, value);
        Expression actualEqNullSafe1 = SparkV2Filters.convert((Predicate)eqNullSafe1);
        TestSparkV2Filters.assertEquals((Expression)expectedEqNullSafe1, actualEqNullSafe1);
        Predicate eqNullSafe2 = new Predicate("<=>", valueAndAttr);
        UnboundPredicate expectedEqNullSafe2 = Expressions.equal(expectedTerm, value);
        Expression actualEqNullSafe2 = SparkV2Filters.convert((Predicate)eqNullSafe2);
        TestSparkV2Filters.assertEquals((Expression)expectedEqNullSafe2, actualEqNullSafe2);
        Predicate in = new Predicate("IN", attrAndValue);
        UnboundPredicate expectedIn = Expressions.in(expectedTerm, (Object[])new Object[]{value});
        Expression actualIn = SparkV2Filters.convert((Predicate)in);
        TestSparkV2Filters.assertEquals((Expression)expectedIn, actualIn);
        Not notIn = new Not(in);
        Expression expectedNotIn = Expressions.and((Expression)Expressions.notNull(expectedTerm), (Expression)Expressions.notIn(expectedTerm, (Object[])new Object[]{value}));
        Expression actualNotIn = SparkV2Filters.convert((Predicate)notIn);
        TestSparkV2Filters.assertEquals(expectedNotIn, actualNotIn);
        And and = new And(lt1, eq1);
        Expression expectedAnd = Expressions.and((Expression)expectedLt1, (Expression)expectedEq1);
        Expression actualAnd = SparkV2Filters.convert((Predicate)and);
        TestSparkV2Filters.assertEquals(expectedAnd, actualAnd);
        org.apache.spark.sql.connector.expressions.Expression[] attrAndAttr = this.expressions(udf, udf);
        Predicate invalid = new Predicate("<", attrAndAttr);
        And andWithInvalidLeft = new And(invalid, eq1);
        Expression convertedAnd = SparkV2Filters.convert((Predicate)andWithInvalidLeft);
        Assertions.assertThat((Object)convertedAnd).isNull();
        Or or = new Or(lt1, eq1);
        Expression expectedOr = Expressions.or((Expression)expectedLt1, (Expression)expectedEq1);
        Expression actualOr = SparkV2Filters.convert((Predicate)or);
        TestSparkV2Filters.assertEquals(expectedOr, actualOr);
        Or orWithInvalidLeft = new Or(invalid, eq1);
        Expression convertedOr = SparkV2Filters.convert((Predicate)orWithInvalidLeft);
        Assertions.assertThat((Object)convertedOr).isNull();
        Not not = new Not(lt1);
        Expression expectedNot = Expressions.not((Expression)expectedLt1);
        Expression actualNot = SparkV2Filters.convert((Predicate)not);
        TestSparkV2Filters.assertEquals(expectedNot, actualNot);
    }

    private static void assertEquals(Expression expected, Expression actual) {
        Assertions.assertThat((boolean)ExpressionUtil.equivalent((Expression)expected, (Expression)actual, (Types.StructType)STRUCT, (boolean)true)).isTrue();
    }

    private org.apache.spark.sql.connector.expressions.Expression[] expressions(org.apache.spark.sql.connector.expressions.Expression ... expressions) {
        return expressions;
    }

    private static int dateToYears(String dateString) {
        return DateTimeUtil.daysToYears((int)DateTimeUtil.isoDateToDays((String)dateString));
    }

    private static int timestampToYears(String timestampString) {
        return DateTimeUtil.microsToYears((long)DateTimeUtil.isoTimestamptzToMicros((String)timestampString));
    }

    private static int timestampNtzToYears(String timestampNtzString) {
        return DateTimeUtil.microsToYears((long)DateTimeUtil.isoTimestampToMicros((String)timestampNtzString));
    }

    private static int dateToMonths(String dateString) {
        return DateTimeUtil.daysToMonths((int)DateTimeUtil.isoDateToDays((String)dateString));
    }

    private static int timestampToMonths(String timestampString) {
        return DateTimeUtil.microsToMonths((long)DateTimeUtil.isoTimestamptzToMicros((String)timestampString));
    }

    private static int timestampNtzToMonths(String timestampNtzString) {
        return DateTimeUtil.microsToMonths((long)DateTimeUtil.isoTimestampToMicros((String)timestampNtzString));
    }

    private static int dateToDays(String dateString) {
        return DateTimeUtil.isoDateToDays((String)dateString);
    }

    private static int timestampToDays(String timestampString) {
        return DateTimeUtil.microsToDays((long)DateTimeUtil.isoTimestamptzToMicros((String)timestampString));
    }

    private static int timestampNtzToDays(String timestampNtzString) {
        return DateTimeUtil.microsToDays((long)DateTimeUtil.isoTimestampToMicros((String)timestampNtzString));
    }

    private static int timestampToHours(String timestampString) {
        return DateTimeUtil.microsToHours((long)DateTimeUtil.isoTimestamptzToMicros((String)timestampString));
    }

    private static int timestampNtzToHours(String timestampNtzString) {
        return DateTimeUtil.microsToHours((long)DateTimeUtil.isoTimestampToMicros((String)timestampNtzString));
    }
}

