/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSparkValueConverter {
    @Test
    public void testSparkNullMapConvert() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        this.assertCorrectNullConversion(schema);
    }

    @Test
    public void testSparkNullListConvert() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.ListType.ofOptional((int)6, (Type)Types.StringType.get()))});
        this.assertCorrectNullConversion(schema);
    }

    @Test
    public void testSparkNullStructConvert() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        this.assertCorrectNullConversion(schema);
    }

    @Test
    public void testSparkNullPrimitiveConvert() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"location", (Type)Types.StringType.get())});
        this.assertCorrectNullConversion(schema);
    }

    private void assertCorrectNullConversion(Schema schema) {
        Row sparkRow = RowFactory.create((Object[])new Object[]{1, null});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.set(0, (Object)1);
        ((ObjectAssert)Assertions.assertThat((Object)SparkValueConverter.convert((Schema)schema, (Row)sparkRow)).as("Round-trip conversion should produce original value", new Object[0])).isEqualTo((Object)record);
    }
}

