/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMigrateTableAction
extends CatalogTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s_BACKUP_", this.tableName);
    }

    @TestTemplate
    public void testMigrateWithParallelTasks() throws IOException {
        Assumptions.assumeThat((String)this.catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", this.tableName, location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", this.tableName);
        AtomicInteger migrationThreadsIndex = new AtomicInteger(0);
        SparkActions.get().migrateTable(this.tableName).executeWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("table-migration-" + migrationThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).execute();
        Assertions.assertThat((int)migrationThreadsIndex.get()).isEqualTo(2);
    }
}

