/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileGenerationUtil;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RemoveDanglingDeleteFiles;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import scala.Tuple2;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestRemoveDanglingDeleteAction
extends TestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DataFile FILE_A2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_B2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=c").withRecordCount(1L).build();
    static final DataFile FILE_C2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=c").withRecordCount(1L).build();
    static final DataFile FILE_D = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=d").withRecordCount(1L).build();
    static final DataFile FILE_D2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=d").withRecordCount(1L).build();
    static final DeleteFile FILE_A_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A2_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a2-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A2_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a2-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_B_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B2_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b2-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-b-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B2_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-b2-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_UNPARTITIONED = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-unpartitioned.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    static final DeleteFile FILE_UNPARTITIONED_POS_DELETE = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofEqualityDeletes(new int[0]).withPath("/path/to/data-unpartitioned-pos-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    static final DeleteFile FILE_UNPARTITIONED_EQ_DELETE = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofEqualityDeletes(new int[0]).withPath("/path/to/data-unpartitioned-eq-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    @TempDir
    private File tableDir;
    @Parameter
    private int formatVersion;
    private String tableLocation = null;
    private Table table;

    @Parameters(name="formatVersion = {0}")
    protected static List<Object> parameters() {
        return Arrays.asList(2, 3);
    }

    @BeforeEach
    public void before() throws Exception {
        this.tableLocation = this.tableDir.toURI().toString();
    }

    @AfterEach
    public void after() {
        TABLES.dropTable(this.tableLocation);
    }

    private void setupPartitionedTable() {
        this.table = TABLES.create(SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)), this.tableLocation);
    }

    private void setupUnpartitionedTable() {
        this.table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)), this.tableLocation);
    }

    private DeleteFile fileADeletes() {
        return this.formatVersion >= 3 ? FileGenerationUtil.generateDV((Table)this.table, (DataFile)FILE_A) : FILE_A_POS_DELETES;
    }

    private DeleteFile fileA2Deletes() {
        return this.formatVersion >= 3 ? FileGenerationUtil.generateDV((Table)this.table, (DataFile)FILE_A2) : FILE_A2_POS_DELETES;
    }

    private DeleteFile fileBDeletes() {
        return this.formatVersion >= 3 ? FileGenerationUtil.generateDV((Table)this.table, (DataFile)FILE_B) : FILE_B_POS_DELETES;
    }

    private DeleteFile fileB2Deletes() {
        return this.formatVersion >= 3 ? FileGenerationUtil.generateDV((Table)this.table, (DataFile)FILE_B2) : FILE_B2_POS_DELETES;
    }

    private DeleteFile fileUnpartitionedDeletes() {
        return this.formatVersion >= 3 ? FileGenerationUtil.generateDV((Table)this.table, (DataFile)FILE_UNPARTITIONED) : FILE_UNPARTITIONED_POS_DELETE;
    }

    @TestTemplate
    public void testPartitionedDeletesWithLesserSeqNo() {
        this.setupPartitionedTable();
        this.table.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        DeleteFile fileADeletes = this.fileADeletes();
        DeleteFile fileA2Deletes = this.fileA2Deletes();
        DeleteFile fileBDeletes = this.fileBDeletes();
        DeleteFile fileB2Deletes = this.fileB2Deletes();
        this.table.newRowDelta().addDeletes(fileADeletes).addDeletes(fileA2Deletes).addDeletes(fileBDeletes).addDeletes(fileB2Deletes).addDeletes(FILE_A_EQ_DELETES).addDeletes(FILE_A2_EQ_DELETES).addDeletes(FILE_B_EQ_DELETES).addDeletes(FILE_B2_EQ_DELETES).commit();
        this.table.newAppend().appendFile(FILE_A2).appendFile(FILE_B2).appendFile(FILE_C2).appendFile(FILE_D2).commit();
        List actual = spark.read().format("iceberg").load(this.tableLocation + "#entries").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expected = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_B.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileADeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileA2Deletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileBDeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileB2Deletes.location()), (Object)Tuple2.apply((Object)3L, (Object)FILE_A2.location()), (Object[])new Tuple2[]{Tuple2.apply((Object)3L, (Object)FILE_B2.location()), Tuple2.apply((Object)3L, (Object)FILE_C2.location()), Tuple2.apply((Object)3L, (Object)FILE_D2.location())});
        Assertions.assertThat((List)actual).containsExactlyInAnyOrderElementsOf((Iterable)expected);
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        Set removedDeleteFiles = StreamSupport.stream(result.removedDeleteFiles().spliterator(), false).map(ContentFile::location).collect(Collectors.toSet());
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(removedDeleteFiles).as("Expected 4 delete files removed", new Object[0])).hasSize(4)).containsExactlyInAnyOrder((Object[])new CharSequence[]{fileADeletes.location(), fileA2Deletes.location(), FILE_A_EQ_DELETES.location(), FILE_A2_EQ_DELETES.location()});
        List actualAfter = spark.read().format("iceberg").load(this.tableLocation + "#entries").filter("status < 2").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expectedAfter = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_B.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileBDeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileB2Deletes.location()), (Object)Tuple2.apply((Object)3L, (Object)FILE_A2.location()), (Object)Tuple2.apply((Object)3L, (Object)FILE_B2.location()), (Object)Tuple2.apply((Object)3L, (Object)FILE_C2.location()), (Object)Tuple2.apply((Object)3L, (Object)FILE_D2.location()));
        Assertions.assertThat((List)actualAfter).containsExactlyInAnyOrderElementsOf((Iterable)expectedAfter);
    }

    @TestTemplate
    public void testPartitionedDeletesWithEqSeqNo() {
        this.setupPartitionedTable();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_C).appendFile(FILE_D).commit();
        DeleteFile fileADeletes = this.fileADeletes();
        DeleteFile fileA2Deletes = this.fileA2Deletes();
        DeleteFile fileBDeletes = this.fileBDeletes();
        DeleteFile fileB2Deletes = this.fileB2Deletes();
        this.table.newRowDelta().addRows(FILE_A2).addRows(FILE_B2).addRows(FILE_C2).addRows(FILE_D2).addDeletes(fileADeletes).addDeletes(fileA2Deletes).addDeletes(FILE_A_EQ_DELETES).addDeletes(FILE_A2_EQ_DELETES).addDeletes(fileBDeletes).addDeletes(fileB2Deletes).addDeletes(FILE_B_EQ_DELETES).addDeletes(FILE_B2_EQ_DELETES).commit();
        List actual = spark.read().format("iceberg").load(this.tableLocation + "#entries").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expected = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_A.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileADeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileA2Deletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileBDeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.location()), (Object[])new Tuple2[]{Tuple2.apply((Object)2L, (Object)fileB2Deletes.location()), Tuple2.apply((Object)2L, (Object)FILE_C2.location()), Tuple2.apply((Object)2L, (Object)FILE_D2.location())});
        Assertions.assertThat((List)actual).containsExactlyInAnyOrderElementsOf((Iterable)expected);
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        Set removedDeleteFiles = StreamSupport.stream(result.removedDeleteFiles().spliterator(), false).map(ContentFile::location).collect(Collectors.toSet());
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(removedDeleteFiles).as("Expected two delete files removed", new Object[0])).hasSize(2)).containsExactlyInAnyOrder((Object[])new CharSequence[]{FILE_B_EQ_DELETES.location(), FILE_B2_EQ_DELETES.location()});
        List actualAfter = spark.read().format("iceberg").load(this.tableLocation + "#entries").filter("status < 2").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expectedAfter = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_A.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.location()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileADeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.location()), (Object)Tuple2.apply((Object)2L, (Object)fileA2Deletes.location()), (Object)Tuple2.apply((Object)2L, (Object)fileBDeletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2.location()), (Object)Tuple2.apply((Object)2L, (Object)fileB2Deletes.location()), (Object)Tuple2.apply((Object)2L, (Object)FILE_C2.location()), (Object[])new Tuple2[]{Tuple2.apply((Object)2L, (Object)FILE_D2.location())});
        Assertions.assertThat((List)actualAfter).containsExactlyInAnyOrderElementsOf((Iterable)expectedAfter);
    }

    @TestTemplate
    public void testUnpartitionedTable() {
        this.setupUnpartitionedTable();
        this.table.newRowDelta().addDeletes(this.fileUnpartitionedDeletes()).addDeletes(FILE_UNPARTITIONED_EQ_DELETE).commit();
        this.table.newAppend().appendFile(FILE_UNPARTITIONED).commit();
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.removedDeleteFiles()).as("No-op for unpartitioned tables", new Object[0])).isEmpty();
    }
}

