/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.hadoop.HiddenPathFilter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.actions.DeleteOrphanFilesSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.FilePathLastModifiedRecord;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestRemoveOrphanFilesAction
extends TestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    protected static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    protected static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).truncate("c2", 2).identity("c3").build();
    @TempDir
    private File tableDir = null;
    protected String tableLocation = null;
    protected Map<String, String> properties;
    @Parameter
    private int formatVersion;

    @Parameters(name="formatVersion = {0}")
    protected static List<Object> parameters() {
        return Arrays.asList(2, 3);
    }

    @BeforeEach
    public void setupTableLocation() throws Exception {
        this.tableLocation = this.tableDir.toURI().toString();
        this.properties = ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion));
    }

    @TestTemplate
    public void testDryRun() throws IOException {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        List validFiles = spark.read().format("iceberg").load(this.tableLocation + "#files").select("file_path", new String[0]).as(Encoders.STRING()).collectAsList();
        ((ListAssert)Assertions.assertThat((List)validFiles).as("Should be 2 valid files", new Object[0])).hasSize(2);
        df.write().mode("append").parquet(this.tableLocation + "/data");
        Path dataPath = new Path(this.tableLocation + "/data");
        FileSystem fs = dataPath.getFileSystem(spark.sessionState().newHadoopConf());
        List allFiles = Arrays.stream(fs.listStatus(dataPath, (PathFilter)HiddenPathFilter.get())).filter(FileStatus::isFile).map(file -> file.getPath().toString()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(allFiles).as("Should be 3 valid files", new Object[0])).hasSize(3);
        ArrayList invalidFiles = Lists.newArrayList(allFiles);
        invalidFiles.removeAll(validFiles);
        ((ListAssert)Assertions.assertThat((List)invalidFiles).as("Should be 1 invalid file", new Object[0])).hasSize(1);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result1 = actions.deleteOrphanFiles(table).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result1.orphanFileLocations()).as("Default olderThan interval should be safe", new Object[0])).isEmpty();
        DeleteOrphanFiles.Result result2 = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result2.orphanFileLocations()).as("Action should find 1 file", new Object[0])).isEqualTo((Object)invalidFiles);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path((String)invalidFiles.get(0)))).as("Invalid file should be present", new Object[0])).isTrue();
        DeleteOrphanFiles.Result result3 = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result3.orphanFileLocations()).as("Action should delete 1 file", new Object[0])).isEqualTo((Object)invalidFiles);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path((String)invalidFiles.get(0)))).as("Invalid file should not be present", new Object[0])).isFalse();
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records);
        expectedRecords.addAll(records);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assertions.assertThat((List)actualRecords).isEqualTo((Object)expectedRecords);
    }

    @TestTemplate
    public void testAllValidFilesAreKept() throws IOException {
        Table table = TABLES.create(SCHEMA, SPEC, this.properties, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df1 = spark.createDataFrame((List)records1, ThreeColumnRecord.class).coalesce(1);
        df1.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "AAAAAAAAAA", "AAAA")});
        Dataset df2 = spark.createDataFrame((List)records2, ThreeColumnRecord.class).coalesce(1);
        df2.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("overwrite").save(this.tableLocation);
        df2.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        ArrayList snapshots = Lists.newArrayList((Iterable)table.snapshots());
        List<String> snapshotFiles1 = this.snapshotFiles(((Snapshot)snapshots.get(0)).snapshotId());
        Assertions.assertThat(snapshotFiles1).hasSize(1);
        List<String> snapshotFiles2 = this.snapshotFiles(((Snapshot)snapshots.get(1)).snapshotId());
        Assertions.assertThat(snapshotFiles2).hasSize(1);
        List<String> snapshotFiles3 = this.snapshotFiles(((Snapshot)snapshots.get(2)).snapshotId());
        Assertions.assertThat(snapshotFiles3).hasSize(2);
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA/c3=AAAA");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/invalid/invalid");
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 4 files", new Object[0])).hasSize(4);
        Path dataPath = new Path(this.tableLocation + "/data");
        FileSystem fs = dataPath.getFileSystem(spark.sessionState().newHadoopConf());
        for (String fileLocation : snapshotFiles1) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(fileLocation))).as("All snapshot files must remain", new Object[0])).isTrue();
        }
        for (String fileLocation : snapshotFiles2) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(fileLocation))).as("All snapshot files must remain", new Object[0])).isTrue();
        }
        for (String fileLocation : snapshotFiles3) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path(fileLocation))).as("All snapshot files must remain", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void orphanedFileRemovedWithParallelTasks() {
        Table table = TABLES.create(SCHEMA, SPEC, this.properties, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df1 = spark.createDataFrame((List)records1, ThreeColumnRecord.class).coalesce(1);
        df1.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "AAAAAAAAAA", "AAAA")});
        Dataset df2 = spark.createDataFrame((List)records2, ThreeColumnRecord.class).coalesce(1);
        df2.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("overwrite").save(this.tableLocation);
        df2.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA/c3=AAAA");
        df2.coalesce(1).write().mode("append").parquet(this.tableLocation + "/data/invalid/invalid");
        this.waitUntilAfter(System.currentTimeMillis());
        ConcurrentHashMap.KeySetView deletedFiles = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView deleteThreads = ConcurrentHashMap.newKeySet();
        AtomicInteger deleteThreadsIndex = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("remove-orphan-" + deleteThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        DeleteOrphanFiles.Result result = SparkActions.get().deleteOrphanFiles(table).executeDeleteWith(executorService).olderThan(System.currentTimeMillis() + 5000L).deleteWith(file -> {
            deleteThreads.add(Thread.currentThread().getName());
            deletedFiles.add(file);
        }).execute();
        Assertions.assertThat(deleteThreads).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"remove-orphan-0", "remove-orphan-1", "remove-orphan-2", "remove-orphan-3"}));
        Assertions.assertThat(deletedFiles).hasSize(4);
    }

    @TestTemplate
    public void testWapFilesAreKept() {
        ((AbstractIntegerAssert)Assumptions.assumeThat((int)this.formatVersion).as("currently fails with DVs", new Object[0])).isEqualTo(2);
        HashMap props = Maps.newHashMap();
        props.put("write.wap.enabled", "true");
        props.putAll(this.properties);
        Table table = TABLES.create(SCHEMA, SPEC, (Map)props, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        spark.conf().set("spark.wap.id", "1");
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualRecords).as("Should not return data from the staged snapshot", new Object[0])).isEqualTo((Object)records);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should not delete any files", new Object[0])).isEmpty();
    }

    @TestTemplate
    public void testMetadataFolderIsIntact() {
        HashMap props = Maps.newHashMap();
        props.put("write.data.path", this.tableLocation);
        props.putAll(this.properties);
        Table table = TABLES.create(SCHEMA, SPEC, (Map)props, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.write().mode("append").parquet(this.tableLocation + "/c2_trunc=AA/c3=AAAA");
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 1 file", new Object[0])).hasSize(1);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualRecords).as("Rows must match", new Object[0])).isEqualTo((Object)records);
    }

    @TestTemplate
    public void testOlderThanTimestamp() {
        Table table = TABLES.create(SCHEMA, SPEC, this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA/c3=AAAA");
        df.write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA/c3=AAAA");
        this.waitUntilAfter(System.currentTimeMillis());
        long timestamp = System.currentTimeMillis();
        this.waitUntilAfter(System.currentTimeMillis() + 1000L);
        df.write().mode("append").parquet(this.tableLocation + "/data/c2_trunc=AA/c3=AAAA");
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(timestamp).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete only 2 files", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testRemoveUnreachableMetadataVersionFiles() {
        HashMap props = Maps.newHashMap();
        props.put("write.data.path", this.tableLocation);
        props.put("write.metadata.previous-versions-max", "1");
        props.putAll(this.properties);
        Table table = TABLES.create(SCHEMA, SPEC, (Map)props, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 1 file", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(result.orphanFileLocations().spliterator(), false)).as("Should remove v1 file", new Object[0])).anyMatch(file -> file.contains("v1.metadata.json"));
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records);
        expectedRecords.addAll(records);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualRecords).as("Rows must match", new Object[0])).isEqualTo((Object)expectedRecords);
    }

    @TestTemplate
    public void testManyTopLevelPartitions() {
        Table table = TABLES.create(SCHEMA, SPEC, this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            records.add(new ThreeColumnRecord(i, String.valueOf(i), String.valueOf(i)));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should not delete any files", new Object[0])).isEmpty();
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        ((AbstractLongAssert)Assertions.assertThat((long)resultDF.count()).as("Rows count must match", new Object[0])).isEqualTo((long)records.size());
    }

    @TestTemplate
    public void testManyLeafPartitions() {
        Table table = TABLES.create(SCHEMA, SPEC, this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            records.add(new ThreeColumnRecord(i, String.valueOf(i % 3), String.valueOf(i)));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should not delete any files", new Object[0])).isEmpty();
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        ((AbstractLongAssert)Assertions.assertThat((long)resultDF.count()).as("Row count must match", new Object[0])).isEqualTo((long)records.size());
    }

    @TestTemplate
    public void testHiddenPartitionPaths() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"_c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("_c2", 2).identity("c3").build();
        Table table = TABLES.create(schema, spec, this.properties, this.tableLocation);
        StructType structType = new StructType().add("c1", DataTypes.IntegerType).add("_c2", DataTypes.StringType).add("c3", DataTypes.StringType);
        ArrayList records = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{1, "AAAAAAAAAA", "AAAA"})});
        Dataset df = spark.createDataFrame((List)records, structType).coalesce(1);
        df.select("c1", new String[]{"_c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.write().mode("append").parquet(this.tableLocation + "/data/_c2_trunc=AA/c3=AAAA");
        df.write().mode("append").parquet(this.tableLocation + "/data/_c2_trunc=AA/c3=AAAA");
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 2 files", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testHiddenPartitionPathsWithPartitionEvolution() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"_c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"_c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("_c2", 2).build();
        Table table = TABLES.create(schema, spec, this.properties, this.tableLocation);
        StructType structType = new StructType().add("_c1", DataTypes.IntegerType).add("_c2", DataTypes.StringType).add("c3", DataTypes.StringType);
        ArrayList records = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{1, "AAAAAAAAAA", "AAAA"})});
        Dataset df = spark.createDataFrame((List)records, structType).coalesce(1);
        df.select("_c1", new String[]{"_c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.write().mode("append").parquet(this.tableLocation + "/data/_c2_trunc=AA");
        table.updateSpec().addField("_c1").commit();
        df.write().mode("append").parquet(this.tableLocation + "/data/_c2_trunc=AA/_c1=1");
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 2 files", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testHiddenPathsStartingWithPartitionNamesAreIgnored() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"_c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("_c2", 2).identity("c3").build();
        Table table = TABLES.create(schema, spec, this.properties, this.tableLocation);
        StructType structType = new StructType().add("c1", DataTypes.IntegerType).add("_c2", DataTypes.StringType).add("c3", DataTypes.StringType);
        ArrayList records = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{1, "AAAAAAAAAA", "AAAA"})});
        Dataset df = spark.createDataFrame((List)records, structType).coalesce(1);
        df.select("c1", new String[]{"_c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        Path dataPath = new Path(this.tableLocation + "/data");
        FileSystem fs = dataPath.getFileSystem(spark.sessionState().newHadoopConf());
        Path pathToFileInHiddenFolder = new Path(dataPath, "_c2_trunc/file.txt");
        fs.createNewFile(pathToFileInHiddenFolder);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 0 files", new Object[0])).isEmpty();
        Assertions.assertThat((boolean)fs.exists(pathToFileInHiddenFolder)).isTrue();
    }

    private List<String> snapshotFiles(long snapshotId) {
        return spark.read().format("iceberg").option("snapshot-id", snapshotId).load(this.tableLocation + "#files").select("file_path", new String[0]).as(Encoders.STRING()).collectAsList();
    }

    @TestTemplate
    public void testRemoveOrphanFilesWithRelativeFilePath() throws IOException {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.properties, this.tableDir.getAbsolutePath());
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableDir.getAbsolutePath());
        List validFiles = spark.read().format("iceberg").load(this.tableLocation + "#files").select("file_path", new String[0]).as(Encoders.STRING()).collectAsList();
        ((ListAssert)Assertions.assertThat((List)validFiles).as("Should be 1 valid file", new Object[0])).hasSize(1);
        String validFile = (String)validFiles.get(0);
        df.write().mode("append").parquet(this.tableLocation + "/data");
        Path dataPath = new Path(this.tableLocation + "/data");
        FileSystem fs = dataPath.getFileSystem(spark.sessionState().newHadoopConf());
        List allFiles = Arrays.stream(fs.listStatus(dataPath, (PathFilter)HiddenPathFilter.get())).filter(FileStatus::isFile).map(file -> file.getPath().toString()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(allFiles).as("Should be 2 files", new Object[0])).hasSize(2);
        ArrayList invalidFiles = Lists.newArrayList(allFiles);
        invalidFiles.removeIf(file -> file.contains(validFile));
        ((ListAssert)Assertions.assertThat((List)invalidFiles).as("Should be 1 invalid file", new Object[0])).hasSize(1);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        DeleteOrphanFiles.Result result = actions.deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Action should find 1 file", new Object[0])).isEqualTo((Object)invalidFiles);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path((String)invalidFiles.get(0)))).as("Invalid file should be present", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testRemoveOrphanFilesWithHadoopCatalog() throws InterruptedException {
        HadoopCatalog catalog = new HadoopCatalog(new Configuration(), this.tableLocation);
        String namespaceName = "testDb";
        String tableName = "testTb";
        Namespace namespace = Namespace.of((String[])new String[]{namespaceName});
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        Table table = catalog.createTable(tableIdentifier, SCHEMA, PartitionSpec.unpartitioned(), (Map)Maps.newHashMap());
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(table.location());
        df.write().mode("append").parquet(table.location() + "/data");
        this.waitUntilAfter(System.currentTimeMillis());
        table.refresh();
        DeleteOrphanFiles.Result result = SparkActions.get().deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete only 1 file", new Object[0])).hasSize(1);
        Dataset resultDF = spark.read().format("iceberg").load(table.location());
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualRecords).as("Rows must match", new Object[0])).isEqualTo((Object)records);
    }

    @TestTemplate
    public void testHiveCatalogTable() throws IOException {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", this.randomName("hivetestorphan")});
        Table table = catalog.createTable(identifier, SCHEMA, SPEC, this.tableLocation, this.properties);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(identifier.toString());
        String location = table.location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result result = SparkActions.get().deleteOrphanFiles(table).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(result.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @TestTemplate
    public void testGarbageCollectionDisabled() {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        table.updateProperties().set("gc.enabled", "false").commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SparkActions.get().deleteOrphanFiles(table).execute()).isInstanceOf(ValidationException.class)).hasMessage("Cannot delete orphan files: GC is disabled (deleting files may corrupt other tables)");
    }

    @TestTemplate
    public void testCompareToFileList() throws IOException {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        Path dataPath = new Path(this.tableLocation + "/data");
        FileSystem fs = dataPath.getFileSystem(spark.sessionState().newHadoopConf());
        List validFiles = Arrays.stream(fs.listStatus(dataPath, (PathFilter)HiddenPathFilter.get())).filter(FileStatus::isFile).map(file -> new FilePathLastModifiedRecord(file.getPath().toString(), new Timestamp(file.getModificationTime()))).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(validFiles).as("Should be 2 valid files", new Object[0])).hasSize(2);
        df.write().mode("append").parquet(this.tableLocation + "/data");
        List allFiles = Arrays.stream(fs.listStatus(dataPath, (PathFilter)HiddenPathFilter.get())).filter(FileStatus::isFile).map(file -> new FilePathLastModifiedRecord(file.getPath().toString(), new Timestamp(file.getModificationTime()))).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(allFiles).as("Should be 3 files", new Object[0])).hasSize(3);
        ArrayList invalidFiles = Lists.newArrayList(allFiles);
        invalidFiles.removeAll(validFiles);
        List invalidFilePaths = invalidFiles.stream().map(FilePathLastModifiedRecord::getFilePath).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat((List)invalidFiles).as("Should be 1 invalid file", new Object[0])).hasSize(1);
        this.waitUntilAfter(System.currentTimeMillis());
        SparkActions actions = SparkActions.get();
        Dataset compareToFileList = spark.createDataFrame(allFiles, FilePathLastModifiedRecord.class).withColumnRenamed("filePath", "file_path").withColumnRenamed("lastModified", "last_modified");
        DeleteOrphanFiles.Result result1 = actions.deleteOrphanFiles(table).compareToFileList(compareToFileList).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result1.orphanFileLocations()).as("Default olderThan interval should be safe", new Object[0])).isEmpty();
        DeleteOrphanFiles.Result result2 = actions.deleteOrphanFiles(table).compareToFileList(compareToFileList).olderThan(System.currentTimeMillis()).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result2.orphanFileLocations()).as("Action should find 1 file", new Object[0])).isEqualTo(invalidFilePaths);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path((String)invalidFilePaths.get(0)))).as("Invalid file should be present", new Object[0])).isTrue();
        DeleteOrphanFiles.Result result3 = actions.deleteOrphanFiles(table).compareToFileList(compareToFileList).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result3.orphanFileLocations()).as("Action should delete 1 file", new Object[0])).isEqualTo(invalidFilePaths);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.exists(new Path((String)invalidFilePaths.get(0)))).as("Invalid file should not be present", new Object[0])).isFalse();
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records);
        expectedRecords.addAll(records);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actualRecords).as("Rows must match", new Object[0])).isEqualTo((Object)expectedRecords);
        ArrayList outsideLocationMockFiles = Lists.newArrayList((Object[])new FilePathLastModifiedRecord[]{new FilePathLastModifiedRecord("/tmp/mock1", new Timestamp(0L))});
        Dataset compareToFileListWithOutsideLocation = spark.createDataFrame((List)outsideLocationMockFiles, FilePathLastModifiedRecord.class).withColumnRenamed("filePath", "file_path").withColumnRenamed("lastModified", "last_modified");
        DeleteOrphanFiles.Result result4 = actions.deleteOrphanFiles(table).compareToFileList(compareToFileListWithOutsideLocation).deleteWith(s -> {}).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result4.orphanFileLocations()).as("Action should find nothing", new Object[0])).isEmpty();
    }

    @Override
    protected long waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
        return current;
    }

    @TestTemplate
    public void testRemoveOrphanFilesWithStatisticFiles() throws Exception {
        GenericStatisticsFile statisticsFile;
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.properties, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "AAAAAAAAAA", "AAAA")});
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).coalesce(1);
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
        table.refresh();
        long snapshotId = table.currentSnapshot().snapshotId();
        long snapshotSequenceNumber = table.currentSnapshot().sequenceNumber();
        File statsLocation = new File(new URI(this.tableLocation)).toPath().resolve("data").resolve("some-stats-file").toFile();
        try (PuffinWriter puffinWriter = Puffin.write((OutputFile)Files.localOutput((File)statsLocation)).build();){
            puffinWriter.add(new Blob("some-blob-type", (List)ImmutableList.of((Object)1), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap("blob content".getBytes(StandardCharsets.UTF_8))));
            puffinWriter.finish();
            statisticsFile = new GenericStatisticsFile(snapshotId, statsLocation.toString(), puffinWriter.fileSize(), puffinWriter.footerSize(), (List)puffinWriter.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
        }
        Transaction transaction = table.newTransaction();
        transaction.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        transaction.commitTransaction();
        SparkActions.get().deleteOrphanFiles(table).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((AbstractFileAssert)Assertions.assertThat((File)statsLocation).as("stats file should exist", new Object[0])).exists();
        ((AbstractLongAssert)Assertions.assertThat((long)statsLocation.length()).as("stats file length", new Object[0])).isEqualTo(statisticsFile.fileSizeInBytes());
        transaction = table.newTransaction();
        transaction.updateStatistics().removeStatistics(statisticsFile.snapshotId()).commit();
        transaction.commitTransaction();
        DeleteOrphanFiles.Result result = SparkActions.get().deleteOrphanFiles(table).olderThan(System.currentTimeMillis() + 1000L).execute();
        Iterable orphanFileLocations = result.orphanFileLocations();
        ((IterableAssert)Assertions.assertThat((Iterable)orphanFileLocations).as("Should be orphan file", new Object[0])).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)Iterables.getOnlyElement((Iterable)orphanFileLocations))).as("Deleted file", new Object[0])).isEqualTo(statsLocation.toURI().toString());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)statsLocation.exists()).as("stats file should be deleted", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testPathsWithExtraSlashes() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"file:///dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"file:///dir1/////dir2///file1"});
        this.executeTest(validFiles, actualFiles, Lists.newArrayList());
    }

    @TestTemplate
    public void testPathsWithValidFileHavingNoAuthority() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"hdfs:///dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename/dir1/dir2/file1"});
        this.executeTest(validFiles, actualFiles, Lists.newArrayList());
    }

    @TestTemplate
    public void testPathsWithActualFileHavingNoAuthority() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename/dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"hdfs:///dir1/dir2/file1"});
        this.executeTest(validFiles, actualFiles, Lists.newArrayList());
    }

    @TestTemplate
    public void testPathsWithEqualSchemes() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"scheme1://bucket1/dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"scheme2://bucket1/dir1/dir2/file1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeTest(validFiles, actualFiles, Lists.newArrayList(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), DeleteOrphanFiles.PrefixMismatchMode.ERROR)).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Unable to determine whether certain files are orphan").hasMessageEndingWith("Conflicting authorities/schemes: [(scheme1, scheme2)].");
        HashMap equalSchemes = Maps.newHashMap();
        equalSchemes.put("scheme1", "scheme");
        equalSchemes.put("scheme2", "scheme");
        this.executeTest(validFiles, actualFiles, Lists.newArrayList(), equalSchemes, (Map<String, String>)ImmutableMap.of(), DeleteOrphanFiles.PrefixMismatchMode.ERROR);
    }

    @TestTemplate
    public void testPathsWithEqualAuthorities() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename1/dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename2/dir1/dir2/file1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeTest(validFiles, actualFiles, Lists.newArrayList(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), DeleteOrphanFiles.PrefixMismatchMode.ERROR)).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Unable to determine whether certain files are orphan").hasMessageEndingWith("Conflicting authorities/schemes: [(servicename1, servicename2)].");
        HashMap equalAuthorities = Maps.newHashMap();
        equalAuthorities.put("servicename1", "servicename");
        equalAuthorities.put("servicename2", "servicename");
        this.executeTest(validFiles, actualFiles, Lists.newArrayList(), (Map<String, String>)ImmutableMap.of(), equalAuthorities, DeleteOrphanFiles.PrefixMismatchMode.ERROR);
    }

    @TestTemplate
    public void testRemoveOrphanFileActionWithDeleteMode() {
        ArrayList validFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename1/dir1/dir2/file1"});
        ArrayList actualFiles = Lists.newArrayList((Object[])new String[]{"hdfs://servicename2/dir1/dir2/file1"});
        this.executeTest(validFiles, actualFiles, Lists.newArrayList((Object[])new String[]{"hdfs://servicename2/dir1/dir2/file1"}), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), DeleteOrphanFiles.PrefixMismatchMode.DELETE);
    }

    protected String randomName(String prefix) {
        return prefix + UUID.randomUUID().toString().replace("-", "");
    }

    private void executeTest(List<String> validFiles, List<String> actualFiles, List<String> expectedOrphanFiles) {
        this.executeTest(validFiles, actualFiles, expectedOrphanFiles, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), DeleteOrphanFiles.PrefixMismatchMode.IGNORE);
    }

    private void executeTest(List<String> validFiles, List<String> actualFiles, List<String> expectedOrphanFiles, Map<String, String> equalSchemes, Map<String, String> equalAuthorities, DeleteOrphanFiles.PrefixMismatchMode mode) {
        DeleteOrphanFilesSparkAction.StringToFileURI toFileUri = new DeleteOrphanFilesSparkAction.StringToFileURI(equalSchemes, equalAuthorities);
        Dataset validFileDS = spark.createDataset(validFiles, Encoders.STRING());
        Dataset actualFileDS = spark.createDataset(actualFiles, Encoders.STRING());
        List orphanFiles = DeleteOrphanFilesSparkAction.findOrphanFiles((SparkSession)spark, (Dataset)toFileUri.apply(actualFileDS), (Dataset)toFileUri.apply(validFileDS), (DeleteOrphanFiles.PrefixMismatchMode)mode);
        Assertions.assertThat((List)orphanFiles).isEqualTo(expectedOrphanFiles);
    }
}

