/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFilesCommitManager;
import org.apache.iceberg.actions.RewriteFileGroup;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.BaseDVFileWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.actions.RewriteDataFilesSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestRewriteDataFilesAction
extends TestBase {
    @TempDir
    private File tableDir;
    private static final int SCALE = 400000;
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
    @Parameter
    private int formatVersion;
    private final FileRewriteCoordinator coordinator = FileRewriteCoordinator.get();
    private final ScanTaskSetManager manager = ScanTaskSetManager.get();
    private String tableLocation = null;

    @Parameters(name="formatVersion = {0}")
    protected static List<Object> parameters() {
        return Arrays.asList(2, 3);
    }

    @BeforeAll
    public static void setupSpark() {
        spark.conf().set(SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), "false");
    }

    @BeforeEach
    public void setupTableLocation() throws Exception {
        this.tableLocation = this.tableDir.toURI().toString();
    }

    private RewriteDataFilesSparkAction basicRewrite(Table table) {
        table.refresh();
        return (RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("min-input-files", "1");
    }

    @TestTemplate
    public void testEmptyTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        ImmutableMap options = ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion));
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ((ObjectAssert)Assertions.assertThat((Object)table.currentSnapshot()).as("Table must be empty", new Object[0])).isNull();
        this.basicRewrite(table).execute();
        ((ObjectAssert)Assertions.assertThat((Object)table.currentSnapshot()).as("Table must stay empty", new Object[0])).isNull();
    }

    @TestTemplate
    public void testBinPackUnpartitionedTable() {
        Table table = this.createTable(4);
        this.shouldHaveFiles(table, 4);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 4 data files", new Object[0])).isEqualTo(4);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 1 data file", new Object[0])).isOne();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 1);
        List<Object[]> actual = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actual);
    }

    @TestTemplate
    public void testBinPackPartitionedTable() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 8 data files", new Object[0])).isEqualTo(8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 4 data file", new Object[0])).isEqualTo(4);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackWithFilter() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).filter((Expression)Expressions.equal((String)"c1", (Object)1)).filter((Expression)Expressions.startsWith((String)"c2", (String)"foo")).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 2 data files", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 1 data file", new Object[0])).isOne();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        this.shouldHaveFiles(table, 7);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackWithFilterOnBucketExpression() {
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).filter((Expression)Expressions.equal((String)"c1", (Object)1)).filter((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"c2", (int)2), (Object)0)).execute();
        Assertions.assertThat((Object)result).extracting(new Function[]{RewriteDataFiles.Result::rewrittenDataFilesCount, RewriteDataFiles.Result::addedDataFilesCount}).as("Action should rewrite 2 data files into 1 data file", new Object[0]).contains(new Object[]{2, 1});
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        this.shouldHaveFiles(table, 7);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackAfterPartitionChange() {
        Table table = this.createTable();
        this.writeRecords(20, 400000, 20);
        this.shouldHaveFiles(table, 20);
        table.updateSpec().addField((Term)Expressions.ref((String)"c1")).commit();
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("min-input-files", "1")).option("min-file-size-bytes", Integer.toString(this.averageFileSize(table) + 1000))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) + 1001))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroup because all files were not correctly partitioned", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveFiles(table, 20);
    }

    @TestTemplate
    public void testDataFilesRewrittenWithMaxDeleteRatio() throws Exception {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTable();
        int numDataFiles = 5;
        this.writeRecords(numDataFiles, 100);
        int numPositionsToDelete = 1000;
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(dataFiles).hasSize(numDataFiles);
        RowDelta rowDelta = table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            if (this.formatVersion >= 3) {
                this.writeDV(table, dataFile.partition(), dataFile.location(), numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
                continue;
            }
            this.writePosDeletes(table, dataFile.partition(), dataFile.location(), 4, numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        rowDelta.commit();
        Set<DeleteFile> deleteFiles = TestHelpers.deleteFiles(table);
        int expectedDataFiles = this.formatVersion >= 3 ? numDataFiles : numDataFiles * 4;
        Assertions.assertThat(deleteFiles).hasSize(expectedDataFiles);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)SparkActions.get((SparkSession)spark).rewriteDataFiles(table).option("min-input-files", "10")).option("min-file-size-bytes", "0")).execute();
        Assertions.assertThat((int)result.rewrittenDataFilesCount()).isEqualTo(numDataFiles);
        table.refresh();
        List<DataFile> newDataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(newDataFiles).isEmpty();
        Set<DeleteFile> newDeleteFiles = TestHelpers.deleteFiles(table);
        Assertions.assertThat(newDeleteFiles).isEmpty();
    }

    @TestTemplate
    public void testDataFilesRewrittenWithHighDeleteRatio() throws Exception {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTable();
        int numDataFiles = 5;
        this.writeRecords(numDataFiles, 100);
        int numPositionsToDelete = 8;
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(dataFiles).hasSize(numDataFiles);
        RowDelta rowDelta = table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            if (this.formatVersion >= 3) {
                this.writeDV(table, dataFile.partition(), dataFile.location(), numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
                continue;
            }
            this.writePosDeletes(table, dataFile.partition(), dataFile.location(), 4, numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        rowDelta.commit();
        Set<DeleteFile> deleteFiles = TestHelpers.deleteFiles(table);
        int expectedDataFiles = this.formatVersion >= 3 ? numDataFiles : numDataFiles * 4;
        Assertions.assertThat(deleteFiles).hasSize(expectedDataFiles);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)SparkActions.get((SparkSession)spark).rewriteDataFiles(table).option("min-input-files", "10")).option("min-file-size-bytes", "0")).execute();
        Assertions.assertThat((int)result.rewrittenDataFilesCount()).isEqualTo(numDataFiles);
        table.refresh();
        List<DataFile> newDataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(newDataFiles).hasSize(1);
        Set<DeleteFile> newDeleteFiles = TestHelpers.deleteFiles(table);
        Assertions.assertThat(newDeleteFiles).isEmpty();
    }

    @TestTemplate
    public void testDataFilesNotRewrittenWithLowDeleteRatio() throws Exception {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTable();
        int numDataFiles = 5;
        this.writeRecords(numDataFiles, 100);
        int numPositionsToDelete = 5;
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(dataFiles).hasSize(numDataFiles);
        RowDelta rowDelta = table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            if (this.formatVersion >= 3) {
                this.writeDV(table, dataFile.partition(), dataFile.location(), numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
                continue;
            }
            this.writePosDeletes(table, dataFile.partition(), dataFile.location(), 5, numPositionsToDelete).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        rowDelta.commit();
        Set<DeleteFile> deleteFiles = TestHelpers.deleteFiles(table);
        int expectedDataFiles = this.formatVersion >= 3 ? numDataFiles : numDataFiles * 5;
        Assertions.assertThat(deleteFiles).hasSize(expectedDataFiles);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)SparkActions.get((SparkSession)spark).rewriteDataFiles(table).option("min-input-files", "10")).option("min-file-size-bytes", "0")).execute();
        Assertions.assertThat((int)result.rewrittenDataFilesCount()).isEqualTo(0);
        table.refresh();
        List<DataFile> newDataFiles = TestHelpers.dataFiles(table);
        Assertions.assertThat(newDataFiles).hasSameSizeAs(dataFiles);
        Set<DeleteFile> newDeleteFiles = TestHelpers.deleteFiles(table);
        Assertions.assertThat(newDeleteFiles).hasSameSizeAs(deleteFiles);
    }

    @TestTemplate
    public void testBinPackWithDeletes() throws IOException {
        RewriteDataFiles.Result result;
        int i;
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        int total = (int)dataFiles.stream().mapToLong(ContentFile::recordCount).sum();
        RowDelta rowDelta = table.newRowDelta();
        if (this.formatVersion >= 3) {
            for (i = 0; i < 3; ++i) {
                this.writeDV(table, dataFiles.get(i).partition(), dataFiles.get(i).location(), 1).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
            }
            for (i = 3; i < 5; ++i) {
                this.writeDV(table, dataFiles.get(i).partition(), dataFiles.get(i).location(), 2).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
            }
        } else {
            for (i = 0; i < 3; ++i) {
                this.writePosDeletesToFile(table, dataFiles.get(i), 1).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
            }
            for (i = 3; i < 5; ++i) {
                this.writePosDeletesToFile(table, dataFiles.get(i), 2).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
            }
        }
        rowDelta.commit();
        table.refresh();
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        if (this.formatVersion >= 3) {
            result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("min-file-size-bytes", "0")).option("target-file-size-bytes", Long.toString(0x7FFFFFFFFFFFFFFEL))).option("max-file-size-bytes", Long.toString(Long.MAX_VALUE))).option("delete-file-threshold", "1")).execute();
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 5 data files", new Object[0])).isEqualTo(5);
            Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        } else {
            result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("min-file-size-bytes", "0")).option("target-file-size-bytes", Long.toString(0x7FFFFFFFFFFFFFFEL))).option("max-file-size-bytes", Long.toString(Long.MAX_VALUE))).option("delete-file-threshold", "2")).execute();
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 2 data files", new Object[0])).isEqualTo(2);
            Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        }
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        ((ListAssert)Assertions.assertThat(actualRecords).as("7 rows are removed", new Object[0])).hasSize(total - 7);
    }

    @TestTemplate
    public void testRemoveDangledEqualityDeletesPartitionEvolution() {
        Table table = TABLES.create(SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)), this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(0, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(0, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        this.shouldHaveFiles(table, 4);
        this.writeEqDeleteRecord(table, "c1", 1, "c3", "AAAA");
        this.writeEqDeleteRecord(table, "c1", 2, "c3", "CCCC");
        table.refresh();
        Set<DeleteFile> existingDeletes = TestHelpers.deleteFiles(table);
        ((AbstractCollectionAssert)Assertions.assertThat(existingDeletes).as("Only one equality delete c1=1 is used in query planning", new Object[0])).hasSize(1);
        table.refresh();
        table.updateSpec().addField((Term)Expressions.ref((String)"c3")).commit();
        ArrayList records3 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, "A", "CCCC"), new ThreeColumnRecord(2, "D", "DDDD")});
        this.writeRecords(records3);
        List<Object[]> originalData = this.currentData();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-all", "true")).filter((Expression)Expressions.equal((String)"c1", (Object)1)).option("remove-dangling-deletes", "true")).execute();
        existingDeletes = TestHelpers.deleteFiles(table);
        ((AbstractCollectionAssert)Assertions.assertThat(existingDeletes).as("Shall pruned dangling deletes after rewrite", new Object[0])).hasSize(0);
        Assertions.assertThat((Object)result).extracting(new Function[]{RewriteDataFiles.Result::addedDataFilesCount, RewriteDataFiles.Result::rewrittenDataFilesCount, RewriteDataFiles.Result::removedDeleteFilesCount}).as("Should compact 3 data files into 2 and remove both dangled equality delete file", new Object[0]).containsExactly(new Object[]{2, 3, 2});
        this.shouldHaveMinSequenceNumberInPartition(table, "data_file.partition.c1 == 1", 5L);
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 7);
        this.shouldHaveFiles(table, 5);
    }

    @TestTemplate
    public void testRemoveDangledPositionDeletesPartitionEvolution() throws IOException {
        Table table = TABLES.create(SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)), this.tableLocation);
        this.writeRecords(2, 2, 2);
        List<DataFile> dataFilesBefore = TestHelpers.dataFiles(table, null);
        this.shouldHaveFiles(table, 4);
        DataFile dataFile = dataFilesBefore.get(3);
        DeleteFile deleteFile = this.formatVersion >= 3 ? this.writeDV(table, dataFile.partition(), dataFile.location(), 1).get(0) : this.writePosDeletesToFile(table, dataFile, 1).get(0);
        table.newRowDelta().addDeletes(deleteFile).commit();
        table.updateSpec().addField((Term)Expressions.ref((String)"c3")).commit();
        this.writeRecords(1, 1, 1);
        this.shouldHaveFiles(table, 5);
        List<Object[]> expectedRecords = this.currentData();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).filter((Expression)Expressions.equal((String)"c1", (Object)1)).option("rewrite-all", "true")).option("remove-dangling-deletes", "true")).execute();
        Assertions.assertThat((Object)result).extracting(new Function[]{RewriteDataFiles.Result::addedDataFilesCount, RewriteDataFiles.Result::rewrittenDataFilesCount, RewriteDataFiles.Result::removedDeleteFilesCount}).as("Should rewrite 2 data files into 1 and remove 1 dangled position delete file", new Object[0]).containsExactly(new Object[]{1, 2, 1});
        this.shouldHaveMinSequenceNumberInPartition(table, "data_file.partition.c1 == 1", 3L);
        this.shouldHaveSnapshots(table, 5);
        Assertions.assertThat((String)((String)table.currentSnapshot().summary().get("total-position-deletes"))).isEqualTo("0");
        this.assertEquals("Rows must match", expectedRecords, this.currentData());
    }

    @TestTemplate
    public void testBinPackWithDeleteAllData() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(1, 1, 1);
        this.shouldHaveFiles(table, 1);
        table.refresh();
        List<DataFile> dataFiles = TestHelpers.dataFiles(table);
        int total = (int)dataFiles.stream().mapToLong(ContentFile::recordCount).sum();
        RowDelta rowDelta = table.newRowDelta();
        DataFile dataFile = dataFiles.get(0);
        if (this.formatVersion >= 3) {
            this.writeDV(table, dataFile.partition(), dataFile.location(), total).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        } else {
            this.writePosDeletesToFile(table, dataFile, total).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        }
        rowDelta.commit();
        table.refresh();
        List<Object[]> expectedRecords = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("delete-file-threshold", "1")).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 1 data files", new Object[0])).isOne();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((ManifestFile)table.currentSnapshot().dataManifests(table.io()).get(0)).existingFilesCount()).as("Data manifest should not have existing data file", new Object[0])).isZero();
        ((AbstractLongAssert)Assertions.assertThat((long)((ManifestFile)table.currentSnapshot().dataManifests(table.io()).get(0)).deletedFilesCount().intValue()).as("Data manifest should have 1 delete data file", new Object[0])).isEqualTo(1L);
        ((AbstractLongAssert)Assertions.assertThat((Long)((ManifestFile)table.currentSnapshot().deleteManifests(table.io()).get(0)).addedRowsCount()).as("Delete manifest added row count should equal total count", new Object[0])).isEqualTo((long)total);
    }

    @TestTemplate
    public void testBinPackWithStartingSequenceNumber() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        table.refresh();
        long oldSequenceNumber = table.currentSnapshot().sequenceNumber();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("use-starting-sequence-number", "true")).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 8 data files", new Object[0])).isEqualTo(8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 4 data files", new Object[0])).isEqualTo(4);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        table.refresh();
        ((AbstractLongAssert)Assertions.assertThat((long)table.currentSnapshot().sequenceNumber()).as("Table sequence number should be incremented", new Object[0])).isGreaterThan(oldSequenceNumber);
        Dataset rows = SparkTableUtil.loadMetadataTable((SparkSession)spark, (Table)table, (MetadataTableType)MetadataTableType.ENTRIES);
        for (Row row : rows.collectAsList()) {
            if (row.getInt(0) != 1) continue;
            ((AbstractLongAssert)Assertions.assertThat((long)row.getLong(2)).as("Expect old sequence number for added entries", new Object[0])).isEqualTo(oldSequenceNumber);
        }
    }

    @TestTemplate
    public void testBinPackWithStartingSequenceNumberV1Compatibility() {
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)"1");
        Table table = this.createTablePartitioned(4, 2, 400000, (Map<String, String>)properties);
        this.shouldHaveFiles(table, 8);
        List<Object[]> expectedRecords = this.currentData();
        table.refresh();
        long oldSequenceNumber = table.currentSnapshot().sequenceNumber();
        ((AbstractLongAssert)Assertions.assertThat((long)oldSequenceNumber).as("Table sequence number should be 0", new Object[0])).isZero();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("use-starting-sequence-number", "true")).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 8 data files", new Object[0])).isEqualTo(8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 4 data files", new Object[0])).isEqualTo(4);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 4);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
        table.refresh();
        ((AbstractLongAssert)Assertions.assertThat((long)table.currentSnapshot().sequenceNumber()).as("Table sequence number should still be 0", new Object[0])).isEqualTo(oldSequenceNumber);
        Dataset rows = SparkTableUtil.loadMetadataTable((SparkSession)spark, (Table)table, (MetadataTableType)MetadataTableType.ENTRIES);
        for (Row row : rows.collectAsList()) {
            ((AbstractLongAssert)Assertions.assertThat((long)row.getLong(2)).as("Expect sequence number 0 for all entries", new Object[0])).isEqualTo(oldSequenceNumber);
        }
    }

    @TestTemplate
    public void testRewriteLargeTableHasResiduals() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).build();
        ImmutableMap options = ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion), (Object)"write.parquet.row-group-size-bytes", (Object)"100");
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            records.add(new ThreeColumnRecord(i, String.valueOf(i), String.valueOf(i % 4)));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
        List<Object[]> expectedRecords = this.currentData();
        table.refresh();
        CloseableIterable tasks = ((TableScan)((TableScan)table.newScan().ignoreResiduals()).filter((Expression)Expressions.equal((String)"c3", (Object)"0"))).planFiles();
        for (FileScanTask task : tasks) {
            ((ObjectAssert)Assertions.assertThat((Object)task.residual()).as("Residuals must be ignored", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        }
        this.shouldHaveFiles(table, 2);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = this.basicRewrite(table).filter((Expression)Expressions.equal((String)"c3", (Object)"0")).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should rewrite 2 data files", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 1 data file", new Object[0])).isOne();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackSplitLargeFile() {
        Table table = this.createTable(1);
        this.shouldHaveFiles(table, 1);
        List<Object[]> expectedRecords = this.currentData();
        long targetSize = this.testDataSize(table) / 2L;
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Long.toString(targetSize))).option("max-file-size-bytes", Long.toString(targetSize * 2L - 2000L))).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should delete 1 data files", new Object[0])).isOne();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 2 data files", new Object[0])).isEqualTo(2);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 2);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackCombineMixedFiles() {
        Table table = this.createTable(1);
        this.shouldHaveFiles(table, 1);
        this.writeRecords(1, 400000);
        this.writeRecords(1, 1200000);
        this.shouldHaveFiles(table, 3);
        List<Object[]> expectedRecords = this.currentData();
        int targetSize = this.averageFileSize(table);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Integer.toString(targetSize + 1000))).option("max-file-size-bytes", Integer.toString(targetSize + 80000))).option("min-file-size-bytes", Integer.toString(targetSize - 1000))).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should delete 3 data files", new Object[0])).isEqualTo(3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 3 data files", new Object[0])).isEqualTo(3);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 3);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testBinPackCombineMediumFiles() {
        Table table = this.createTable(4);
        this.shouldHaveFiles(table, 4);
        List<Object[]> expectedRecords = this.currentData();
        int targetSize = (int)this.testDataSize(table) / 3;
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("target-file-size-bytes", Integer.toString(targetSize))).option("max-file-size-bytes", Integer.toString((int)((double)targetSize * 1.8)))).option("min-file-size-bytes", Integer.toString(targetSize - 100))).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.rewrittenDataFilesCount()).as("Action should delete 4 data files", new Object[0])).isEqualTo(4);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.addedDataFilesCount()).as("Action should add 3 data files", new Object[0])).isEqualTo(3);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        this.shouldHaveFiles(table, 3);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Rows must match", expectedRecords, actualRecords);
    }

    @TestTemplate
    public void testPartialProgressEnabled() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        table.updateProperties().set("commit.retry.num-retries", "10").commit();
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("partial-progress.enabled", "true")).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.max-commits", "10")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 10 fileGroups", new Object[0])).hasSize(10);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        this.shouldHaveSnapshots(table, 11);
        this.shouldHaveACleanCache(table);
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
    }

    @TestTemplate
    public void testMultipleGroups() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("min-input-files", "1")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 10 fileGroups", new Object[0])).hasSize(10);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testPartialProgressMaxCommits() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 10 fileGroups", new Object[0])).hasSize(10);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 4);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testSingleCommitWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000));
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)spyRewrite).execute()).isInstanceOf(RuntimeException.class)).hasMessage("Rewrite Failed");
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testSingleCommitWithCommitFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000));
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doThrow((Throwable[])new Throwable[]{new CommitFailedException("Commit Failure", new Object[0])}).when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyRewrite)).commitManager(table.currentSnapshot().snapshotId());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)spyRewrite).execute()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Cannot commit rewrite");
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testCommitFailsWithUncleanableFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000));
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Arbitrary Failure")}).when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyRewrite)).commitManager(table.currentSnapshot().snapshotId());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)spyRewrite).execute()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Arbitrary Failure");
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testParallelSingleCommitWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new CommitFailedException("Rewrite Failed", new Object[0])}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)spyRewrite).execute()).isInstanceOf(CommitFailedException.class)).hasMessage("Rewrite Failed");
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 1);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testPartialProgressWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        RewriteDataFiles.Result result = spyRewrite.execute();
        Assertions.assertThat((List)result.rewriteResults()).hasSize(7);
        Assertions.assertThat((List)result.rewriteFailures()).hasSize(3);
        Assertions.assertThat((int)result.failedDataFilesCount()).isEqualTo(6);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testParallelPartialProgressWithRewriteFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3")).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        RewriteDataFiles.Result result = spyRewrite.execute();
        Assertions.assertThat((List)result.rewriteResults()).hasSize(7);
        Assertions.assertThat((List)result.rewriteFailures()).hasSize(3);
        Assertions.assertThat((int)result.failedDataFilesCount()).isEqualTo(6);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testParallelPartialProgressWithCommitFailure() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3")).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doCallRealMethod().doThrow(new Throwable[]{new CommitFailedException("Commit Failed", new Object[0])}).doCallRealMethod().when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyRewrite)).commitManager(table.currentSnapshot().snapshotId());
        RewriteDataFiles.Result result = spyRewrite.execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 6 fileGroups", new Object[0])).hasSize(6);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isGreaterThan(0L).isLessThan(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testParallelPartialProgressWithMaxFailedCommits() {
        Table table = this.createTable(20);
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction realRewrite = (RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).option("max-concurrent-file-group-rewrites", "3")).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "3")).option("partial-progress.max-failed-commits", "0");
        RewriteDataFilesSparkAction spyRewrite = (RewriteDataFilesSparkAction)Mockito.spy((Object)realRewrite);
        GroupInfoMatcher failGroup = new GroupInfoMatcher(1, 3, 7);
        ((RewriteDataFilesSparkAction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Rewrite Failed")}).when((Object)spyRewrite)).rewriteFiles((RewriteDataFilesSparkAction.RewriteExecutionContext)ArgumentMatchers.any(), (RewriteFileGroup)ArgumentMatchers.argThat((ArgumentMatcher)failGroup));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyRewrite.execute()).isInstanceOf(RuntimeException.class)).hasMessageContaining("1 rewrite commits failed. This is more than the maximum allowed failures of 0");
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 3);
        this.shouldHaveNoOrphans(table);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testInvalidOptions() {
        Table table = this.createTable(20);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("partial-progress.enabled", "true")).option("partial-progress.max-commits", "-5")).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set partial-progress.max-commits to -5, the value must be positive when partial-progress.enabled is true");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("max-concurrent-file-group-rewrites", "-5")).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set max-concurrent-file-group-rewrites to -5, the value must be positive.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("foobarity", "-5")).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot use options [foobarity], they are not supported by the action or the rewriter BIN-PACK");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", "foo")).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid rewrite job order name: foo");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build()).option("shuffle-partitions-per-file", "5")).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("requires enabling Iceberg Spark session extensions");
    }

    @TestTemplate
    public void testSortMultipleGroups() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        int fileSize = this.averageFileSize(table);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("rewrite-all", "true")).option("max-file-group-size-bytes", Integer.toString(fileSize * 2 + 1000))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 10 fileGroups", new Object[0])).hasSize(10);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testSimpleSort() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("min-input-files", "1")).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @TestTemplate
    public void testSortAfterPartitionChange() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        table.updateSpec().addField((Term)Expressions.bucket((String)"c1", (int)4)).commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).commit();
        this.shouldHaveLastCommitUnsorted(table, "c2");
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort().option("min-input-files", "1")).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups because all files were not correctly partitioned", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @TestTemplate
    public void testSortCustomSortOrder() {
        Table table = this.createTable(20);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build()).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table)))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @TestTemplate
    public void testSortCustomSortOrderRequiresRepartition() {
        int partitions = 4;
        Table table = this.createTable();
        this.writeRecords(20, 400000, partitions);
        this.shouldHaveLastCommitUnsorted(table, "c3");
        table.updateSpec().addField("c1").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("c2")).apply();
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c3")).build()).option("rewrite-all", "true")).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / partitions))).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveLastCommitSorted(table, "c3");
    }

    @TestTemplate
    public void testAutoSortShuffleOutput() {
        Table table = this.createTable(20);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).sort(((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build()).option("max-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2 + 2))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2))).option("min-input-files", "1")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)table.currentSnapshot().addedDataFiles(table.io())).as("Should have written 40+ files", new Object[0])).hasSizeGreaterThanOrEqualTo(40);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        this.shouldHaveMultipleFiles(table);
        this.shouldHaveLastCommitSorted(table, "c2");
    }

    @TestTemplate
    public void testCommitStateUnknownException() {
        Table table = this.createTable(20);
        this.shouldHaveFiles(table, 20);
        List<Object[]> originalData = this.currentData();
        RewriteDataFilesSparkAction action = this.basicRewrite(table);
        RewriteDataFilesSparkAction spyAction = (RewriteDataFilesSparkAction)Mockito.spy((Object)action);
        RewriteDataFilesCommitManager util = (RewriteDataFilesCommitManager)Mockito.spy((Object)new RewriteDataFilesCommitManager(table));
        ((RewriteDataFilesCommitManager)Mockito.doAnswer(invocationOnMock -> {
            invocationOnMock.callRealMethod();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Unknown State"));
        }).when((Object)util)).commitFileGroups((Set)ArgumentMatchers.any());
        ((RewriteDataFilesSparkAction)Mockito.doReturn((Object)util).when((Object)spyAction)).commitManager(table.currentSnapshot().snapshotId());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)spyAction).execute()).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Unknown State\nCannot determine whether the commit was successful or not");
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
    }

    @TestTemplate
    public void testZOrderSort() {
        int originalFiles = 20;
        Table table = this.createTable(originalFiles);
        this.shouldHaveLastCommitUnsorted(table, "c2");
        this.shouldHaveFiles(table, originalFiles);
        List<Object[]> originalData = this.currentData();
        double originalFilesC2 = this.percentFilesRequired(table, "c2", "foo23");
        double originalFilesC3 = this.percentFilesRequired(table, "c3", "bar21");
        double originalFilesC2C3 = this.percentFilesRequired(table, new String[]{"c2", "c3"}, new String[]{"foo23", "bar23"});
        ((AbstractDoubleAssert)Assertions.assertThat((double)originalFilesC2).as("Should require all files to scan c2", new Object[0])).isGreaterThan(0.99);
        ((AbstractDoubleAssert)Assertions.assertThat((double)originalFilesC3).as("Should require all files to scan c3", new Object[0])).isGreaterThan(0.99);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).zOrder(new String[]{"c2", "c3"}).option("max-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2 + 2))).option("target-file-size-bytes", Integer.toString(this.averageFileSize(table) / 2))).option("min-input-files", "1")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        ((IterableAssert)Assertions.assertThat((Iterable)table.currentSnapshot().addedDataFiles(table.io())).as("Should have written 40+ files", new Object[0])).hasSizeGreaterThanOrEqualTo(40);
        table.refresh();
        List<Object[]> postRewriteData = this.currentData();
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
        double filesScannedC2 = this.percentFilesRequired(table, "c2", "foo23");
        double filesScannedC3 = this.percentFilesRequired(table, "c3", "bar21");
        double filesScannedC2C3 = this.percentFilesRequired(table, new String[]{"c2", "c3"}, new String[]{"foo23", "bar23"});
        ((AbstractDoubleAssert)Assertions.assertThat((double)originalFilesC2).as("Should have reduced the number of files required for c2", new Object[0])).isGreaterThan(filesScannedC2);
        ((AbstractDoubleAssert)Assertions.assertThat((double)originalFilesC3).as("Should have reduced the number of files required for c3", new Object[0])).isGreaterThan(filesScannedC3);
        ((AbstractDoubleAssert)Assertions.assertThat((double)originalFilesC2C3).as("Should have reduced the number of files required for c2,c3 predicate", new Object[0])).isGreaterThan(filesScannedC2C3);
    }

    @TestTemplate
    public void testZOrderAllTypesSort() {
        Table table = this.createTypeTestTable();
        this.shouldHaveFiles(table, 10);
        List originalRaw = spark.read().format("iceberg").load(this.tableLocation).sort("longCol", new String[0]).collectAsList();
        List<Object[]> originalData = this.rowsToJava(originalRaw);
        long dataSizeBefore = this.testDataSize(table);
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).zOrder(new String[]{"longCol", "intCol", "floatCol", "doubleCol", "dateCol", "timestampCol", "stringCol", "binaryCol", "booleanCol"}).option("min-input-files", "1")).option("rewrite-all", "true")).execute();
        ((ListAssert)Assertions.assertThat((List)result.rewriteResults()).as("Should have 1 fileGroups", new Object[0])).hasSize(1);
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        ((IterableAssert)Assertions.assertThat((Iterable)table.currentSnapshot().addedDataFiles(table.io())).as("Should have written 1 file", new Object[0])).hasSize(1);
        table.refresh();
        List postRaw = spark.read().format("iceberg").load(this.tableLocation).sort("longCol", new String[0]).collectAsList();
        List<Object[]> postRewriteData = this.rowsToJava(postRaw);
        this.assertEquals("We shouldn't have changed the data", originalData, postRewriteData);
        this.shouldHaveSnapshots(table, 2);
        this.shouldHaveACleanCache(table);
    }

    @TestTemplate
    public void testInvalidAPIUsage() {
        Table table = this.createTable(1);
        SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.actions().rewriteDataFiles(table).binPack().sort()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must use only one rewriter type (bin-pack, sort, zorder)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.actions().rewriteDataFiles(table).sort(sortOrder).binPack()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must use only one rewriter type (bin-pack, sort, zorder)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.actions().rewriteDataFiles(table).sort(sortOrder).binPack()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Must use only one rewriter type (bin-pack, sort, zorder)");
    }

    @TestTemplate
    public void testRewriteJobOrderBytesAsc() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.BYTES_ASC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        expected.sort(Comparator.naturalOrder());
        ((ListAssert)Assertions.assertThat(actual).as("Size in bytes order should be ascending", new Object[0])).isEqualTo(expected);
        Collections.reverse(expected);
        ((ListAssert)Assertions.assertThat(actual).as("Size in bytes order should not be descending", new Object[0])).isNotEqualTo(expected);
    }

    @TestTemplate
    public void testRewriteJobOrderBytesDesc() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.BYTES_DESC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::sizeInBytes).boxed().collect(Collectors.toList());
        expected.sort(Comparator.reverseOrder());
        ((ListAssert)Assertions.assertThat(actual).as("Size in bytes order should be descending", new Object[0])).isEqualTo(expected);
        Collections.reverse(expected);
        ((ListAssert)Assertions.assertThat(actual).as("Size in bytes order should not be ascending", new Object[0])).isNotEqualTo(expected);
    }

    @TestTemplate
    public void testRewriteJobOrderFilesAsc() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.FILES_ASC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        expected.sort(Comparator.naturalOrder());
        ((ListAssert)Assertions.assertThat(actual).as("Number of files order should be ascending", new Object[0])).isEqualTo(expected);
        Collections.reverse(expected);
        ((ListAssert)Assertions.assertThat(actual).as("Number of files order should not be descending", new Object[0])).isNotEqualTo(expected);
    }

    @TestTemplate
    public void testRewriteJobOrderFilesDesc() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(2);
        Table table = this.createTablePartitioned(4, 2);
        this.writeRecords(1, 400000, 1);
        this.writeRecords(2, 400000, 2);
        this.writeRecords(3, 400000, 3);
        this.writeRecords(4, 400000, 4);
        RewriteDataFilesSparkAction basicRewrite = this.basicRewrite(table).binPack();
        List expected = this.toGroupStream(table, basicRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        RewriteDataFilesSparkAction jobOrderRewrite = ((RewriteDataFilesSparkAction)this.basicRewrite(table).option("rewrite-job-order", RewriteJobOrder.FILES_DESC.orderName())).binPack();
        List actual = this.toGroupStream(table, jobOrderRewrite).mapToLong(RewriteFileGroup::numFiles).boxed().collect(Collectors.toList());
        expected.sort(Comparator.reverseOrder());
        ((ListAssert)Assertions.assertThat(actual).as("Number of files order should be descending", new Object[0])).isEqualTo(expected);
        Collections.reverse(expected);
        ((ListAssert)Assertions.assertThat(actual).as("Number of files order should not be ascending", new Object[0])).isNotEqualTo(expected);
    }

    @TestTemplate
    public void testSnapshotProperty() {
        Table table = this.createTable(4);
        RewriteDataFiles.Result ignored = ((RewriteDataFilesSparkAction)this.basicRewrite(table).snapshotProperty("key", "value")).execute();
        Assertions.assertThat((Map)table.currentSnapshot().summary()).containsAllEntriesOf((Map)ImmutableMap.of((Object)"key", (Object)"value"));
        Object[] commitMetricsKeys = new String[]{"added-data-files", "deleted-data-files", "total-data-files", "changed-partition-count"};
        Assertions.assertThat((Map)table.currentSnapshot().summary()).containsKeys(commitMetricsKeys);
    }

    @TestTemplate
    public void testBinPackRewriterWithSpecificUnparitionedOutputSpec() {
        Table table = this.createTable(10);
        this.shouldHaveFiles(table, 10);
        int outputSpecId = table.spec().specId();
        table.updateSpec().addField((Term)Expressions.truncate((String)"c2", (int)2)).commit();
        long dataSizeBefore = this.testDataSize(table);
        long count = this.currentData().size();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("output-spec-id", String.valueOf(outputSpecId))).option("rewrite-all", "true")).binPack().execute();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        Assertions.assertThat((int)this.currentData().size()).isEqualTo(count);
        this.shouldRewriteDataFilesWithPartitionSpec(table, outputSpecId);
    }

    @TestTemplate
    public void testBinPackRewriterWithSpecificOutputSpec() {
        Table table = this.createTable(10);
        this.shouldHaveFiles(table, 10);
        table.updateSpec().addField((Term)Expressions.truncate((String)"c2", (int)2)).commit();
        int outputSpecId = table.spec().specId();
        table.updateSpec().addField((Term)Expressions.bucket((String)"c3", (int)2)).commit();
        long dataSizeBefore = this.testDataSize(table);
        long count = this.currentData().size();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("output-spec-id", String.valueOf(outputSpecId))).option("rewrite-all", "true")).binPack().execute();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        Assertions.assertThat((int)this.currentData().size()).isEqualTo(count);
        this.shouldRewriteDataFilesWithPartitionSpec(table, outputSpecId);
    }

    @TestTemplate
    public void testBinpackRewriteWithInvalidOutputSpecId() {
        Table table = this.createTable(10);
        this.shouldHaveFiles(table, 10);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RewriteDataFilesSparkAction)this.actions().rewriteDataFiles(table).option("output-spec-id", String.valueOf(1234))).binPack().execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot use output spec id 1234 because the table does not contain a reference to this spec-id.");
    }

    @TestTemplate
    public void testSortRewriterWithSpecificOutputSpecId() {
        Table table = this.createTable(10);
        this.shouldHaveFiles(table, 10);
        table.updateSpec().addField((Term)Expressions.truncate((String)"c2", (int)2)).commit();
        int outputSpecId = table.spec().specId();
        table.updateSpec().addField((Term)Expressions.bucket((String)"c3", (int)2)).commit();
        long dataSizeBefore = this.testDataSize(table);
        long count = this.currentData().size();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("output-spec-id", String.valueOf(outputSpecId))).option("rewrite-all", "true")).sort(((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).asc("c2")).asc("c3")).build()).execute();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        Assertions.assertThat((int)this.currentData().size()).isEqualTo(count);
        this.shouldRewriteDataFilesWithPartitionSpec(table, outputSpecId);
    }

    @TestTemplate
    public void testZOrderRewriteWithSpecificOutputSpecId() {
        Table table = this.createTable(10);
        this.shouldHaveFiles(table, 10);
        table.updateSpec().addField((Term)Expressions.truncate((String)"c2", (int)2)).commit();
        int outputSpecId = table.spec().specId();
        table.updateSpec().addField((Term)Expressions.bucket((String)"c3", (int)2)).commit();
        long dataSizeBefore = this.testDataSize(table);
        long count = this.currentData().size();
        RewriteDataFiles.Result result = ((RewriteDataFilesSparkAction)((RewriteDataFilesSparkAction)this.basicRewrite(table).option("output-spec-id", String.valueOf(outputSpecId))).option("rewrite-all", "true")).zOrder(new String[]{"c2", "c3"}).execute();
        Assertions.assertThat((long)result.rewrittenBytesCount()).isEqualTo(dataSizeBefore);
        Assertions.assertThat((int)this.currentData().size()).isEqualTo(count);
        this.shouldRewriteDataFilesWithPartitionSpec(table, outputSpecId);
    }

    protected void shouldRewriteDataFilesWithPartitionSpec(Table table, int outputSpecId) {
        List<DataFile> rewrittenFiles = this.currentDataFiles(table);
        Assertions.assertThat(rewrittenFiles).allMatch(file -> file.specId() == outputSpecId);
        Assertions.assertThat(rewrittenFiles).allMatch(file -> ((PartitionData)file.partition()).getPartitionType().equals((Object)((PartitionSpec)table.specs().get(outputSpecId)).partitionType()));
    }

    protected List<DataFile> currentDataFiles(Table table) {
        return Streams.stream((Iterable)table.newScan().planFiles()).map(ContentScanTask::file).collect(Collectors.toList());
    }

    private Stream<RewriteFileGroup> toGroupStream(Table table, RewriteDataFilesSparkAction rewrite) {
        rewrite.validateAndInitOptions();
        StructLikeMap fileGroupsByPartition = rewrite.planFileGroups(table.currentSnapshot().snapshotId());
        return rewrite.toGroupStream(new RewriteDataFilesSparkAction.RewriteExecutionContext(fileGroupsByPartition), (Map)fileGroupsByPartition);
    }

    protected List<Object[]> currentData() {
        return this.rowsToJava(spark.read().format("iceberg").load(this.tableLocation).sort("c1", new String[]{"c2", "c3"}).collectAsList());
    }

    protected long testDataSize(Table table) {
        return Streams.stream((Iterable)table.newScan().planFiles()).mapToLong(ContentScanTask::length).sum();
    }

    protected void shouldHaveMultipleFiles(Table table) {
        table.refresh();
        int numFiles = Iterables.size((Iterable)table.newScan().planFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((int)numFiles).as(String.format("Should have multiple files, had %d", numFiles), new Object[0])).isGreaterThan(1);
    }

    protected void shouldHaveFiles(Table table, int numExpected) {
        table.refresh();
        int numFiles = Iterables.size((Iterable)table.newScan().planFiles());
        ((AbstractIntegerAssert)Assertions.assertThat((int)numFiles).as("Did not have the expected number of files", new Object[0])).isEqualTo(numExpected);
    }

    protected long shouldHaveMinSequenceNumberInPartition(Table table, String partitionFilter, long expected) {
        long actual = (Long)SparkTableUtil.loadMetadataTable((SparkSession)spark, (Table)table, (MetadataTableType)MetadataTableType.ENTRIES).filter("status != 2").filter(partitionFilter).select("sequence_number", new String[0]).agg(functions.min((String)"sequence_number"), new Column[0]).as(Encoders.LONG()).collectAsList().get(0);
        ((AbstractLongAssert)Assertions.assertThat((long)actual).as("Did not have the expected min sequence number", new Object[0])).isEqualTo(expected);
        return actual;
    }

    protected void shouldHaveSnapshots(Table table, int expectedSnapshots) {
        table.refresh();
        int actualSnapshots = Iterables.size((Iterable)table.snapshots());
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSnapshots).as("Table did not have the expected number of snapshots", new Object[0])).isEqualTo(expectedSnapshots);
    }

    protected void shouldHaveNoOrphans(Table table) {
        ((IterableAssert)Assertions.assertThat((Iterable)this.actions().deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute().orphanFileLocations()).as("Should not have found any orphan files", new Object[0])).isEmpty();
    }

    protected void shouldHaveOrphans(Table table) {
        ((IterableAssert)Assertions.assertThat((Iterable)this.actions().deleteOrphanFiles(table).olderThan(System.currentTimeMillis()).execute().orphanFileLocations()).as("Should have found orphan files", new Object[0])).isNotEmpty();
    }

    protected void shouldHaveACleanCache(Table table) {
        ((AbstractCollectionAssert)Assertions.assertThat(this.cacheContents(table)).as("Should not have any entries in cache", new Object[0])).isEmpty();
    }

    protected <T> void shouldHaveLastCommitSorted(Table table, String column) {
        List<Pair<Pair<T, T>, Pair<T, T>>> overlappingFiles = this.checkForOverlappingFiles(table, column);
        ((ListAssert)Assertions.assertThat(overlappingFiles).as("Found overlapping files", new Object[0])).isEmpty();
    }

    protected <T> void shouldHaveLastCommitUnsorted(Table table, String column) {
        List<Pair<Pair<T, T>, Pair<T, T>>> overlappingFiles = this.checkForOverlappingFiles(table, column);
        ((ListAssert)Assertions.assertThat(overlappingFiles).as("Found no overlapping files", new Object[0])).isNotEmpty();
    }

    private <T> Pair<T, T> boundsOf(DataFile file, Types.NestedField field, Class<T> javaClass) {
        int columnId = field.fieldId();
        return Pair.of(javaClass.cast(Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.lowerBounds().get(columnId)))), javaClass.cast(Conversions.fromByteBuffer((Type)field.type(), (ByteBuffer)((ByteBuffer)file.upperBounds().get(columnId)))));
    }

    private <T> List<Pair<Pair<T, T>, Pair<T, T>>> checkForOverlappingFiles(Table table, String column) {
        table.refresh();
        Types.NestedField field = table.schema().caseInsensitiveFindField(column);
        Class javaClass = field.type().typeId().javaClass();
        Snapshot snapshot = table.currentSnapshot();
        Map<StructLike, List<DataFile>> filesByPartition = Streams.stream((Iterable)snapshot.addedDataFiles(table.io())).collect(Collectors.groupingBy(ContentFile::partition));
        Stream overlaps = filesByPartition.entrySet().stream().flatMap(entry -> {
            List datafiles = (List)entry.getValue();
            Preconditions.checkArgument((datafiles.size() > 1 ? 1 : 0) != 0, (String)"This test is checking for overlaps in a situation where no overlaps can actually occur because the partition %s does not contain multiple datafiles", entry.getKey());
            List boundComparisons = Lists.cartesianProduct((List[])new List[]{datafiles, datafiles}).stream().filter(tuple -> tuple.get(0) != tuple.get(1)).map(tuple -> Pair.of(this.boundsOf((DataFile)tuple.get(0), field, javaClass), this.boundsOf((DataFile)tuple.get(1), field, javaClass))).collect(Collectors.toList());
            Comparator comparator = Comparators.forType((Type.PrimitiveType)field.type().asPrimitiveType());
            List overlappingFiles = boundComparisons.stream().filter(filePair -> {
                Pair left = (Pair)filePair.first();
                Object lMin = left.first();
                Object lMax = left.second();
                Pair right = (Pair)filePair.second();
                Object rMin = right.first();
                Object rMax = right.second();
                boolean boundsDoNotOverlap = comparator.compare(rMax, lMax) >= 0 && comparator.compare(rMin, lMax) >= 0 || comparator.compare(lMax, rMax) >= 0 && comparator.compare(lMin, rMax) >= 0;
                return !boundsDoNotOverlap;
            }).collect(Collectors.toList());
            return overlappingFiles.stream();
        });
        return overlaps.collect(Collectors.toList());
    }

    protected Table createTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        ImmutableMap options = ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion));
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        table.updateProperties().set("write.parquet.row-group-size-bytes", Integer.toString(20480)).commit();
        ((ObjectAssert)Assertions.assertThat((Object)table.currentSnapshot()).as("Table must be empty", new Object[0])).isNull();
        return table;
    }

    protected Table createTable(int files) {
        Table table = this.createTable();
        this.writeRecords(files, 400000);
        return table;
    }

    protected Table createTablePartitioned(int partitions, int files, int numRecords, Map<String, String> options) {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        Table table = TABLES.create(SCHEMA, spec, options, this.tableLocation);
        ((ObjectAssert)Assertions.assertThat((Object)table.currentSnapshot()).as("Table must be empty", new Object[0])).isNull();
        this.writeRecords(files, numRecords, partitions);
        return table;
    }

    protected Table createTablePartitioned(int partitions, int files) {
        return this.createTablePartitioned(partitions, files, 400000, (Map<String, String>)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)));
    }

    protected Table createTablePartitioned(int partitions, int files, int numRecords) {
        return this.createTablePartitioned(partitions, files, numRecords, (Map<String, String>)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)));
    }

    private Table createTypeTestTable() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.optional((int)4, (String)"doubleCol", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"dateCol", (Type)Types.DateType.get()), Types.NestedField.optional((int)6, (String)"timestampCol", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)7, (String)"stringCol", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"booleanCol", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"binaryCol", (Type)Types.BinaryType.get())});
        ImmutableMap options = ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion));
        Table table = TABLES.create(schema, PartitionSpec.unpartitioned(), (Map)options, this.tableLocation);
        spark.range(0L, 10L, 1L, 10).withColumnRenamed("id", "longCol").withColumn("intCol", functions.expr((String)"CAST(longCol AS INT)")).withColumn("floatCol", functions.expr((String)"CAST(longCol AS FLOAT)")).withColumn("doubleCol", functions.expr((String)"CAST(longCol AS DOUBLE)")).withColumn("dateCol", functions.date_add((Column)functions.current_date(), (int)1)).withColumn("timestampCol", functions.expr((String)"TO_TIMESTAMP(dateCol)")).withColumn("stringCol", functions.expr((String)"CAST(dateCol AS STRING)")).withColumn("booleanCol", functions.expr((String)"longCol > 5")).withColumn("binaryCol", functions.expr((String)"CAST(longCol AS BINARY)")).write().format("iceberg").mode("append").save(this.tableLocation);
        return table;
    }

    protected int averageFileSize(Table table) {
        table.refresh();
        return (int)Streams.stream((Iterable)table.newScan().planFiles()).mapToLong(ContentScanTask::length).average().getAsDouble();
    }

    private void writeRecords(List<ThreeColumnRecord> records) {
        Dataset df = spark.createDataFrame(records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeRecords(int files, int numRecords) {
        this.writeRecords(files, numRecords, 0);
    }

    private void writeRecords(int files, int numRecords, int partitions) {
        ArrayList records = Lists.newArrayList();
        int rowDimension = (int)Math.ceil(Math.sqrt(numRecords));
        List<Pair> data = IntStream.range(0, rowDimension).boxed().flatMap(x -> IntStream.range(0, rowDimension).boxed().map(y -> Pair.of((Object)x, (Object)y))).collect(Collectors.toList());
        Collections.shuffle(data, new Random(42L));
        if (partitions > 0) {
            data.forEach(i -> records.add(new ThreeColumnRecord((Integer)i.first() % partitions, "foo" + i.first(), "bar" + i.second())));
        } else {
            data.forEach(i -> records.add(new ThreeColumnRecord((Integer)i.first(), "foo" + i.first(), "bar" + i.second())));
        }
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).repartition(files);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeDF(Dataset<Row> df) {
        df.select("c1", new String[]{"c2", "c3"}).sortWithinPartitions("c1", new String[]{"c2"}).write().format("iceberg").mode("append").option("use-table-distribution-and-ordering", "false").save(this.tableLocation);
    }

    private List<DeleteFile> writePosDeletesToFile(Table table, DataFile dataFile, int outputDeleteFiles) {
        return this.writePosDeletes(table, dataFile.partition(), dataFile.location(), outputDeleteFiles);
    }

    private List<DeleteFile> writePosDeletes(Table table, StructLike partition, String path, int outputDeleteFiles) {
        ArrayList results = Lists.newArrayList();
        int rowPosition = 0;
        for (int file = 0; file < outputDeleteFiles; ++file) {
            OutputFile outputFile = table.io().newOutputFile(table.locationProvider().newDataLocation(FileFormat.PARQUET.addExtension(UUID.randomUUID().toString())));
            EncryptedOutputFile encryptedOutputFile = EncryptedFiles.encryptedOutput((OutputFile)outputFile, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
            GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), null, null, null);
            PositionDeleteWriter posDeleteWriter = appenderFactory.set("write.metadata.metrics.default", "full").newPosDeleteWriter(encryptedOutputFile, FileFormat.PARQUET, partition);
            PositionDelete posDelete = PositionDelete.create();
            posDeleteWriter.write(posDelete.set((CharSequence)path, (long)rowPosition, null));
            try {
                posDeleteWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            results.add(posDeleteWriter.toDeleteFile());
            ++rowPosition;
        }
        return results;
    }

    private List<DeleteFile> writePosDeletes(Table table, StructLike partition, String path, int outputDeleteFiles, int totalPositionsToDelete) {
        ArrayList results = Lists.newArrayList();
        for (int file = 0; file < outputDeleteFiles; ++file) {
            OutputFile outputFile = table.io().newOutputFile(table.locationProvider().newDataLocation(FileFormat.PARQUET.addExtension(UUID.randomUUID().toString())));
            EncryptedOutputFile encryptedOutputFile = EncryptedFiles.encryptedOutput((OutputFile)outputFile, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
            GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), null, null, null);
            PositionDeleteWriter posDeleteWriter = appenderFactory.set("write.metadata.metrics.default", "full").newPosDeleteWriter(encryptedOutputFile, FileFormat.PARQUET, partition);
            PositionDelete posDelete = PositionDelete.create();
            int positionsPerDeleteFile = totalPositionsToDelete / outputDeleteFiles;
            for (int position = file * positionsPerDeleteFile; position < (file + 1) * positionsPerDeleteFile; ++position) {
                posDeleteWriter.write(posDelete.set((CharSequence)path, (long)position, null));
            }
            try {
                posDeleteWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            results.add(posDeleteWriter.toDeleteFile());
        }
        return results;
    }

    private List<DeleteFile> writeDV(Table table, StructLike partition, String path, int numPositionsToDelete) throws IOException {
        BaseDVFileWriter writer;
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)1, (long)1L).format(FileFormat.PUFFIN).build();
        try (BaseDVFileWriter closeableWriter = writer = new BaseDVFileWriter(fileFactory, p -> null);){
            for (int row = 0; row < numPositionsToDelete; ++row) {
                closeableWriter.delete(path, (long)row, table.spec(), partition);
            }
        }
        return writer.result().deleteFiles();
    }

    private void writeEqDeleteRecord(Table table, String partCol, Object partVal, String delCol, Object delVal) {
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{table.schema().findField(delCol).fieldId()});
        Schema eqDeleteRowSchema = table.schema().select(new String[]{delCol});
        GenericRecord partitionRecord = GenericRecord.create((Schema)table.schema().select(new String[]{partCol})).copy((Map)ImmutableMap.of((Object)partCol, (Object)partVal));
        GenericRecord record = GenericRecord.create((Schema)eqDeleteRowSchema).copy((Map)ImmutableMap.of((Object)delCol, (Object)delVal));
        this.writeEqDeleteRecord(table, equalityFieldIds, (Record)partitionRecord, eqDeleteRowSchema, (Record)record);
    }

    private void writeEqDeleteRecord(Table table, List<Integer> equalityFieldIds, Record partitionRecord, Schema eqDeleteRowSchema, Record deleteRecord) {
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)1, (long)1L).format(FileFormat.PARQUET).build();
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(table.schema(), table.spec(), ArrayUtil.toIntArray(equalityFieldIds), eqDeleteRowSchema, null);
        EncryptedOutputFile file = this.createEncryptedOutputFile(this.createPartitionKey(table, partitionRecord), fileFactory);
        EqualityDeleteWriter eqDeleteWriter = appenderFactory.newEqDeleteWriter(file, FileFormat.PARQUET, (StructLike)this.createPartitionKey(table, partitionRecord));
        try (EqualityDeleteWriter clsEqDeleteWriter = eqDeleteWriter;){
            clsEqDeleteWriter.write((Object)deleteRecord);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        table.newRowDelta().addDeletes(eqDeleteWriter.toDeleteFile()).commit();
    }

    private PartitionKey createPartitionKey(Table table, Record record) {
        if (table.spec().isUnpartitioned()) {
            return null;
        }
        PartitionKey partitionKey = new PartitionKey(table.spec(), table.schema());
        partitionKey.partition((StructLike)record);
        return partitionKey;
    }

    private EncryptedOutputFile createEncryptedOutputFile(PartitionKey partition, OutputFileFactory fileFactory) {
        if (partition == null) {
            return fileFactory.newOutputFile();
        }
        return fileFactory.newOutputFile((StructLike)partition);
    }

    private SparkActions actions() {
        return SparkActions.get();
    }

    private Set<String> cacheContents(Table table) {
        return ImmutableSet.builder().addAll((Iterable)this.manager.fetchSetIds(table)).addAll((Iterable)this.coordinator.fetchSetIds(table)).build();
    }

    private double percentFilesRequired(Table table, String col, String value) {
        return this.percentFilesRequired(table, new String[]{col}, new String[]{value});
    }

    private double percentFilesRequired(Table table, String[] cols, String[] values) {
        Preconditions.checkArgument((cols.length == values.length ? 1 : 0) != 0);
        True restriction = Expressions.alwaysTrue();
        for (int i = 0; i < cols.length; ++i) {
            restriction = Expressions.and((Expression)restriction, (Expression)Expressions.equal((String)cols[i], (Object)values[i]));
        }
        int totalFiles = Iterables.size((Iterable)table.newScan().planFiles());
        int filteredFiles = Iterables.size((Iterable)((TableScan)table.newScan().filter((Expression)restriction)).planFiles());
        return (double)filteredFiles / (double)totalFiles;
    }

    class GroupInfoMatcher
    implements ArgumentMatcher<RewriteFileGroup> {
        private final Set<Integer> groupIDs;

        GroupInfoMatcher(Integer ... globalIndex) {
            this.groupIDs = ImmutableSet.copyOf((Object[])globalIndex);
        }

        public boolean matches(RewriteFileGroup argument) {
            return this.groupIDs.contains(argument.info().globalIndex());
        }
    }
}

