/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSnapshotTableAction
extends CatalogTestBase {
    private static final String SOURCE_NAME = "spark_catalog.default.source";

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s PURGE", SOURCE_NAME);
    }

    @TestTemplate
    public void testSnapshotWithParallelTasks() throws IOException {
        String location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", SOURCE_NAME, location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", SOURCE_NAME);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", SOURCE_NAME);
        AtomicInteger snapshotThreadsIndex = new AtomicInteger(0);
        SparkActions.get().snapshotTable(SOURCE_NAME).as(this.tableName).executeWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("table-snapshot-" + snapshotThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).execute();
        Assertions.assertThat((int)snapshotThreadsIndex.get()).isEqualTo(2);
    }
}

