/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.SizeBasedDataRewriter;
import org.apache.iceberg.actions.SizeBasedFileRewriter;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.actions.SparkBinPackDataRewriter;
import org.apache.iceberg.spark.actions.SparkSortDataRewriter;
import org.apache.iceberg.spark.actions.SparkZOrderDataRewriter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class TestSparkFileRewriter
extends TestBase {
    private static final TableIdentifier TABLE_IDENT = TableIdentifier.of((String[])new String[]{"default", "tbl"});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"dep", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("dep").build();
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).build();

    @AfterEach
    public void removeTable() {
        catalog.dropTable(TABLE_IDENT);
    }

    @Test
    public void testBinPackDataSelectFiles() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkBinPackDataRewriter rewriter = new SparkBinPackDataRewriter(spark, table);
        this.checkDataFileSizeFiltering((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesDeleteThreshold((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughFiles((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughData((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithTooMuchData((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesWithHighFileScopedDeleteRatio((SizeBasedDataRewriter)rewriter);
    }

    @Test
    public void testSortDataSelectFiles() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkSortDataRewriter rewriter = new SparkSortDataRewriter(spark, table, SORT_ORDER);
        this.checkDataFileSizeFiltering((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesDeleteThreshold((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughFiles((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughData((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithTooMuchData((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesWithHighFileScopedDeleteRatio((SizeBasedDataRewriter)rewriter);
    }

    @Test
    public void testZOrderDataSelectFiles() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        ImmutableList zOrderCols = ImmutableList.of((Object)"id");
        SparkZOrderDataRewriter rewriter = new SparkZOrderDataRewriter(spark, table, (List)zOrderCols);
        this.checkDataFileSizeFiltering((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesDeleteThreshold((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughFiles((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithEnoughData((SizeBasedDataRewriter)rewriter);
        this.checkDataFileGroupWithTooMuchData((SizeBasedDataRewriter)rewriter);
        this.checkDataFilesWithHighFileScopedDeleteRatio((SizeBasedDataRewriter)rewriter);
    }

    private void checkDataFileSizeFiltering(SizeBasedDataRewriter rewriter) {
        MockFileScanTask tooSmallTask = new MockFileScanTask(100L);
        MockFileScanTask optimal = new MockFileScanTask(450L);
        MockFileScanTask tooBigTask = new MockFileScanTask(1000L);
        ImmutableList tasks = ImmutableList.of((Object)tooSmallTask, (Object)optimal, (Object)tooBigTask);
        ImmutableMap options = ImmutableMap.of((Object)"min-file-size-bytes", (Object)"250", (Object)"target-file-size-bytes", (Object)"500", (Object)"max-file-size-bytes", (Object)"750", (Object)"delete-file-threshold", (Object)String.valueOf(Integer.MAX_VALUE));
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite 2 files", new Object[0])).hasSize(2);
    }

    private void checkDataFilesDeleteThreshold(SizeBasedDataRewriter rewriter) {
        MockFileScanTask tooManyDeletesTask = MockFileScanTask.mockTaskWithDeletes((long)1000L, (int)3);
        MockFileScanTask optimalTask = MockFileScanTask.mockTaskWithDeletes((long)1000L, (int)1);
        ImmutableList tasks = ImmutableList.of((Object)tooManyDeletesTask, (Object)optimalTask);
        ImmutableMap options = ImmutableMap.of((Object)"min-file-size-bytes", (Object)"1", (Object)"target-file-size-bytes", (Object)"2000", (Object)"max-file-size-bytes", (Object)"5000", (Object)"delete-file-threshold", (Object)"2");
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite 1 file", new Object[0])).hasSize(1);
    }

    private void checkDataFileGroupWithEnoughFiles(SizeBasedDataRewriter rewriter) {
        ImmutableList tasks = ImmutableList.of((Object)new MockFileScanTask(100L), (Object)new MockFileScanTask(100L), (Object)new MockFileScanTask(100L), (Object)new MockFileScanTask(100L));
        ImmutableMap options = ImmutableMap.of((Object)"min-input-files", (Object)"3", (Object)"min-file-size-bytes", (Object)"150", (Object)"target-file-size-bytes", (Object)"1000", (Object)"max-file-size-bytes", (Object)"5000", (Object)"delete-file-threshold", (Object)String.valueOf(Integer.MAX_VALUE));
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite 4 files", new Object[0])).hasSize(4);
    }

    private void checkDataFileGroupWithEnoughData(SizeBasedDataRewriter rewriter) {
        ImmutableList tasks = ImmutableList.of((Object)new MockFileScanTask(100L), (Object)new MockFileScanTask(100L), (Object)new MockFileScanTask(100L));
        ImmutableMap options = ImmutableMap.of((Object)"min-input-files", (Object)"5", (Object)"min-file-size-bytes", (Object)"200", (Object)"target-file-size-bytes", (Object)"250", (Object)"max-file-size-bytes", (Object)"500", (Object)"delete-file-threshold", (Object)String.valueOf(Integer.MAX_VALUE));
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite 3 files", new Object[0])).hasSize(3);
    }

    private void checkDataFileGroupWithTooMuchData(SizeBasedDataRewriter rewriter) {
        ImmutableList tasks = ImmutableList.of((Object)new MockFileScanTask(2000L));
        ImmutableMap options = ImmutableMap.of((Object)"min-input-files", (Object)"5", (Object)"min-file-size-bytes", (Object)"200", (Object)"target-file-size-bytes", (Object)"250", (Object)"max-file-size-bytes", (Object)"500", (Object)"delete-file-threshold", (Object)String.valueOf(Integer.MAX_VALUE));
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite big file", new Object[0])).hasSize(1);
    }

    private void checkDataFilesWithHighFileScopedDeleteRatio(SizeBasedDataRewriter rewriter) {
        MockFileScanTask tooManyDeletesTask = MockFileScanTask.mockTaskWithFileScopedDeleteRecords((long)1000L, (long)100L, (int)1, (long)30L);
        MockFileScanTask optimalTask = MockFileScanTask.mockTaskWithFileScopedDeleteRecords((long)1000L, (long)100L, (int)1, (long)29L);
        ImmutableList tasks = ImmutableList.of((Object)tooManyDeletesTask, (Object)optimalTask);
        ImmutableMap options = ImmutableMap.of((Object)"min-file-size-bytes", (Object)"0", (Object)"delete-file-threshold", (Object)"10");
        rewriter.init((Map)options);
        Iterable groups = rewriter.planFileGroups((Iterable)tasks);
        ((IterableAssert)Assertions.assertThat((Iterable)groups).as("Must have 1 group", new Object[0])).hasSize(1);
        List group = (List)Iterables.getOnlyElement((Iterable)groups);
        ((ListAssert)Assertions.assertThat((List)group).as("Must rewrite 1 file", new Object[0])).hasSize(1);
    }

    @Test
    public void testInvalidConstructorUsagesSortData() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        Assertions.assertThatThrownBy(() -> new SparkSortDataRewriter(spark, table)).hasMessageContaining("Cannot sort data without a valid sort order").hasMessageContaining("is unsorted and no sort order is provided");
        Assertions.assertThatThrownBy(() -> new SparkSortDataRewriter(spark, table, null)).hasMessageContaining("Cannot sort data without a valid sort order").hasMessageContaining("the provided sort order is null or empty");
        Assertions.assertThatThrownBy(() -> new SparkSortDataRewriter(spark, table, SortOrder.unsorted())).hasMessageContaining("Cannot sort data without a valid sort order").hasMessageContaining("the provided sort order is null or empty");
    }

    @Test
    public void testInvalidConstructorUsagesZOrderData() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA, SPEC);
        Assertions.assertThatThrownBy(() -> new SparkZOrderDataRewriter(spark, table, null)).hasMessageContaining("Cannot ZOrder when no columns are specified");
        Assertions.assertThatThrownBy(() -> new SparkZOrderDataRewriter(spark, table, (List)ImmutableList.of())).hasMessageContaining("Cannot ZOrder when no columns are specified");
        Assertions.assertThatThrownBy(() -> new SparkZOrderDataRewriter(spark, table, (List)ImmutableList.of((Object)"dep"))).hasMessageContaining("Cannot ZOrder").hasMessageContaining("all columns provided were identity partition columns");
        Assertions.assertThatThrownBy(() -> new SparkZOrderDataRewriter(spark, table, (List)ImmutableList.of((Object)"DeP"))).hasMessageContaining("Cannot ZOrder").hasMessageContaining("all columns provided were identity partition columns");
    }

    @Test
    public void testBinPackDataValidOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkBinPackDataRewriter rewriter = new SparkBinPackDataRewriter(spark, table);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)rewriter.validOptions()).as("Rewriter must report all supported options", new Object[0])).isEqualTo((Object)ImmutableSet.of((Object)"target-file-size-bytes", (Object)"min-file-size-bytes", (Object)"max-file-size-bytes", (Object)"min-input-files", (Object)"rewrite-all", (Object)"max-file-group-size-bytes", (Object[])new String[]{"delete-file-threshold", "delete-ratio-threshold"}));
    }

    @Test
    public void testSortDataValidOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkSortDataRewriter rewriter = new SparkSortDataRewriter(spark, table, SORT_ORDER);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)rewriter.validOptions()).as("Rewriter must report all supported options", new Object[0])).isEqualTo((Object)ImmutableSet.of((Object)"shuffle-partitions-per-file", (Object)"target-file-size-bytes", (Object)"min-file-size-bytes", (Object)"max-file-size-bytes", (Object)"min-input-files", (Object)"rewrite-all", (Object[])new String[]{"max-file-group-size-bytes", "delete-file-threshold", "delete-ratio-threshold", "compression-factor"}));
    }

    @Test
    public void testZOrderDataValidOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        ImmutableList zOrderCols = ImmutableList.of((Object)"id");
        SparkZOrderDataRewriter rewriter = new SparkZOrderDataRewriter(spark, table, (List)zOrderCols);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)rewriter.validOptions()).as("Rewriter must report all supported options", new Object[0])).isEqualTo((Object)ImmutableSet.of((Object)"shuffle-partitions-per-file", (Object)"target-file-size-bytes", (Object)"min-file-size-bytes", (Object)"max-file-size-bytes", (Object)"min-input-files", (Object)"rewrite-all", (Object[])new String[]{"max-file-group-size-bytes", "delete-file-threshold", "delete-ratio-threshold", "compression-factor", "max-output-size", "var-length-contribution"}));
    }

    @Test
    public void testInvalidValuesForBinPackDataOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkBinPackDataRewriter rewriter = new SparkBinPackDataRewriter(spark, table);
        this.validateSizeBasedRewriterOptions((SizeBasedFileRewriter<?, ?>)rewriter);
        ImmutableMap invalidDeleteThresholdOptions = ImmutableMap.of((Object)"delete-file-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForBinPackDataOptions$7(rewriter, (Map)invalidDeleteThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-file-threshold' is set to -1 but must be >= 0");
        ImmutableMap negativeDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForBinPackDataOptions$8(rewriter, (Map)negativeDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to -1.0 but must be > 0");
        ImmutableMap invalidDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"127");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForBinPackDataOptions$9(rewriter, (Map)invalidDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to 127.0 but must be <= 1");
    }

    @Test
    public void testInvalidValuesForSortDataOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        SparkSortDataRewriter rewriter = new SparkSortDataRewriter(spark, table, SORT_ORDER);
        this.validateSizeBasedRewriterOptions((SizeBasedFileRewriter<?, ?>)rewriter);
        ImmutableMap invalidDeleteThresholdOptions = ImmutableMap.of((Object)"delete-file-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForSortDataOptions$10(rewriter, (Map)invalidDeleteThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-file-threshold' is set to -1 but must be >= 0");
        ImmutableMap invalidCompressionFactorOptions = ImmutableMap.of((Object)"compression-factor", (Object)"0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForSortDataOptions$11(rewriter, (Map)invalidCompressionFactorOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'compression-factor' is set to 0.0 but must be > 0");
        ImmutableMap negativeDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForSortDataOptions$12(rewriter, (Map)negativeDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to -1.0 but must be > 0");
        ImmutableMap invalidDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"127");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForSortDataOptions$13(rewriter, (Map)invalidDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to 127.0 but must be <= 1");
    }

    @Test
    public void testInvalidValuesForZOrderDataOptions() {
        Table table = catalog.createTable(TABLE_IDENT, SCHEMA);
        ImmutableList zOrderCols = ImmutableList.of((Object)"id");
        SparkZOrderDataRewriter rewriter = new SparkZOrderDataRewriter(spark, table, (List)zOrderCols);
        this.validateSizeBasedRewriterOptions((SizeBasedFileRewriter<?, ?>)rewriter);
        ImmutableMap invalidDeleteThresholdOptions = ImmutableMap.of((Object)"delete-file-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$14(rewriter, (Map)invalidDeleteThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-file-threshold' is set to -1 but must be >= 0");
        ImmutableMap invalidCompressionFactorOptions = ImmutableMap.of((Object)"compression-factor", (Object)"0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$15(rewriter, (Map)invalidCompressionFactorOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'compression-factor' is set to 0.0 but must be > 0");
        ImmutableMap invalidMaxOutputOptions = ImmutableMap.of((Object)"max-output-size", (Object)"0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$16(rewriter, (Map)invalidMaxOutputOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot have the interleaved ZOrder value use less than 1 byte").hasMessageContaining("'max-output-size' was set to 0");
        ImmutableMap invalidVarLengthContributionOptions = ImmutableMap.of((Object)"var-length-contribution", (Object)"0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$17(rewriter, (Map)invalidVarLengthContributionOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot use less than 1 byte for variable length types with ZOrder").hasMessageContaining("'var-length-contribution' was set to 0");
        ImmutableMap negativeDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$18(rewriter, (Map)negativeDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to -1.0 but must be > 0");
        ImmutableMap invalidDeleteRatioThresholdOptions = ImmutableMap.of((Object)"delete-ratio-threshold", (Object)"127");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$testInvalidValuesForZOrderDataOptions$19(rewriter, (Map)invalidDeleteRatioThresholdOptions)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("'delete-ratio-threshold' is set to 127.0 but must be <= 1");
    }

    private void validateSizeBasedRewriterOptions(SizeBasedFileRewriter<?, ?> rewriter) {
        ImmutableMap invalidTargetSizeOptions = ImmutableMap.of((Object)"target-file-size-bytes", (Object)"0");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$20(rewriter, (Map)invalidTargetSizeOptions)).hasMessageContaining("'target-file-size-bytes' is set to 0 but must be > 0");
        ImmutableMap invalidMinSizeOptions = ImmutableMap.of((Object)"min-file-size-bytes", (Object)"-1");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$21(rewriter, (Map)invalidMinSizeOptions)).hasMessageContaining("'min-file-size-bytes' is set to -1 but must be >= 0");
        ImmutableMap invalidTargetMinSizeOptions = ImmutableMap.of((Object)"target-file-size-bytes", (Object)"3", (Object)"min-file-size-bytes", (Object)"5");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$22(rewriter, (Map)invalidTargetMinSizeOptions)).hasMessageContaining("'target-file-size-bytes' (3) must be > 'min-file-size-bytes' (5)").hasMessageContaining("all new files will be smaller than the min threshold");
        ImmutableMap invalidTargetMaxSizeOptions = ImmutableMap.of((Object)"target-file-size-bytes", (Object)"5", (Object)"max-file-size-bytes", (Object)"3");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$23(rewriter, (Map)invalidTargetMaxSizeOptions)).hasMessageContaining("'target-file-size-bytes' (5) must be < 'max-file-size-bytes' (3)").hasMessageContaining("all new files will be larger than the max threshold");
        ImmutableMap invalidMinInputFilesOptions = ImmutableMap.of((Object)"min-input-files", (Object)"0");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$24(rewriter, (Map)invalidMinInputFilesOptions)).hasMessageContaining("'min-input-files' is set to 0 but must be > 0");
        ImmutableMap invalidMaxFileGroupSizeOptions = ImmutableMap.of((Object)"max-file-group-size-bytes", (Object)"0");
        Assertions.assertThatThrownBy(() -> TestSparkFileRewriter.lambda$validateSizeBasedRewriterOptions$25(rewriter, (Map)invalidMaxFileGroupSizeOptions)).hasMessageContaining("'max-file-group-size-bytes' is set to 0 but must be > 0");
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$25(SizeBasedFileRewriter rewriter, Map invalidMaxFileGroupSizeOptions) throws Throwable {
        rewriter.init(invalidMaxFileGroupSizeOptions);
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$24(SizeBasedFileRewriter rewriter, Map invalidMinInputFilesOptions) throws Throwable {
        rewriter.init(invalidMinInputFilesOptions);
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$23(SizeBasedFileRewriter rewriter, Map invalidTargetMaxSizeOptions) throws Throwable {
        rewriter.init(invalidTargetMaxSizeOptions);
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$22(SizeBasedFileRewriter rewriter, Map invalidTargetMinSizeOptions) throws Throwable {
        rewriter.init(invalidTargetMinSizeOptions);
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$21(SizeBasedFileRewriter rewriter, Map invalidMinSizeOptions) throws Throwable {
        rewriter.init(invalidMinSizeOptions);
    }

    private static /* synthetic */ void lambda$validateSizeBasedRewriterOptions$20(SizeBasedFileRewriter rewriter, Map invalidTargetSizeOptions) throws Throwable {
        rewriter.init(invalidTargetSizeOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$19(SparkZOrderDataRewriter rewriter, Map invalidDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$18(SparkZOrderDataRewriter rewriter, Map negativeDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(negativeDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$17(SparkZOrderDataRewriter rewriter, Map invalidVarLengthContributionOptions) throws Throwable {
        rewriter.init(invalidVarLengthContributionOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$16(SparkZOrderDataRewriter rewriter, Map invalidMaxOutputOptions) throws Throwable {
        rewriter.init(invalidMaxOutputOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$15(SparkZOrderDataRewriter rewriter, Map invalidCompressionFactorOptions) throws Throwable {
        rewriter.init(invalidCompressionFactorOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForZOrderDataOptions$14(SparkZOrderDataRewriter rewriter, Map invalidDeleteThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForSortDataOptions$13(SparkSortDataRewriter rewriter, Map invalidDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForSortDataOptions$12(SparkSortDataRewriter rewriter, Map negativeDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(negativeDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForSortDataOptions$11(SparkSortDataRewriter rewriter, Map invalidCompressionFactorOptions) throws Throwable {
        rewriter.init(invalidCompressionFactorOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForSortDataOptions$10(SparkSortDataRewriter rewriter, Map invalidDeleteThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForBinPackDataOptions$9(SparkBinPackDataRewriter rewriter, Map invalidDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForBinPackDataOptions$8(SparkBinPackDataRewriter rewriter, Map negativeDeleteRatioThresholdOptions) throws Throwable {
        rewriter.init(negativeDeleteRatioThresholdOptions);
    }

    private static /* synthetic */ void lambda$testInvalidValuesForBinPackDataOptions$7(SparkBinPackDataRewriter rewriter, Map invalidDeleteThresholdOptions) throws Throwable {
        rewriter.init(invalidDeleteThresholdOptions);
    }
}

