/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestOrcWrite {
    @TempDir
    private Path temp;
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});

    @Test
    public void splitOffsets() throws IOException {
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<InternalRow> rows = RandomData.generateSpark(SCHEMA, 1, 0L);
        FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)testFile)).createWriterFunc(SparkOrcWriter::new).schema(SCHEMA).build();
        writer.addAll(rows);
        writer.close();
        ((ListAssert)Assertions.assertThat((List)writer.splitOffsets()).as("Split offsets not present", new Object[0])).isNotNull();
    }
}

