/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetAvroValueReaders;
import org.apache.iceberg.parquet.ParquetAvroWriter;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestParquetAvroWriter {
    @TempDir
    private Path temp;
    private static final Schema COMPLEX_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"roots", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"lime", (Type)Types.ListType.ofRequired((int)4, (Type)Types.DoubleType.get())), Types.NestedField.required((int)5, (String)"strict", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"tangerine", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"hopeful", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)7, (String)"steel", (Type)Types.FloatType.get()), Types.NestedField.required((int)8, (String)"lantern", (Type)Types.DateType.get())})), Types.NestedField.optional((int)10, (String)"vehement", (Type)Types.LongType.get())})), Types.NestedField.optional((int)11, (String)"metamorphosis", (Type)Types.MapType.ofRequired((int)12, (int)13, (Type)Types.StringType.get(), (Type)Types.TimestampType.withoutZone())), Types.NestedField.required((int)14, (String)"winter", (Type)Types.ListType.ofOptional((int)15, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)16, (String)"beet", (Type)Types.DoubleType.get()), Types.NestedField.required((int)17, (String)"stamp", (Type)Types.TimeType.get()), Types.NestedField.optional((int)18, (String)"wheeze", (Type)Types.StringType.get())}))), Types.NestedField.optional((int)19, (String)"renovate", (Type)Types.MapType.ofRequired((int)20, (int)21, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"jumpy", (Type)Types.DoubleType.get()), Types.NestedField.required((int)23, (String)"koala", (Type)Types.TimeType.get()), Types.NestedField.required((int)24, (String)"couch rope", (Type)Types.IntegerType.get())}))), Types.NestedField.optional((int)2, (String)"slide", (Type)Types.StringType.get())});

    @Test
    public void testCorrectness() throws IOException {
        Iterable<GenericData.Record> records = RandomData.generate(COMPLEX_SCHEMA, 50000, 34139L);
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(COMPLEX_SCHEMA).createWriterFunc(ParquetAvroWriter::buildWriter).build();){
            writer.addAll(records);
        }
        MessageType readSchema = ParquetSchemaUtil.convert((Schema)COMPLEX_SCHEMA, (String)"test");
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(COMPLEX_SCHEMA).createReaderFunc(fileSchema -> ParquetAvroValueReaders.buildReader((Schema)COMPLEX_SCHEMA, (MessageType)readSchema)).build();){
            int recordNum = 0;
            Iterator<GenericData.Record> iter = records.iterator();
            for (GenericData.Record actual : reader) {
                GenericData.Record expected = iter.next();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual).as("Record " + recordNum + " should match expected", new Object[0])).isEqualTo((Object)expected);
                ++recordNum;
            }
        }
    }
}

