/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSparkDateTimes {
    @Test
    public void testSparkDate() {
        this.checkSparkDate("1582-10-15");
        this.checkSparkDate("1601-08-12");
        this.checkSparkDate("1801-07-04");
        this.checkSparkDate("1901-08-12");
        this.checkSparkDate("1969-12-31");
        this.checkSparkDate("1970-01-01");
        this.checkSparkDate("2017-12-25");
        this.checkSparkDate("2043-08-11");
        this.checkSparkDate("2111-05-03");
        this.checkSparkDate("2224-02-29");
        this.checkSparkDate("3224-10-05");
    }

    public void checkSparkDate(String dateString) {
        Literal date = Literal.of((CharSequence)dateString).to((Type)Types.DateType.get());
        String sparkDate = DateTimeUtils.toJavaDate((int)((Integer)date.value())).toString();
        ((AbstractStringAssert)Assertions.assertThat((String)sparkDate).as("Should be the same date (" + date.value() + ")", new Object[0])).isEqualTo(dateString);
    }

    @Test
    public void testSparkTimestamp() {
        TimeZone currentTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            this.checkSparkTimestamp("1582-10-15T15:51:08.440219+00:00", "1582-10-15 15:51:08.440219");
            this.checkSparkTimestamp("1970-01-01T00:00:00.000000+00:00", "1970-01-01 00:00:00");
            this.checkSparkTimestamp("2043-08-11T12:30:01.000001+00:00", "2043-08-11 12:30:01.000001");
        }
        finally {
            TimeZone.setDefault(currentTz);
        }
    }

    public void checkSparkTimestamp(String timestampString, String sparkRepr) {
        Literal ts = Literal.of((CharSequence)timestampString).to((Type)Types.TimestampType.withZone());
        ZoneId zoneId = DateTimeUtils.getZoneId((String)"UTC");
        TimestampFormatter formatter = TimestampFormatter.getFractionFormatter((ZoneId)zoneId);
        String sparkTimestamp = formatter.format(((Long)ts.value()).longValue());
        ((AbstractStringAssert)Assertions.assertThat((String)sparkTimestamp).as("Should be the same timestamp (" + ts.value() + ")", new Object[0])).isEqualTo(sparkRepr);
    }
}

