/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.GenericsHelpers;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkParquetReaders;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSparkParquetReader
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(schema, schema);
    }

    @Override
    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        ((ObjectAssert)Assumptions.assumeThat((Object)TypeUtil.find((Schema)writeSchema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get())).as("Parquet Avro cannot write non-string map keys", new Object[0])).isNull();
        List<GenericData.Record> expected = RandomData.generateList(writeSchema, 100, 0L);
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        try (FileAppender writer = Parquet.write((org.apache.iceberg.io.OutputFile)Files.localOutput((File)testFile)).schema(writeSchema).named("test").build();){
            writer.addAll(expected);
        }
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(expectedSchema).createReaderFunc(type -> SparkParquetReaders.buildReader((Schema)expectedSchema, (MessageType)type)).build();){
            CloseableIterator rows = reader.iterator();
            for (GenericData.Record record : expected) {
                ((IteratorAssert)Assertions.assertThat((Iterator)rows).as("Should have expected number of rows", new Object[0])).hasNext();
                TestHelpers.assertEqualsUnsafe(expectedSchema.asStruct(), record, (InternalRow)rows.next());
            }
            ((IteratorAssert)Assertions.assertThat((Iterator)rows).as("Should not have extra rows", new Object[0])).isExhausted();
        }
    }

    @Override
    protected boolean supportsDefaultValues() {
        return true;
    }

    protected List<InternalRow> rowsFromFile(InputFile inputFile, Schema schema) throws IOException {
        try (CloseableIterable reader = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(type -> SparkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            ArrayList arrayList = Lists.newArrayList((Iterable)reader);
            return arrayList;
        }
    }

    protected Table tableFromInputFile(InputFile inputFile, Schema schema) throws IOException {
        HadoopTables tables = new HadoopTables();
        Table table = tables.create(schema, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of(), java.nio.file.Files.createTempDirectory(this.temp, null, new FileAttribute[0]).toFile().getCanonicalPath());
        table.newAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFormat(FileFormat.PARQUET).withInputFile(inputFile).withMetrics(ParquetUtil.fileMetrics((InputFile)inputFile, (MetricsConfig)MetricsConfig.getDefault())).withFileSizeInBytes(inputFile.getLength()).build()).commit();
        return table;
    }

    @Test
    public void testInt96TimestampProducedBySparkIsReadCorrectly() throws IOException {
        String outputFilePath = String.format("%s/%s", this.temp.toAbsolutePath(), "parquet_int96.parquet");
        HadoopOutputFile outputFile = HadoopOutputFile.fromPath((Path)new Path(outputFilePath), (Configuration)new Configuration());
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"ts", (Type)Types.TimestampType.withZone())});
        StructType sparkSchema = new StructType(new StructField[]{new StructField("ts", DataTypes.TimestampType, true, Metadata.empty())});
        ArrayList rows = Lists.newArrayList(RandomData.generateSpark(schema, 10, 0L));
        try (ParquetWriter writer = new NativeSparkWriterBuilder((OutputFile)outputFile).set("org.apache.spark.sql.parquet.row.attributes", sparkSchema.json()).set("spark.sql.parquet.writeLegacyFormat", "false").set("spark.sql.parquet.outputTimestampType", "INT96").set("spark.sql.parquet.fieldId.write.enabled", "true").build();){
            for (InternalRow row : rows) {
                writer.write((Object)row);
            }
        }
        InputFile parquetInputFile = Files.localInput((String)outputFilePath);
        List<InternalRow> readRows = this.rowsFromFile(parquetInputFile, schema);
        Assertions.assertThat(readRows).hasSameSizeAs((Iterable)rows);
        Assertions.assertThat(readRows).isEqualTo((Object)rows);
        Table int96Table = this.tableFromInputFile(parquetInputFile, schema);
        ArrayList tableRecords = Lists.newArrayList((Iterable)IcebergGenerics.read((Table)int96Table).build());
        Assertions.assertThat((List)tableRecords).hasSameSizeAs((Iterable)rows);
        for (int i = 0; i < tableRecords.size(); ++i) {
            GenericsHelpers.assertEqualsUnsafe(schema.asStruct(), (Record)tableRecords.get(i), (InternalRow)rows.get(i));
        }
    }

    @Override
    @Test
    public void testMissingRequiredWithoutDefault() {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"missing_str").withId(6).ofType((Type)Types.StringType.get()).withDoc("Missing required field with no default").build()});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.writeAndValidate(writeSchema, expectedSchema)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Missing required field: missing_str");
    }

    private static class NativeSparkWriterBuilder
    extends ParquetWriter.Builder<InternalRow, NativeSparkWriterBuilder> {
        private final Map<String, String> config = Maps.newHashMap();

        NativeSparkWriterBuilder(OutputFile path) {
            super(path);
        }

        public NativeSparkWriterBuilder set(String property, String value) {
            this.config.put(property, value);
            return this.self();
        }

        protected NativeSparkWriterBuilder self() {
            return this;
        }

        protected WriteSupport<InternalRow> getWriteSupport(Configuration configuration) {
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            return new ParquetWriteSupport();
        }
    }
}

