/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkOrcReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestVectorizedOrcDataReader
implements WithAssertions {
    @TempDir
    public static Path temp;
    private static final Schema SCHEMA;
    private static OutputFile outputFile;

    @BeforeAll
    public static void createDataFile() throws IOException {
        GenericRecord bufferRecord = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)bufferRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"a", (Object)"array", Collections.singletonList(1))));
        builder.add((Object)bufferRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"b", (Object)"array", Arrays.asList(2, 3))));
        builder.add((Object)bufferRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)3L, (Object)"data", (Object)"c", (Object)"array", Arrays.asList(3, 4, 5))));
        builder.add((Object)bufferRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"d", (Object)"array", Arrays.asList(4, 5, 6, 7))));
        builder.add((Object)bufferRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"e", (Object)"array", Arrays.asList(5, 6, 7, 8, 9))));
        outputFile = Files.localOutput((File)File.createTempFile("test", ".orc", temp.toFile()));
        try (DataWriter dataWriter = ORC.writeData((OutputFile)outputFile).schema(SCHEMA).createWriterFunc(GenericOrcWriter::buildWriter).overwrite().withSpec(PartitionSpec.unpartitioned()).build();){
            for (Record record : builder.build()) {
                dataWriter.write((Object)record);
            }
        }
    }

    private Iterator<InternalRow> batchesToRows(Iterator<ColumnarBatch> batches) {
        return Iterators.concat((Iterator)Iterators.transform(batches, ColumnarBatch::rowIterator));
    }

    private void validateAllRows(Iterator<InternalRow> rows) {
        long rowCount = 0L;
        long expId = 1L;
        char expChar = 'a';
        while (rows.hasNext()) {
            InternalRow row = rows.next();
            this.assertThat(row.getLong(0)).isEqualTo(expId);
            this.assertThat(row.getString(1)).isEqualTo(Character.toString(expChar));
            this.assertThat(row.isNullAt(2)).isTrue();
            ++expId;
            expChar = (char)(expChar + '\u0001');
            ++rowCount;
        }
        this.assertThat(rowCount).isEqualTo(5L);
    }

    @Test
    public void testReader() throws IOException {
        try (CloseableIterable reader = ORC.read((InputFile)outputFile.toInputFile()).project(SCHEMA).createBatchedReaderFunc(readOrcSchema -> VectorizedSparkOrcReaders.buildReader((Schema)SCHEMA, (TypeDescription)readOrcSchema, (Map)ImmutableMap.of())).build();){
            this.validateAllRows(this.batchesToRows((Iterator<ColumnarBatch>)reader.iterator()));
        }
    }

    @Test
    public void testReaderWithFilter() throws IOException {
        try (CloseableIterable reader = ORC.read((InputFile)outputFile.toInputFile()).project(SCHEMA).createBatchedReaderFunc(readOrcSchema -> VectorizedSparkOrcReaders.buildReader((Schema)SCHEMA, (TypeDescription)readOrcSchema, (Map)ImmutableMap.of())).filter((Expression)Expressions.equal((String)"id", (Object)3L)).config(OrcConf.ALLOW_SARG_TO_FILTER.getAttribute(), String.valueOf(true)).build();){
            this.validateAllRows(this.batchesToRows((Iterator<ColumnarBatch>)reader.iterator()));
        }
    }

    @Test
    public void testWithFilterWithSelected() throws IOException {
        try (CloseableIterable reader = ORC.read((InputFile)outputFile.toInputFile()).project(SCHEMA).createBatchedReaderFunc(readOrcSchema -> VectorizedSparkOrcReaders.buildReader((Schema)SCHEMA, (TypeDescription)readOrcSchema, (Map)ImmutableMap.of())).filter((Expression)Expressions.equal((String)"id", (Object)3L)).config(OrcConf.ALLOW_SARG_TO_FILTER.getAttribute(), String.valueOf(true)).config(OrcConf.READER_USE_SELECTED.getAttribute(), String.valueOf(true)).build();){
            Iterator<InternalRow> rows = this.batchesToRows((Iterator<ColumnarBatch>)reader.iterator());
            this.assertThat(rows).hasNext();
            InternalRow row = rows.next();
            this.assertThat(row.getLong(0)).isEqualTo(3L);
            this.assertThat(row.getString(1)).isEqualTo("c");
            this.assertThat(row.getArray(3).toIntArray()).isEqualTo((Object)new int[]{3, 4, 5});
            this.assertThat(rows).isExhausted();
        }
    }

    static {
        SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"binary", (Type)Types.BinaryType.get()), Types.NestedField.required((int)4, (String)"array", (Type)Types.ListType.ofOptional((int)5, (Type)Types.IntegerType.get()))});
    }
}

