/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.parquet.vectorized;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.data.parquet.vectorized.TestParquetVectorizedReads;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkParquetReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestParquetDictionaryEncodedVectorizedReads
extends TestParquetVectorizedReads {
    protected static SparkSession spark = null;

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterAll
    public static void stopSpark() {
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    @Override
    Iterable<GenericData.Record> generateData(Schema schema, int numRecords, long seed, float nullPercentage, Function<GenericData.Record, GenericData.Record> transform) {
        Iterable data = RandomData.generateDictionaryEncodableData(schema, numRecords, seed, nullPercentage);
        return transform == IDENTITY ? data : Iterables.transform(data, transform);
    }

    @Override
    @Test
    @Disabled
    public void testVectorizedReadsWithNewContainers() throws IOException {
    }

    @Test
    public void testMixedDictionaryNonDictionaryReads() throws IOException {
        Schema schema = new Schema(SUPPORTED_PRIMITIVES.fields());
        File dictionaryEncodedFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dictionaryEncodedFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<GenericData.Record> dictionaryEncodableData = RandomData.generateDictionaryEncodableData(schema, 10000, 0L, 0.05f);
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(schema, dictionaryEncodedFile);){
            writer.addAll(dictionaryEncodableData);
        }
        File plainEncodingFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)plainEncodingFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<GenericData.Record> nonDictionaryData = RandomData.generate(schema, 10000, 0L, 0.05f);
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(schema, plainEncodingFile);){
            writer.addAll(nonDictionaryData);
        }
        int rowGroupSize = 0x8000000;
        File mixedFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mixedFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Parquet.concat((Iterable)ImmutableList.of((Object)dictionaryEncodedFile, (Object)plainEncodingFile, (Object)dictionaryEncodedFile), (File)mixedFile, (int)rowGroupSize, (Schema)schema, (Map)ImmutableMap.of());
        this.assertRecordsMatch(schema, 30000, (Iterable<GenericData.Record>)FluentIterable.concat(dictionaryEncodableData, nonDictionaryData, dictionaryEncodableData), mixedFile, true, 10000);
    }

    @Test
    public void testBinaryNotAllPagesDictionaryEncoded() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"bytes", (Type)Types.BinaryType.get())});
        File parquetFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parquetFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<GenericData.Record> records = RandomData.generateFallbackData(schema, 500, 0L, 100L);
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(schema).set("write.parquet.dict-size-bytes", "4096").set("write.parquet.page-row-limit", "100").build();){
            writer.addAll(records);
        }
        this.assertRecordsMatch(schema, 500, records, parquetFile, true, 10000);
    }

    @Test
    public void testDecimalNotAllPagesDictionaryEncoded() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.DecimalType.of((int)38, (int)0))});
        Path path = Paths.get(this.getClass().getClassLoader().getResource("decimal_dict_and_plain_encoding.parquet").toURI());
        Dataset df = spark.read().parquet(path.toString());
        List expected = df.collectAsList();
        long expectedSize = df.count();
        Parquet.ReadBuilder readBuilder = Parquet.read((InputFile)Files.localInput((File)path.toFile())).project(schema).createBatchedReaderFunc(type -> VectorizedSparkParquetReaders.buildReader((Schema)schema, (MessageType)type, (Map)ImmutableMap.of(), null));
        try (CloseableIterable batchReader = readBuilder.build();){
            Iterator<Row> expectedIter = expected.iterator();
            CloseableIterator batches = batchReader.iterator();
            int numRowsRead = 0;
            while (batches.hasNext()) {
                ColumnarBatch batch = (ColumnarBatch)batches.next();
                numRowsRead += batch.numRows();
                TestHelpers.assertEqualsBatchWithRows(schema.asStruct(), expectedIter, batch);
            }
            Assertions.assertThat((int)numRowsRead).isEqualTo(expectedSize);
        }
    }
}

