/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkPlannedAvroReader;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.source.ScanTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class DataFrameWriteTestBase
extends ScanTestBase {
    @TempDir
    private Path temp;

    @Override
    protected boolean supportsDefaultValues() {
        return false;
    }

    @Override
    protected void writeRecords(Table table, List<GenericData.Record> records) throws IOException {
        Schema tableSchema = table.schema();
        Dataset<Row> df = this.createDataset(records, tableSchema);
        DataFrameWriter writer = df.write().format("iceberg").mode("append");
        writer.save(table.location());
        table.refresh();
    }

    private Dataset<Row> createDataset(List<GenericData.Record> records, Schema schema) throws IOException {
        ArrayList rows;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").build();){
            for (GenericData.Record record : records) {
                writer.add((Object)record);
            }
        }
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).createResolvingReader(SparkPlannedAvroReader::create).project(schema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        Assertions.assertThat((int)rows.size()).isEqualTo(records.size());
        Iterator<GenericData.Record> recordIter = records.iterator();
        for (InternalRow row : rows) {
            TestHelpers.assertEqualsUnsafe(schema.asStruct(), recordIter.next(), row);
        }
        JavaRDD javaRDD = sc.parallelize((List)rows);
        return spark.internalCreateDataFrame(JavaRDD.toRDD((JavaRDD)javaRDD), SparkSchemaUtil.convert((Schema)schema), false);
    }

    @Test
    public void testAlternateLocation() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        File location = this.temp.resolve("table_location").toFile();
        File altLocation = this.temp.resolve("alt_location").toFile();
        HadoopTables tables = new HadoopTables(spark.sessionState().newHadoopConf());
        Table table = tables.create(schema, PartitionSpec.unpartitioned(), location.toString());
        table.updateProperties().set("write.data.path", altLocation.getAbsolutePath()).commit();
        this.writeRecords(table, RandomData.generateList(table.schema(), 100, 87112L));
        table.currentSnapshot().addedDataFiles(table.io()).forEach(dataFile -> ((AbstractStringAssert)Assertions.assertThat((String)dataFile.location()).as(String.format("File should have the parent directory %s, but has: %s.", altLocation, dataFile.location()), new Object[0])).startsWith((CharSequence)(altLocation + "/")));
    }
}

