/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class ManualSource
implements TableProvider,
DataSourceRegister {
    public static final String SHORT_NAME = "manual_source";
    public static final String TABLE_NAME = "TABLE_NAME";
    private static final Map<String, Table> TABLE_MAP = Maps.newHashMap();

    public static void setTable(String name, Table table) {
        Preconditions.checkArgument((!TABLE_MAP.containsKey(name) ? 1 : 0) != 0, (Object)("Cannot set " + name + ". It is already set"));
        TABLE_MAP.put(name, table);
    }

    public static void clearTables() {
        TABLE_MAP.clear();
    }

    public String shortName() {
        return SHORT_NAME;
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return this.getTable(null, null, (Map<String, String>)options).schema();
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap options) {
        return this.getTable(null, null, (Map<String, String>)options).partitioning();
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        Preconditions.checkArgument((boolean)properties.containsKey(TABLE_NAME), (Object)"Missing property TABLE_NAME");
        String tableName = properties.get(TABLE_NAME);
        Preconditions.checkArgument((boolean)TABLE_MAP.containsKey(tableName), (Object)("Table missing " + tableName));
        return TABLE_MAP.get(tableName);
    }

    public boolean supportsExternalMetadata() {
        return false;
    }
}

