/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;

public abstract class ScanTestBase
extends AvroDataTest {
    private static final Configuration CONF = new Configuration();
    protected static SparkSession spark = null;
    protected static JavaSparkContext sc = null;
    @TempDir
    private Path temp;

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    @AfterAll
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        sc = null;
        currentSpark.stop();
    }

    protected void configureTable(Table table) {
    }

    protected abstract void writeRecords(Table var1, List<GenericData.Record> var2) throws IOException;

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(schema, schema);
    }

    @Override
    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        File parent = this.temp.resolve("scan_test").toFile();
        File location = new File(parent, "test");
        HadoopTables tables = new HadoopTables(CONF);
        Table table = tables.create(writeSchema, PartitionSpec.unpartitioned(), location.toString());
        List<GenericData.Record> expected = RandomData.generateList(table.schema(), 100, 1L);
        this.writeRecords(table, expected);
        if (!expectedSchema.sameSchema(table.schema())) {
            Schema expectedSchemaWithTableIds = TypeUtil.reassignOrRefreshIds((Schema)expectedSchema, (Schema)table.schema());
            int highestFieldId = Math.max(table.schema().highestFieldId(), expectedSchema.highestFieldId());
            TableOperations ops = ((BaseTable)table).operations();
            TableMetadata builder = TableMetadata.buildFrom((TableMetadata)ops.current()).upgradeFormatVersion(3).setCurrentSchema(expectedSchemaWithTableIds, highestFieldId).build();
            ops.commit(ops.current(), builder);
        }
        Dataset df = spark.read().format("iceberg").load(table.location());
        List rows = df.collectAsList();
        ((ListAssert)Assertions.assertThat((List)rows).as("Should contain 100 rows", new Object[0])).hasSize(100);
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsSafe(table.schema().asStruct(), expected.get(i), (Row)rows.get(i));
        }
    }

    @Override
    protected boolean supportsDefaultValues() {
        return true;
    }
}

