/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.spark.source.ScanTestBase;

public class TestAvroScan
extends ScanTestBase {
    @Override
    protected void writeRecords(Table table, List<GenericData.Record> records) throws IOException {
        File dataFolder = new File(table.location(), "data");
        dataFolder.mkdirs();
        File avroFile = new File(dataFolder, FileFormat.AVRO.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)avroFile)).schema(table.schema()).build();){
            writer.addAll(records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(avroFile.length()).withRecordCount((long)records.size()).withPath(avroFile.toString()).build();
        table.newAppend().appendFile(file).commit();
    }
}

