/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.source.ChangelogRowReader;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestChangelogReader
extends TestBase {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    private final List<Record> records1 = Lists.newArrayList();
    private final List<Record> records2 = Lists.newArrayList();
    private Table table;
    private DataFile dataFile1;
    private DataFile dataFile2;
    @TempDir
    private Path temp;

    @BeforeEach
    public void before() throws IOException {
        this.table = catalog.createTable(TableIdentifier.of((String[])new String[]{"default", "test"}), SCHEMA, SPEC);
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records1.add(record.copy("id", (Object)29, "data", (Object)"a"));
        this.records1.add(record.copy("id", (Object)43, "data", (Object)"b"));
        this.records1.add(record.copy("id", (Object)61, "data", (Object)"c"));
        this.records1.add(record.copy("id", (Object)89, "data", (Object)"d"));
        this.records2.add(record.copy("id", (Object)100, "data", (Object)"e"));
        this.records2.add(record.copy("id", (Object)121, "data", (Object)"f"));
        this.records2.add(record.copy("id", (Object)122, "data", (Object)"g"));
        this.dataFile1 = this.writeDataFile(this.records1);
        this.dataFile2 = this.writeDataFile(this.records2);
    }

    @AfterEach
    public void after() {
        catalog.dropTable(TableIdentifier.of((String[])new String[]{"default", "test"}));
    }

    @Test
    public void testInsert() throws IOException {
        this.table.newAppend().appendFile(this.dataFile1).commit();
        long snapshotId1 = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(this.dataFile2).commit();
        long snapshotId2 = this.table.currentSnapshot().snapshotId();
        CloseableIterable taskGroups = this.newScan().planTasks();
        ArrayList rows = Lists.newArrayList();
        for (ScanTaskGroup taskGroup : taskGroups) {
            ChangelogRowReader reader = new ChangelogRowReader(this.table, taskGroup, this.table.schema(), this.table.schema(), false);
            while (reader.next()) {
                rows.add(((InternalRow)reader.get()).copy());
            }
            reader.close();
        }
        rows.sort((r1, r2) -> r1.getInt(0) - r2.getInt(0));
        ArrayList expectedRows = Lists.newArrayList();
        this.addExpectedRows(expectedRows, ChangelogOperation.INSERT, snapshotId1, 0, this.records1);
        this.addExpectedRows(expectedRows, ChangelogOperation.INSERT, snapshotId2, 1, this.records2);
        this.assertEquals("Should have expected rows", expectedRows, this.internalRowsToJava(rows));
    }

    @Test
    public void testDelete() throws IOException {
        this.table.newAppend().appendFile(this.dataFile1).commit();
        long snapshotId1 = this.table.currentSnapshot().snapshotId();
        this.table.newDelete().deleteFile(this.dataFile1).commit();
        long snapshotId2 = this.table.currentSnapshot().snapshotId();
        CloseableIterable taskGroups = ((IncrementalChangelogScan)this.newScan().fromSnapshotExclusive(snapshotId1)).planTasks();
        ArrayList rows = Lists.newArrayList();
        for (ScanTaskGroup taskGroup : taskGroups) {
            ChangelogRowReader reader = new ChangelogRowReader(this.table, taskGroup, this.table.schema(), this.table.schema(), false);
            while (reader.next()) {
                rows.add(((InternalRow)reader.get()).copy());
            }
            reader.close();
        }
        rows.sort((r1, r2) -> r1.getInt(0) - r2.getInt(0));
        ArrayList expectedRows = Lists.newArrayList();
        this.addExpectedRows(expectedRows, ChangelogOperation.DELETE, snapshotId2, 0, this.records1);
        this.assertEquals("Should have expected rows", expectedRows, this.internalRowsToJava(rows));
    }

    @Test
    public void testDataFileRewrite() throws IOException {
        this.table.newAppend().appendFile(this.dataFile1).commit();
        this.table.newAppend().appendFile(this.dataFile2).commit();
        long snapshotId2 = this.table.currentSnapshot().snapshotId();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)this.dataFile1), (Set)ImmutableSet.of((Object)this.dataFile2)).commit();
        CloseableIterable taskGroups = ((IncrementalChangelogScan)this.newScan().fromSnapshotExclusive(snapshotId2)).planTasks();
        ArrayList rows = Lists.newArrayList();
        for (ScanTaskGroup taskGroup : taskGroups) {
            ChangelogRowReader reader = new ChangelogRowReader(this.table, taskGroup, this.table.schema(), this.table.schema(), false);
            while (reader.next()) {
                rows.add(((InternalRow)reader.get()).copy());
            }
            reader.close();
        }
        ((ListAssert)Assertions.assertThat((List)rows).as("Should have no rows", new Object[0])).hasSize(0);
    }

    @Test
    public void testMixDeleteAndInsert() throws IOException {
        this.table.newAppend().appendFile(this.dataFile1).commit();
        long snapshotId1 = this.table.currentSnapshot().snapshotId();
        this.table.newDelete().deleteFile(this.dataFile1).commit();
        long snapshotId2 = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(this.dataFile2).commit();
        long snapshotId3 = this.table.currentSnapshot().snapshotId();
        CloseableIterable taskGroups = this.newScan().planTasks();
        ArrayList rows = Lists.newArrayList();
        for (ScanTaskGroup taskGroup : taskGroups) {
            ChangelogRowReader reader = new ChangelogRowReader(this.table, taskGroup, this.table.schema(), this.table.schema(), false);
            while (reader.next()) {
                rows.add(((InternalRow)reader.get()).copy());
            }
            reader.close();
        }
        rows.sort((r1, r2) -> {
            if (r1.getInt(3) != r2.getInt(3)) {
                return r1.getInt(3) - r2.getInt(3);
            }
            return r1.getInt(0) - r2.getInt(0);
        });
        ArrayList expectedRows = Lists.newArrayList();
        this.addExpectedRows(expectedRows, ChangelogOperation.INSERT, snapshotId1, 0, this.records1);
        this.addExpectedRows(expectedRows, ChangelogOperation.DELETE, snapshotId2, 1, this.records1);
        this.addExpectedRows(expectedRows, ChangelogOperation.INSERT, snapshotId3, 2, this.records2);
        this.assertEquals("Should have expected rows", expectedRows, this.internalRowsToJava(rows));
    }

    private IncrementalChangelogScan newScan() {
        return this.table.newIncrementalChangelogScan();
    }

    private List<Object[]> addExpectedRows(List<Object[]> expectedRows, ChangelogOperation operation, long snapshotId, int changeOrdinal, List<Record> records) {
        records.forEach(r -> expectedRows.add(this.row(r.get(0), r.get(1), operation.name(), changeOrdinal, snapshotId)));
        return expectedRows;
    }

    protected List<Object[]> internalRowsToJava(List<InternalRow> rows) {
        return rows.stream().map(this::toJava).collect(Collectors.toList());
    }

    private Object[] toJava(InternalRow row) {
        Object[] values = new Object[row.numFields()];
        values[0] = row.getInt(0);
        values[1] = row.getString(1);
        values[2] = row.getString(2);
        values[3] = row.getInt(3);
        values[4] = row.getLong(4);
        return values;
    }

    private DataFile writeDataFile(List<Record> records) throws IOException {
        return FileHelpers.writeDataFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), records);
    }
}

