/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestDataFrameWriterV2
extends TestBaseWithCatalog {
    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testMergeSchemaFailsWithoutWriterOption() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> threeColDF.writeTo(this.tableName).append()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Field new_col not found in source schema");
    }

    @TestTemplate
    public void testMergeSchemaWithoutAcceptAnySchema() throws Exception {
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> threeColDF.writeTo(this.tableName).option("merge-schema", "true").append()).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot write to `testhadoop`.`default`.`table`, the reason is too many data columns");
    }

    @TestTemplate
    public void testMergeSchemaSparkProperty() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        threeColDF.writeTo(this.tableName).option("mergeSchema", "true").append();
        this.assertEquals("Should have 3-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a", null), (Object)this.row(2L, "b", null), (Object)this.row(3L, "c", Float.valueOf(12.06f)), (Object)this.row(4L, "d", Float.valueOf(14.41f))), this.sql("select * from %s order by id", this.tableName));
    }

    @TestTemplate
    public void testMergeSchemaIcebergProperty() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        threeColDF.writeTo(this.tableName).option("merge-schema", "true").append();
        this.assertEquals("Should have 3-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a", null), (Object)this.row(2L, "b", null), (Object)this.row(3L, "c", Float.valueOf(12.06f)), (Object)this.row(4L, "d", Float.valueOf(14.41f))), this.sql("select * from %s order by id", this.tableName));
    }

    @TestTemplate
    public void testWriteWithCaseSensitiveOption() throws NoSuchTableException, ParseException {
        SparkSession sparkSession = spark.cloneSession();
        sparkSession.sql(String.format("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema")).collect();
        String schema = "ID bigint, DaTa string";
        ImmutableList records = ImmutableList.of((Object)"{ \"id\": 1, \"data\": \"a\" }", (Object)"{ \"id\": 2, \"data\": \"b\" }");
        sparkSession.sql(String.format("SET %s=false", SQLConf.CASE_SENSITIVE().key()));
        Dataset jsonDF = sparkSession.createDataset((List)ImmutableList.copyOf((Collection)records), Encoders.STRING());
        Dataset ds = sparkSession.read().schema(schema).json(jsonDF);
        ds.writeTo(this.tableName).option("merge-schema", "true").option("check-ordering", "false").append();
        List fields = Spark3Util.loadIcebergTable((SparkSession)sparkSession, (String)this.tableName).schema().asStruct().fields();
        Assertions.assertThat((List)fields).hasSize(2);
        sparkSession.sql(String.format("SET %s=true", SQLConf.CASE_SENSITIVE().key()));
        ds.writeTo(this.tableName).option("merge-schema", "true").option("check-ordering", "false").append();
        fields = Spark3Util.loadIcebergTable((SparkSession)sparkSession, (String)this.tableName).schema().asStruct().fields();
        Assertions.assertThat((List)fields).hasSize(4);
    }

    @TestTemplate
    public void testMergeSchemaSparkConfiguration() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        spark.conf().set("spark.sql.iceberg.merge-schema", "true");
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, salary float", "{ \"id\": 3, \"data\": \"c\", \"salary\": 120000.34 }", "{ \"id\": 4, \"data\": \"d\", \"salary\": 140000.56 }");
        threeColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have 3-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a", null), (Object)this.row(2L, "b", null), (Object)this.row(3L, "c", Float.valueOf(120000.34f)), (Object)this.row(4L, "d", Float.valueOf(140000.56f))), this.sql("select * from %s order by id", this.tableName));
    }

    @TestTemplate
    public void testMergeSchemaIgnoreCastingLongToInt() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> bigintDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        bigintDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial rows with long column", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> intDF = this.jsonToDF("id int, data string", "{ \"id\": 3, \"data\": \"c\" }", "{ \"id\": 4, \"data\": \"d\" }");
        Assertions.assertThatCode(() -> intDF.writeTo(this.tableName).option("merge-schema", "true").append()).doesNotThrowAnyException();
        this.assertEquals("Should include new rows with unchanged long column type", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d")), this.sql("select * from %s order by id", this.tableName));
        Types.NestedField idField = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName).schema().findField("id");
        Assertions.assertThat((Comparable)idField.type().typeId()).isEqualTo((Object)Type.TypeID.LONG);
    }

    @TestTemplate
    public void testMergeSchemaIgnoreCastingDoubleToFloat() throws Exception {
        this.removeTables();
        this.sql("CREATE TABLE %s (id double, data string) USING iceberg", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> doubleDF = this.jsonToDF("id double, data string", "{ \"id\": 1.0, \"data\": \"a\" }", "{ \"id\": 2.0, \"data\": \"b\" }");
        doubleDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial rows with double column", (List<Object[]>)ImmutableList.of((Object)this.row(1.0, "a"), (Object)this.row(2.0, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> floatDF = this.jsonToDF("id float, data string", "{ \"id\": 3.0, \"data\": \"c\" }", "{ \"id\": 4.0, \"data\": \"d\" }");
        Assertions.assertThatCode(() -> floatDF.writeTo(this.tableName).option("merge-schema", "true").append()).doesNotThrowAnyException();
        this.assertEquals("Should include new rows with unchanged double column type", (List<Object[]>)ImmutableList.of((Object)this.row(1.0, "a"), (Object)this.row(2.0, "b"), (Object)this.row(3.0, "c"), (Object)this.row(4.0, "d")), this.sql("select * from %s order by id", this.tableName));
        Types.NestedField idField = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName).schema().findField("id");
        Assertions.assertThat((Comparable)idField.type().typeId()).isEqualTo((Object)Type.TypeID.DOUBLE);
    }

    @TestTemplate
    public void testMergeSchemaIgnoreCastingDecimalToDecimalWithNarrowerPrecision() throws Exception {
        this.removeTables();
        this.sql("CREATE TABLE %s (id decimal(6,2), data string) USING iceberg", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> decimalPrecision6DF = this.jsonToDF("id decimal(6,2), data string", "{ \"id\": 1.0, \"data\": \"a\" }", "{ \"id\": 2.0, \"data\": \"b\" }");
        decimalPrecision6DF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial rows with decimal column with precision 6", (List<Object[]>)ImmutableList.of((Object)this.row(new BigDecimal("1.00"), "a"), (Object)this.row(new BigDecimal("2.00"), "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> decimalPrecision4DF = this.jsonToDF("id decimal(4,2), data string", "{ \"id\": 3.0, \"data\": \"c\" }", "{ \"id\": 4.0, \"data\": \"d\" }");
        Assertions.assertThatCode(() -> decimalPrecision4DF.writeTo(this.tableName).option("merge-schema", "true").append()).doesNotThrowAnyException();
        this.assertEquals("Should include new rows with unchanged decimal precision", (List<Object[]>)ImmutableList.of((Object)this.row(new BigDecimal("1.00"), "a"), (Object)this.row(new BigDecimal("2.00"), "b"), (Object)this.row(new BigDecimal("3.00"), "c"), (Object)this.row(new BigDecimal("4.00"), "d")), this.sql("select * from %s order by id", this.tableName));
        Type idFieldType = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName).schema().findField("id").type();
        Assertions.assertThat((Comparable)idFieldType.typeId()).isEqualTo((Object)Type.TypeID.DECIMAL);
        Types.DecimalType decimalType = (Types.DecimalType)idFieldType;
        Assertions.assertThat((int)decimalType.precision()).isEqualTo(6);
    }
}

