/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestDataFrameWriterV2Coercion
extends TestBaseWithCatalog {
    @Parameter(index=3)
    private FileFormat format;
    @Parameter(index=4)
    private String dataType;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, format = {3}, dataType = {4}")
    public static Object[][] parameters() {
        return new Object[][]{TestDataFrameWriterV2Coercion.parameter(FileFormat.AVRO, "byte"), TestDataFrameWriterV2Coercion.parameter(FileFormat.ORC, "byte"), TestDataFrameWriterV2Coercion.parameter(FileFormat.PARQUET, "byte"), TestDataFrameWriterV2Coercion.parameter(FileFormat.AVRO, "short"), TestDataFrameWriterV2Coercion.parameter(FileFormat.ORC, "short"), TestDataFrameWriterV2Coercion.parameter(FileFormat.PARQUET, "short")};
    }

    private static Object[] parameter(FileFormat fileFormat, String dataType) {
        return new Object[]{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), fileFormat, dataType};
    }

    @TestTemplate
    public void testByteAndShortCoercion() {
        Dataset<Row> df = this.jsonToDF("id " + this.dataType + ", data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        df.writeTo(this.tableName).option("write-format", this.format.name()).createOrReplace();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "a"), (Object)this.row(2, "b")), this.sql("select * from %s order by id", this.tableName));
    }
}

