/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMetadataTablesWithPartitionEvolution
extends CatalogTestBase {
    @Parameter(index=3)
    private FileFormat fileFormat;
    @Parameter(index=4)
    private int formatVersion;

    @Parameters(name="catalog = {0}, impl = {1}, conf = {2}, fileFormat = {3}, formatVersion = {4}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.ORC, 1}, {"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default"), FileFormat.ORC, 2}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop"), FileFormat.PARQUET, 1}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop"), FileFormat.PARQUET, 2}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"clients", (Object)"1", (Object)"parquet-enabled", (Object)"false", (Object)"cache-enabled", (Object)"false"), FileFormat.AVRO, 1}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"clients", (Object)"1", (Object)"parquet-enabled", (Object)"false", (Object)"cache-enabled", (Object)"false"), FileFormat.AVRO, 2}};
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testFilesMetadataTable() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)df.schema().getFieldIndex("partition").isEmpty()).as("Partition must be skipped", new Object[0])).isTrue();
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("b1")), "STRUCT<data:STRING>", tableType);
        }
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().renameField("category_bucket_8", "category_bucket_8_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8_another_name:INT>", tableType);
        }
    }

    @TestTemplate
    public void testFilesMetadataTableFilter() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'false')", this.tableName, "commit.manifest-merge.enabled");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)df.schema().getFieldIndex("partition").isEmpty()).as("Partition must be skipped", new Object[0])).isTrue();
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2")), "STRUCT<data:STRING>", tableType, "partition.data = 'd2'");
        }
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.data = 'd2'");
        }
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.category = 'c2'");
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (4, 'c4', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (5, 'c2', 'd5')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.data = 'd2'");
        }
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", tableType, "partition.category = 'c2'");
        }
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (6, 'c2', 'd6')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category_another_name:STRING>", tableType, "partition.category_another_name = 'c2'");
        }
    }

    @TestTemplate
    public void testEntriesMetadataTable() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            Dataset<Row> df = this.loadMetadataTable(tableType);
            StructType dataFileType = (StructType)df.schema().apply("data_file").dataType();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)dataFileType.getFieldIndex("").isEmpty()).as("Partition must be skipped", new Object[0])).isTrue();
        }
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("b1")), "STRUCT<data:STRING>", tableType);
        }
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8:INT>", tableType);
        }
        table.updateSpec().renameField("category_bucket_8", "category_bucket_8_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, 2), (Object)this.row("b1", null), (Object)this.row("b1", 2)), "STRUCT<data:STRING,category_bucket_8_another_name:INT>", tableType);
        }
    }

    @TestTemplate
    public void testPartitionsTableAddRemoveFields() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Dataset<Row> df = this.loadMetadataTable(MetadataTableType.PARTITIONS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)df.schema().getFieldIndex("partition").isEmpty()).as("Partition must be skipped", new Object[0])).isTrue();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(new Object[]{null}), (Object)this.row("d1"), (Object)this.row("d2")), "STRUCT<data:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row("d1", null), (Object)this.row("d1", "c1"), (Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, null), (Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", null), (Object)this.row("d1", "c1"), (Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
    }

    @TestTemplate
    public void testPartitionsTableRenameFields() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category_another_name:STRING>", MetadataTableType.PARTITIONS);
    }

    @TestTemplate
    public void testPartitionsTableSwitchFields() throws Exception {
        this.createTable("id bigint NOT NULL, category string, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", "c1"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd3')", this.tableName);
        if (this.formatVersion == 1) {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1", null), (Object)this.row(null, "c1", "d1"), (Object)this.row(null, "c2", null), (Object)this.row(null, "c2", "d2"), (Object)this.row(null, "c3", "d3"), (Object)this.row("d1", "c1", null), (Object)this.row("d2", "c2", null)), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS);
        } else {
            this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1"), (Object)this.row(null, "c2"), (Object)this.row("d1", "c1"), (Object)this.row("d2", "c2"), (Object)this.row("d3", "c3")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS);
        }
    }

    @TestTemplate
    public void testPartitionTableFilterAddRemoveFields() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2")), "STRUCT<data:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        table.updateSpec().addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c3', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (4, 'c4', 'd2')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (5, 'c2', 'd5')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d2", null), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2"), (Object)this.row("d2", "c2")), "STRUCT<data:STRING,category:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
    }

    @TestTemplate
    public void testPartitionTableFilterSwitchFields() throws Exception {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(1);
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().removeField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c2", null), (Object)this.row(null, "c2", "d2"), (Object)this.row("d2", "c2", null)), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS, "partition.category = 'c2'");
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row(null, "c1", "d1")), "STRUCT<data_1000:STRING,category:STRING,data:STRING>", MetadataTableType.PARTITIONS, "partition.data = 'd1'");
    }

    @TestTemplate
    public void testPartitionsTableFilterRenameFields() throws ParseException {
        this.createTable("id bigint NOT NULL, category string, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("data").addField("category").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        table.updateSpec().renameField("category", "category_another_name").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'c1', 'd1')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'c2', 'd2')", this.tableName);
        this.assertPartitions((List<Object[]>)ImmutableList.of((Object)this.row("d1", "c1")), "STRUCT<data:STRING,category_another_name:STRING>", MetadataTableType.PARTITIONS, "partition.category_another_name = 'c1'");
    }

    @TestTemplate
    public void testMetadataTablesWithUnknownTransforms() {
        this.createTable("id bigint NOT NULL, category string, data string");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a1', 'b1')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        PartitionSpec unknownSpec = TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(1).addField("zero", 1, "id_zero").build();
        TableOperations ops = ((HasTableOperations)table).operations();
        TableMetadata base = ops.current();
        ops.commit(base, base.updatePartitionSpec(unknownSpec));
        this.sql("REFRESH TABLE %s", this.tableName);
        for (MetadataTableType tableType : Arrays.asList(MetadataTableType.FILES, MetadataTableType.ALL_DATA_FILES, MetadataTableType.ENTRIES, MetadataTableType.ALL_ENTRIES)) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.loadMetadataTable(tableType)).isInstanceOf(ValidationException.class)).hasMessage("Cannot build table partition type, unknown transforms: [zero]");
        }
    }

    @TestTemplate
    public void testPartitionColumnNamedPartition() {
        this.sql("CREATE TABLE %s (id int, partition int) USING iceberg PARTITIONED BY (partition)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 1), (2, 1), (3, 2), (2, 2)", this.tableName);
        ImmutableList expected = ImmutableList.of((Object)this.row(1, 1), (Object)this.row(2, 1), (Object)this.row(3, 2), (Object)this.row(2, 2));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s", this.tableName));
        Assertions.assertThat(this.sql("SELECT * FROM %s.files", this.tableName)).hasSize(2);
    }

    private void assertPartitions(List<Object[]> expectedPartitions, String expectedTypeAsString, MetadataTableType tableType) throws ParseException {
        this.assertPartitions(expectedPartitions, expectedTypeAsString, tableType, null);
    }

    private void assertPartitions(List<Object[]> expectedPartitions, String expectedTypeAsString, MetadataTableType tableType, String filter) throws ParseException {
        Dataset df = this.loadMetadataTable(tableType);
        if (filter != null) {
            df = df.filter(filter);
        }
        DataType expectedType = spark.sessionState().sqlParser().parseDataType(expectedTypeAsString);
        switch (tableType) {
            case PARTITIONS: 
            case FILES: 
            case ALL_DATA_FILES: {
                DataType actualFilesType = df.schema().apply("partition").dataType();
                ((ObjectAssert)Assertions.assertThat((Object)actualFilesType).as("Partition type must match", new Object[0])).isEqualTo((Object)expectedType);
                break;
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                StructType dataFileType = (StructType)df.schema().apply("data_file").dataType();
                DataType actualEntriesType = dataFileType.apply("partition").dataType();
                ((ObjectAssert)Assertions.assertThat((Object)actualEntriesType).as("Partition type must match", new Object[0])).isEqualTo((Object)expectedType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported metadata table type: " + tableType);
            }
        }
        switch (tableType) {
            case PARTITIONS: 
            case FILES: 
            case ALL_DATA_FILES: {
                List actualFilesPartitions = df.orderBy("partition", new String[0]).select("partition.*", new String[0]).collectAsList();
                this.assertEquals("Partitions must match", expectedPartitions, this.rowsToJava(actualFilesPartitions));
                break;
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                List actualEntriesPartitions = df.orderBy("data_file.partition", new String[0]).select("data_file.partition.*", new String[0]).collectAsList();
                this.assertEquals("Partitions must match", expectedPartitions, this.rowsToJava(actualEntriesPartitions));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported metadata table type: " + tableType);
            }
        }
    }

    private Dataset<Row> loadMetadataTable(MetadataTableType tableType) {
        return spark.read().format("iceberg").load(this.tableName + "." + tableType.name());
    }

    private void createTable(String schema) {
        this.sql("CREATE TABLE %s (%s) USING iceberg TBLPROPERTIES ('%s' '%s', '%s' '%d')", this.tableName, schema, "write.format.default", this.fileFormat.name(), "format-version", this.formatVersion);
    }
}

