/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.spark.source.ScanTestBase;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;

public class TestParquetScan
extends ScanTestBase {
    protected boolean vectorized() {
        return false;
    }

    @Override
    protected void configureTable(Table table) {
        table.updateProperties().set("read.parquet.vectorization.enabled", String.valueOf(this.vectorized())).commit();
    }

    @Override
    protected void writeRecords(Table table, List<GenericData.Record> records) throws IOException {
        File dataFolder = new File(table.location(), "data");
        File parquetFile = new File(dataFolder, FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(table.schema()).build();){
            writer.addAll(records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(parquetFile.length()).withPath(parquetFile.toString()).withRecordCount((long)records.size()).build();
        table.newAppend().appendFile(file).commit();
    }

    @Override
    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        ((ObjectAssert)Assumptions.assumeThat((Object)TypeUtil.find((Schema)writeSchema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get())).as("Cannot handle non-string map keys in parquet-avro", new Object[0])).isNull();
        super.writeAndValidate(writeSchema, expectedSchema);
    }
}

