/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.PathIdentifier;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestPathIdentifier
extends TestBase {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    @TempDir
    private Path temp;
    private File tableLocation;
    private PathIdentifier identifier;
    private SparkCatalog sparkCatalog;

    @BeforeEach
    public void before() throws IOException {
        this.tableLocation = this.temp.toFile();
        this.identifier = new PathIdentifier(this.tableLocation.getAbsolutePath());
        this.sparkCatalog = new SparkCatalog();
        this.sparkCatalog.initialize("test", new CaseInsensitiveStringMap((Map)ImmutableMap.of()));
    }

    @AfterEach
    public void after() {
        this.tableLocation.delete();
        this.sparkCatalog = null;
    }

    @Test
    public void testPathIdentifier() throws TableAlreadyExistsException, NoSuchTableException {
        SparkTable table = (SparkTable)this.sparkCatalog.createTable((Identifier)this.identifier, SparkSchemaUtil.convert((Schema)SCHEMA), new Transform[0], (Map)ImmutableMap.of());
        Assertions.assertThat((String)this.tableLocation.getAbsolutePath()).isEqualTo(table.table().location());
        Assertions.assertThat((Object)table.table()).isInstanceOf(BaseTable.class);
        Assertions.assertThat((Object)((BaseTable)table.table()).operations()).isInstanceOf(HadoopTableOperations.class);
        Assertions.assertThat((Object)table).isEqualTo((Object)this.sparkCatalog.loadTable((Identifier)this.identifier));
        Assertions.assertThat((boolean)this.sparkCatalog.dropTable((Identifier)this.identifier)).isTrue();
    }
}

