/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.source.PositionDeletesRowReader;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestPositionDeletesReader
extends TestBase {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    private Table table;
    private DataFile dataFile1;
    private DataFile dataFile2;
    @TempDir
    private Path temp;
    @Parameter(index=0)
    private int formatVersion;

    @Parameters(name="formatVersion = {0}")
    protected static List<Object> parameters() {
        return ImmutableList.of((Object)2, (Object)3);
    }

    @BeforeEach
    public void before() throws IOException {
        this.table = catalog.createTable(TableIdentifier.of((String[])new String[]{"default", "test"}), SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(this.formatVersion)));
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        ArrayList records1 = Lists.newArrayList();
        records1.add(record.copy("id", (Object)29, "data", (Object)"a"));
        records1.add(record.copy("id", (Object)43, "data", (Object)"b"));
        records1.add(record.copy("id", (Object)61, "data", (Object)"c"));
        records1.add(record.copy("id", (Object)89, "data", (Object)"d"));
        ArrayList records2 = Lists.newArrayList();
        records2.add(record.copy("id", (Object)100, "data", (Object)"e"));
        records2.add(record.copy("id", (Object)121, "data", (Object)"f"));
        records2.add(record.copy("id", (Object)122, "data", (Object)"g"));
        this.dataFile1 = this.writeDataFile(records1);
        this.dataFile2 = this.writeDataFile(records2);
        this.table.newAppend().appendFile(this.dataFile1).appendFile(this.dataFile2).commit();
    }

    @AfterEach
    public void after() {
        catalog.dropTable(TableIdentifier.of((String[])new String[]{"default", "test"}));
    }

    @TestTemplate
    public void readPositionDeletesTableWithNoDeleteFiles() {
        Table positionDeletesTable = catalog.loadTable(TableIdentifier.of((String[])new String[]{"default", "test", "position_deletes"}));
        Assertions.assertThat((Iterable)positionDeletesTable.newBatchScan().planFiles()).isEmpty();
    }

    @TestTemplate
    public void readPositionDeletesTableWithMultipleDeleteFiles() throws IOException {
        Pair posDeletes1 = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile1.location(), (Object)0L), Pair.of((Object)this.dataFile1.location(), (Object)1L)}), (int)this.formatVersion);
        Pair posDeletes2 = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile2.location(), (Object)2L), Pair.of((Object)this.dataFile2.location(), (Object)3L)}), (int)this.formatVersion);
        DeleteFile deleteFile1 = (DeleteFile)posDeletes1.first();
        DeleteFile deleteFile2 = (DeleteFile)posDeletes2.first();
        this.table.newRowDelta().addDeletes(deleteFile1).addDeletes(deleteFile2).validateDataFilesExist((Iterable)posDeletes1.second()).validateDataFilesExist((Iterable)posDeletes2.second()).commit();
        Table positionDeletesTable = catalog.loadTable(TableIdentifier.of((String[])new String[]{"default", "test", "position_deletes"}));
        ArrayList columns = Lists.newArrayList((Object[])new String[]{MetadataColumns.DELETE_FILE_PATH.name(), MetadataColumns.DELETE_FILE_POS.name(), "delete_file_path"});
        if (this.formatVersion >= 3) {
            columns.add("content_offset");
            columns.add("content_size_in_bytes");
        }
        Schema projectedSchema = positionDeletesTable.schema().select((Collection)columns);
        ArrayList scanTasks = Lists.newArrayList((Iterable)((BatchScan)positionDeletesTable.newBatchScan().project(projectedSchema)).planFiles());
        Assertions.assertThat((List)scanTasks).hasSize(2);
        Assertions.assertThat((Object)((ScanTask)scanTasks.get(0))).isInstanceOf(PositionDeletesScanTask.class);
        PositionDeletesScanTask scanTask1 = (PositionDeletesScanTask)scanTasks.get(0);
        try (PositionDeletesRowReader reader = new PositionDeletesRowReader(this.table, (ScanTaskGroup)new BaseScanTaskGroup(null, (Collection)ImmutableList.of((Object)scanTask1)), positionDeletesTable.schema(), projectedSchema, false);){
            ArrayList actualRows = Lists.newArrayList();
            while (reader.next()) {
                actualRows.add(((InternalRow)reader.get()).copy());
            }
            String dataFileLocation = this.formatVersion >= 3 ? deleteFile1.referencedDataFile() : this.dataFile1.location();
            ArrayList first = Lists.newArrayList((Object[])new Object[]{UTF8String.fromString((String)dataFileLocation), 0L, UTF8String.fromString((String)deleteFile1.location())});
            ArrayList second = Lists.newArrayList((Object[])new Object[]{UTF8String.fromString((String)dataFileLocation), 1L, UTF8String.fromString((String)deleteFile1.location())});
            if (this.formatVersion >= 3) {
                first.add(deleteFile1.contentOffset());
                first.add(deleteFile1.contentSizeInBytes());
                second.add(deleteFile1.contentOffset());
                second.add(deleteFile1.contentSizeInBytes());
            }
            ((ListAssert)Assertions.assertThat(this.internalRowsToJava(actualRows, projectedSchema)).hasSize(2)).containsExactly((Object[])new Object[][]{first.toArray(), second.toArray()});
        }
        Assertions.assertThat((Object)((ScanTask)scanTasks.get(1))).isInstanceOf(PositionDeletesScanTask.class);
        PositionDeletesScanTask scanTask2 = (PositionDeletesScanTask)scanTasks.get(1);
        try (PositionDeletesRowReader reader = new PositionDeletesRowReader(this.table, (ScanTaskGroup)new BaseScanTaskGroup(null, (Collection)ImmutableList.of((Object)scanTask2)), positionDeletesTable.schema(), projectedSchema, false);){
            ArrayList actualRows = Lists.newArrayList();
            while (reader.next()) {
                actualRows.add(((InternalRow)reader.get()).copy());
            }
            String dataFileLocation = this.formatVersion >= 3 ? deleteFile2.referencedDataFile() : this.dataFile2.location();
            ArrayList first = Lists.newArrayList((Object[])new Object[]{UTF8String.fromString((String)dataFileLocation), 2L, UTF8String.fromString((String)deleteFile2.location())});
            ArrayList second = Lists.newArrayList((Object[])new Object[]{UTF8String.fromString((String)dataFileLocation), 3L, UTF8String.fromString((String)deleteFile2.location())});
            if (this.formatVersion >= 3) {
                first.add(deleteFile2.contentOffset());
                first.add(deleteFile2.contentSizeInBytes());
                second.add(deleteFile2.contentOffset());
                second.add(deleteFile2.contentSizeInBytes());
            }
            ((ListAssert)Assertions.assertThat(this.internalRowsToJava(actualRows, projectedSchema)).hasSize(2)).containsExactly((Object[])new Object[][]{first.toArray(), second.toArray()});
        }
    }

    @TestTemplate
    public void readPositionDeletesTableWithDifferentColumnOrdering() throws IOException {
        Pair posDeletes1 = FileHelpers.writeDeleteFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile1.location(), (Object)0L), Pair.of((Object)this.dataFile1.location(), (Object)1L)}), (int)this.formatVersion);
        DeleteFile deleteFile1 = (DeleteFile)posDeletes1.first();
        this.table.newRowDelta().addDeletes(deleteFile1).validateDataFilesExist((Iterable)posDeletes1.second()).commit();
        Table positionDeletesTable = catalog.loadTable(TableIdentifier.of((String[])new String[]{"default", "test", "position_deletes"}));
        Schema projectedSchema = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_POS, MetadataColumns.DELETE_FILE_PATH});
        ArrayList scanTasks = Lists.newArrayList((Iterable)((BatchScan)positionDeletesTable.newBatchScan().project(projectedSchema)).planFiles());
        Assertions.assertThat((List)scanTasks).hasSize(1);
        Assertions.assertThat((Object)((ScanTask)scanTasks.get(0))).isInstanceOf(PositionDeletesScanTask.class);
        PositionDeletesScanTask scanTask1 = (PositionDeletesScanTask)scanTasks.get(0);
        try (PositionDeletesRowReader reader = new PositionDeletesRowReader(this.table, (ScanTaskGroup)new BaseScanTaskGroup(null, (Collection)ImmutableList.of((Object)scanTask1)), positionDeletesTable.schema(), projectedSchema, false);){
            ArrayList actualRows = Lists.newArrayList();
            while (reader.next()) {
                actualRows.add(((InternalRow)reader.get()).copy());
            }
            ((ListAssert)Assertions.assertThat(this.internalRowsToJava(actualRows, projectedSchema)).hasSize(2)).containsExactly((Object[])new Object[][]{{0L, UTF8String.fromString((String)this.dataFile1.location())}, {1L, UTF8String.fromString((String)this.dataFile1.location())}});
        }
    }

    private DataFile writeDataFile(List<Record> records) throws IOException {
        return FileHelpers.writeDataFile((Table)this.table, (OutputFile)Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), records);
    }

    private List<Object[]> internalRowsToJava(List<InternalRow> rows, Schema projection) {
        return rows.stream().map(row -> this.toJava((InternalRow)row, projection)).collect(Collectors.toList());
    }

    private Object[] toJava(InternalRow row, Schema projection) {
        Object[] values = new Object[row.numFields()];
        for (int i = 0; i < projection.columns().size(); ++i) {
            values[i] = row.get(i, SparkSchemaUtil.convert((Type)((Types.NestedField)projection.columns().get(i)).type()));
        }
        return values;
    }
}

