/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkCatalogCacheExpiration
extends TestBaseWithCatalog {
    private static final Map<String, String> SESSION_CATALOG_CONFIG = ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)"default", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"3000");

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"spark_catalog", SparkSessionCatalog.class.getName(), SESSION_CATALOG_CONFIG}};
    }

    private static String asSqlConfCatalogKeyFor(String catalog, String configKey) {
        if (configKey.isEmpty()) {
            return String.format("spark.sql.catalog.%s", catalog);
        }
        return String.format("spark.sql.catalog.%s.%s", catalog, configKey);
    }

    @BeforeAll
    public static void beforeClass() {
        ImmutableMap.of((Object)"", (Object)"org.apache.iceberg.spark.SparkCatalog", (Object)"type", (Object)"hive", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"-1").forEach((k, v) -> spark.conf().set(TestSparkCatalogCacheExpiration.asSqlConfCatalogKeyFor("expiration_disabled", k), v));
        ImmutableMap.of((Object)"", (Object)"org.apache.iceberg.spark.SparkCatalog", (Object)"type", (Object)"hive", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"0").forEach((k, v) -> spark.conf().set(TestSparkCatalogCacheExpiration.asSqlConfCatalogKeyFor("cache_disabled_implicitly", k), v));
    }

    @TestTemplate
    public void testSparkSessionCatalogWithExpirationEnabled() {
        SparkSessionCatalog<?> sparkCatalog = this.sparkSessionCatalog();
        Assertions.assertThat(sparkCatalog).extracting("icebergCatalog").extracting("cacheEnabled").isEqualTo((Object)true);
        Assertions.assertThat(sparkCatalog).extracting("icebergCatalog").extracting("icebergCatalog").isInstanceOfSatisfying(Catalog.class, icebergCatalog -> ((ObjectAssert)Assertions.assertThat((Object)icebergCatalog).isExactlyInstanceOf(CachingCatalog.class)).extracting("expirationIntervalMillis").isEqualTo((Object)3000L));
    }

    @TestTemplate
    public void testCacheEnabledAndExpirationDisabled() {
        SparkCatalog sparkCatalog = this.getSparkCatalog("expiration_disabled");
        Assertions.assertThat((Object)sparkCatalog).extracting("cacheEnabled").isEqualTo((Object)true);
        Assertions.assertThat((Object)sparkCatalog).extracting("icebergCatalog").isInstanceOfSatisfying(CachingCatalog.class, icebergCatalog -> Assertions.assertThat((Object)icebergCatalog).extracting("expirationIntervalMillis").isEqualTo((Object)-1L));
    }

    @TestTemplate
    public void testCacheDisabledImplicitly() {
        SparkCatalog sparkCatalog = this.getSparkCatalog("cache_disabled_implicitly");
        Assertions.assertThat((Object)sparkCatalog).extracting("cacheEnabled").isEqualTo((Object)false);
        Assertions.assertThat((Object)sparkCatalog).extracting("icebergCatalog").isInstanceOfSatisfying(Catalog.class, icebergCatalog -> Assertions.assertThat((Object)icebergCatalog).isNotInstanceOf(CachingCatalog.class));
    }

    private SparkSessionCatalog<?> sparkSessionCatalog() {
        TableCatalog catalog = (TableCatalog)spark.sessionState().catalogManager().catalog("spark_catalog");
        return (SparkSessionCatalog)catalog;
    }

    private SparkCatalog getSparkCatalog(String catalog) {
        return (SparkCatalog)spark.sessionState().catalogManager().catalog(catalog);
    }
}

