/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkCatalogHadoopOverrides
extends CatalogTestBase {
    private static final String CONFIG_TO_OVERRIDE = "fs.s3a.buffer.dir";
    private static final String HADOOP_PREFIXED_CONFIG_TO_OVERRIDE = "hadoop.fs.s3a.buffer.dir";
    private static final String CONFIG_OVERRIDE_VALUE = "/tmp-overridden";

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)HADOOP_PREFIXED_CONFIG_TO_OVERRIDE, (Object)CONFIG_OVERRIDE_VALUE)}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)HADOOP_PREFIXED_CONFIG_TO_OVERRIDE, (Object)CONFIG_OVERRIDE_VALUE)}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)HADOOP_PREFIXED_CONFIG_TO_OVERRIDE, (Object)CONFIG_OVERRIDE_VALUE)}};
    }

    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE IF NOT EXISTS %s (id bigint) USING iceberg", this.tableName(this.tableIdent.name()));
    }

    @AfterEach
    public void dropTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName(this.tableIdent.name()));
    }

    @TestTemplate
    public void testTableFromCatalogHasOverrides() throws Exception {
        Table table = this.getIcebergTableFromSparkCatalog();
        Configuration conf = ((Configurable)table.io()).getConf();
        String actualCatalogOverride = conf.get(CONFIG_TO_OVERRIDE, "/whammies");
        ((AbstractStringAssert)Assertions.assertThat((String)actualCatalogOverride).as("Iceberg tables from spark should have the overridden hadoop configurations from the spark config", new Object[0])).isEqualTo(CONFIG_OVERRIDE_VALUE);
    }

    @TestTemplate
    public void ensureRoundTripSerializedTableRetainsHadoopConfig() throws Exception {
        Table table = this.getIcebergTableFromSparkCatalog();
        Configuration originalConf = ((Configurable)table.io()).getConf();
        String actualCatalogOverride = originalConf.get(CONFIG_TO_OVERRIDE, "/whammies");
        ((AbstractStringAssert)Assertions.assertThat((String)actualCatalogOverride).as("Iceberg tables from spark should have the overridden hadoop configurations from the spark config", new Object[0])).isEqualTo(CONFIG_OVERRIDE_VALUE);
        Table serializableTable = SerializableTableWithSize.copyOf((Table)table);
        Table kryoSerializedTable = KryoHelpers.roundTripSerialize(SerializableTableWithSize.copyOf((Table)table));
        Configuration configFromKryoSerde = ((Configurable)kryoSerializedTable.io()).getConf();
        String kryoSerializedCatalogOverride = configFromKryoSerde.get(CONFIG_TO_OVERRIDE, "/whammies");
        ((AbstractStringAssert)Assertions.assertThat((String)kryoSerializedCatalogOverride).as("Tables serialized with Kryo serialization should retain overridden hadoop configuration properties", new Object[0])).isEqualTo(CONFIG_OVERRIDE_VALUE);
        Table javaSerializedTable = (Table)TestHelpers.roundTripSerialize((Object)serializableTable);
        Configuration configFromJavaSerde = ((Configurable)javaSerializedTable.io()).getConf();
        String javaSerializedCatalogOverride = configFromJavaSerde.get(CONFIG_TO_OVERRIDE, "/whammies");
        ((AbstractStringAssert)Assertions.assertThat((String)javaSerializedCatalogOverride).as("Tables serialized with Java serialization should retain overridden hadoop configuration properties", new Object[0])).isEqualTo(CONFIG_OVERRIDE_VALUE);
    }

    private Table getIcebergTableFromSparkCatalog() throws Exception {
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        TableCatalog catalog = (TableCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        SparkTable sparkTable = (SparkTable)catalog.loadTable(identifier);
        return sparkTable.table();
    }
}

