/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SystemFunctionPushDownHelper;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.DaysFunction;
import org.apache.iceberg.spark.functions.HoursFunction;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.iceberg.spark.functions.YearsFunction;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.UserDefinedScalarFunc;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsPushDownV2Filters;
import org.apache.spark.sql.connector.read.colstats.ColumnStatistics;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSparkScan
extends TestBaseWithCatalog {
    private static final String DUMMY_BLOB_TYPE = "sum-data-size-bytes-v1";
    @Parameter(index=3)
    private String format;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, format = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), "parquet"}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), "avro"}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), "orc"}};
    }

    @BeforeEach
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testEstimatedRowCount() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT, date DATE) USING iceberg TBLPROPERTIES('%s' = '%s')", this.tableName, "write.format.default", this.format);
        Dataset df = spark.range(10000L).withColumn("date", functions.date_add((Column)functions.expr((String)"DATE '1970-01-01'"), (Column)functions.expr((String)"CAST(id AS INT)"))).select("id", new String[]{"date"});
        df.coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        Statistics stats = scan.estimateStatistics();
        Assertions.assertThat((long)stats.numRows().getAsLong()).isEqualTo(10000L);
    }

    @TestTemplate
    public void testTableWithoutColStats() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "a"), new SimpleRecord(4, "b")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        ImmutableMap reportColStatsDisabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.report-column-stats", (Object)"false");
        ImmutableMap reportColStatsEnabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true");
        this.checkColStatisticsNotReported(scan, 4L);
        this.withSQLConf((Map<String, String>)reportColStatsDisabled, () -> this.checkColStatisticsNotReported(scan, 4L));
        this.withSQLConf((Map<String, String>)reportColStatsEnabled, () -> this.checkColStatisticsReported(scan, 4L, Maps.newHashMap()));
    }

    @TestTemplate
    public void testTableWithoutApacheDatasketchColStat() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "a"), new SimpleRecord(4, "b")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        ImmutableMap reportColStatsDisabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.report-column-stats", (Object)"false");
        ImmutableMap reportColStatsEnabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true");
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/test/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata(DUMMY_BLOB_TYPE, snapshotId, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"data_size", (Object)"4"))));
        table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        this.checkColStatisticsNotReported(scan, 4L);
        this.withSQLConf((Map<String, String>)reportColStatsDisabled, () -> this.checkColStatisticsNotReported(scan, 4L));
        this.withSQLConf((Map<String, String>)reportColStatsEnabled, () -> this.checkColStatisticsReported(scan, 4L, Maps.newHashMap()));
    }

    @TestTemplate
    public void testTableWithOneColStats() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "a"), new SimpleRecord(4, "b")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        ImmutableMap reportColStatsDisabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.report-column-stats", (Object)"false");
        ImmutableMap reportColStatsEnabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true");
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/test/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("apache-datasketches-theta-v1", snapshotId, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"ndv", (Object)"4"))));
        table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        this.checkColStatisticsNotReported(scan, 4L);
        this.withSQLConf((Map<String, String>)reportColStatsDisabled, () -> this.checkColStatisticsNotReported(scan, 4L));
        HashMap expectedOneNDV = Maps.newHashMap();
        expectedOneNDV.put("id", 4L);
        this.withSQLConf((Map<String, String>)reportColStatsEnabled, () -> this.checkColStatisticsReported(scan, 4L, expectedOneNDV));
    }

    @TestTemplate
    public void testTableWithOneApacheDatasketchColStatAndOneDifferentColStat() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "a"), new SimpleRecord(4, "b")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        ImmutableMap reportColStatsDisabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.report-column-stats", (Object)"false");
        ImmutableMap reportColStatsEnabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true");
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/test/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("apache-datasketches-theta-v1", snapshotId, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"ndv", (Object)"4")), (Object)new GenericBlobMetadata(DUMMY_BLOB_TYPE, snapshotId, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"data_size", (Object)"2"))));
        table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        this.checkColStatisticsNotReported(scan, 4L);
        this.withSQLConf((Map<String, String>)reportColStatsDisabled, () -> this.checkColStatisticsNotReported(scan, 4L));
        HashMap expectedOneNDV = Maps.newHashMap();
        expectedOneNDV.put("id", 4L);
        this.withSQLConf((Map<String, String>)reportColStatsEnabled, () -> this.checkColStatisticsReported(scan, 4L, expectedOneNDV));
    }

    @TestTemplate
    public void testTableWithTwoColStats() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "a"), new SimpleRecord(4, "b")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        ImmutableMap reportColStatsDisabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true", (Object)"spark.sql.iceberg.report-column-stats", (Object)"false");
        ImmutableMap reportColStatsEnabled = ImmutableMap.of((Object)SQLConf.CBO_ENABLED().key(), (Object)"true");
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/test/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("apache-datasketches-theta-v1", snapshotId, 1L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"ndv", (Object)"4")), (Object)new GenericBlobMetadata("apache-datasketches-theta-v1", snapshotId, 1L, (List)ImmutableList.of((Object)2), (Map)ImmutableMap.of((Object)"ndv", (Object)"2"))));
        table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        this.checkColStatisticsNotReported(scan, 4L);
        this.withSQLConf((Map<String, String>)reportColStatsDisabled, () -> this.checkColStatisticsNotReported(scan, 4L));
        HashMap expectedTwoNDVs = Maps.newHashMap();
        expectedTwoNDVs.put("id", 4L);
        expectedTwoNDVs.put("data", 2L);
        this.withSQLConf((Map<String, String>)reportColStatsEnabled, () -> this.checkColStatisticsReported(scan, 4L, expectedTwoNDVs));
    }

    @TestTemplate
    public void testUnpartitionedYears() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction function = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToYearOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedYears() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction function = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToYearOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @TestTemplate
    public void testUnpartitionedMonths() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        MonthsFunction.TimestampToMonthsFunction function = new MonthsFunction.TimestampToMonthsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToMonthOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedMonths() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "months(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        MonthsFunction.TimestampToMonthsFunction function = new MonthsFunction.TimestampToMonthsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToMonthOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @TestTemplate
    public void testUnpartitionedDays() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        DaysFunction.TimestampToDaysFunction function = new DaysFunction.TimestampToDaysFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("<", this.expressions(new Expression[]{udf, TestSparkScan.dateLit(SystemFunctionPushDownHelper.timestampStrToDayOrdinal("2018-11-20T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedDays() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "days(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        DaysFunction.TimestampToDaysFunction function = new DaysFunction.TimestampToDaysFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("<", this.expressions(new Expression[]{udf, TestSparkScan.dateLit(SystemFunctionPushDownHelper.timestampStrToDayOrdinal("2018-11-20T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @TestTemplate
    public void testUnpartitionedHours() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        HoursFunction.TimestampToHoursFunction function = new HoursFunction.TimestampToHoursFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToHourOrdinal("2017-11-22T06:02:09.243857+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedHours() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "hours(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        HoursFunction.TimestampToHoursFunction function = new HoursFunction.TimestampToHoursFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToHourOrdinal("2017-11-22T06:02:09.243857+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(8);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(2);
    }

    @TestTemplate
    public void testUnpartitionedBucketLong() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketLong function = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedBucketLong() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketLong function = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    @TestTemplate
    public void testUnpartitionedBucketString() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketString function = new BucketFunction.BucketString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedBucketString() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "bucket(5, data)");
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketString function = new BucketFunction.BucketString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    @TestTemplate
    public void testUnpartitionedTruncateString() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<>", this.expressions(new Expression[]{udf, TestSparkScan.stringLit("data")}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedTruncateString() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<>", this.expressions(new Expression[]{udf, TestSparkScan.stringLit("data")}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @TestTemplate
    public void testUnpartitionedIsNull() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedIsNull() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(0);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testUnpartitionedIsNotNull() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NOT_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedIsNotNull() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NOT_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(0);
    }

    @TestTemplate
    public void testUnpartitionedAnd() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        And predicate = new And(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedAnd() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts), bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        And predicate = new And(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(1);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(9);
    }

    @TestTemplate
    public void testUnpartitionedOr() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        Or predicate = new Or(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @TestTemplate
    public void testPartitionedOr() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts), bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(48)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        Or predicate = new Or(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    private SparkScanBuilder scanBuilder() throws Exception {
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)this.tableName));
        return new SparkScanBuilder(spark, table, options);
    }

    private void pushFilters(ScanBuilder scan, Predicate ... predicates) {
        Assertions.assertThat((Object)scan).isInstanceOf(SupportsPushDownV2Filters.class);
        SupportsPushDownV2Filters filterable = (SupportsPushDownV2Filters)scan;
        filterable.pushPredicates(predicates);
    }

    private Expression[] expressions(Expression ... expressions) {
        return expressions;
    }

    private void checkColStatisticsNotReported(SparkScan scan, long expectedRowCount) {
        Statistics stats = scan.estimateStatistics();
        Assertions.assertThat((long)stats.numRows().getAsLong()).isEqualTo(expectedRowCount);
        Map columnStats = stats.columnStats();
        Assertions.assertThat((Map)columnStats).isEmpty();
    }

    private void checkColStatisticsReported(SparkScan scan, long expectedRowCount, Map<String, Long> expectedNDVs) {
        Statistics stats = scan.estimateStatistics();
        Assertions.assertThat((long)stats.numRows().getAsLong()).isEqualTo(expectedRowCount);
        Map columnStats = stats.columnStats();
        if (expectedNDVs.isEmpty()) {
            Assertions.assertThat((boolean)columnStats.values().stream().allMatch(value -> value.distinctCount().isEmpty())).isTrue();
        } else {
            for (Map.Entry<String, Long> entry : expectedNDVs.entrySet()) {
                Assertions.assertThat((long)((ColumnStatistics)columnStats.get(FieldReference.column((String)entry.getKey()))).distinctCount().getAsLong()).isEqualTo((Object)entry.getValue());
            }
        }
    }

    private static LiteralValue<Integer> intLit(int value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.IntegerType);
    }

    private static LiteralValue<Integer> dateLit(int value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.DateType);
    }

    private static LiteralValue<String> stringLit(String value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.StringType);
    }

    private static NamedReference fieldRef(String col) {
        return FieldReference.apply((String)col);
    }

    private static UserDefinedScalarFunc toUDF(BoundFunction function, Expression[] expressions) {
        return new UserDefinedScalarFunc(function.name(), function.canonicalName(), expressions);
    }
}

