/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkStagedScan
extends CatalogTestBase {
    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testTaskSetLoading() throws NoSuchTableException, IOException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", this.tableName);
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(1, "a"), (Object)new SimpleRecord(2, "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should produce 1 snapshot", new Object[0])).hasSize(1);
        try (CloseableIterable fileScanTasks = table.newScan().planFiles();){
            ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
            String setID = UUID.randomUUID().toString();
            taskSetManager.stageTasks(table, setID, (List)ImmutableList.copyOf((Iterable)fileScanTasks));
            Dataset scanDF = spark.read().format("iceberg").option("scan-task-set-id", setID).load(this.tableName);
            scanDF.writeTo(this.tableName).append();
        }
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "a"), (Object)this.row(1, "a"), (Object)this.row(2, "b"), (Object)this.row(2, "b")), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @TestTemplate
    public void testTaskSetPlanning() throws NoSuchTableException, IOException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", this.tableName);
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(1, "a"), (Object)new SimpleRecord(2, "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.coalesce(1).writeTo(this.tableName).append();
        df.coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Should produce 2 snapshot", new Object[0])).hasSize(2);
        try (CloseableIterable fileScanTasks = table.newScan().planFiles();){
            ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
            String setID = UUID.randomUUID().toString();
            ImmutableList tasks = ImmutableList.copyOf((Iterable)fileScanTasks);
            taskSetManager.stageTasks(table, setID, (List)tasks);
            Dataset scanDF = spark.read().format("iceberg").option("scan-task-set-id", setID).option("split-size", ((DataFile)((FileScanTask)tasks.get(0)).file()).fileSizeInBytes()).load(this.tableName);
            ((AbstractIntegerAssert)Assertions.assertThat((int)scanDF.javaRDD().getNumPartitions()).as("Num partitions should match", new Object[0])).isEqualTo(2);
            scanDF = spark.read().format("iceberg").option("scan-task-set-id", setID).option("split-size", Long.MAX_VALUE).load(this.tableName);
            ((AbstractIntegerAssert)Assertions.assertThat((int)scanDF.javaRDD().getNumPartitions()).as("Num partitions should match", new Object[0])).isEqualTo(1);
        }
    }
}

