/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkTable
extends CatalogTestBase {
    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testTableEquality() throws NoSuchTableException {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        TableCatalog catalog = (TableCatalog)catalogManager.catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        SparkTable table1 = (SparkTable)catalog.loadTable(identifier);
        SparkTable table2 = (SparkTable)catalog.loadTable(identifier);
        ((ObjectAssert)Assertions.assertThat((Object)table1).as("References must be different", new Object[0])).isNotSameAs((Object)table2);
        ((ObjectAssert)Assertions.assertThat((Object)table1).as("Tables must be equivalent", new Object[0])).isEqualTo((Object)table2);
    }
}

