/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Files;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class TestTables {
    private static final Map<String, TableMetadata> METADATA = Maps.newHashMap();

    private TestTables() {
    }

    static TestTable create(File temp, String name, Schema schema, PartitionSpec spec) {
        return TestTables.create(temp, name, schema, spec, (Map<String, String>)ImmutableMap.of());
    }

    static TestTable create(File temp, String name, Schema schema, PartitionSpec spec, Map<String, String> properties) {
        TestTableOperations ops = new TestTableOperations(name);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table %s already exists at location: %s", new Object[]{name, temp});
        }
        ops.commit(null, TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)spec, (String)temp.toString(), properties));
        return new TestTable(ops, name);
    }

    static TestTable load(String name) {
        TestTableOperations ops = new TestTableOperations(name);
        if (ops.current() == null) {
            return null;
        }
        return new TestTable(ops, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean drop(String name) {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            return METADATA.remove(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearTables() {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            METADATA.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableMetadata readMetadata(String tableName) {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            return METADATA.get(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void replaceMetadata(String tableName, TableMetadata metadata) {
        Map<String, TableMetadata> map = METADATA;
        synchronized (map) {
            METADATA.put(tableName, metadata);
        }
    }

    static class LocalFileIO
    implements FileIO {
        LocalFileIO() {
        }

        public InputFile newInputFile(String path) {
            return Files.localInput((String)path);
        }

        public OutputFile newOutputFile(String path) {
            return Files.localOutput((File)new File(path));
        }

        public void deleteFile(String path) {
            if (!new File(path).delete()) {
                throw new RuntimeIOException("Failed to delete file: " + path, new Object[0]);
            }
        }
    }

    static class TestTableOperations
    implements TableOperations {
        private final String tableName;
        private TableMetadata current = null;
        private long lastSnapshotId = 0L;
        private int failCommits = 0;

        TestTableOperations(String tableName) {
            this.tableName = tableName;
            this.refresh();
            if (this.current != null) {
                for (Snapshot snap : this.current.snapshots()) {
                    this.lastSnapshotId = Math.max(this.lastSnapshotId, snap.snapshotId());
                }
            } else {
                this.lastSnapshotId = 0L;
            }
        }

        void failCommits(int numFailures) {
            this.failCommits = numFailures;
        }

        public TableMetadata current() {
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TableMetadata refresh() {
            Map<String, TableMetadata> map = METADATA;
            synchronized (map) {
                this.current = METADATA.get(this.tableName);
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(TableMetadata base, TableMetadata metadata) {
            if (base != this.current) {
                throw new CommitFailedException("Cannot commit changes based on stale metadata", new Object[0]);
            }
            Map<String, TableMetadata> map = METADATA;
            synchronized (map) {
                this.refresh();
                if (base == this.current) {
                    if (this.failCommits > 0) {
                        --this.failCommits;
                        throw new CommitFailedException("Injected failure", new Object[0]);
                    }
                } else {
                    throw new CommitFailedException("Commit failed: table was updated at %d", new Object[]{base.lastUpdatedMillis()});
                }
                METADATA.put(this.tableName, metadata);
                this.current = metadata;
            }
        }

        public FileIO io() {
            return new LocalFileIO();
        }

        public LocationProvider locationProvider() {
            Preconditions.checkNotNull((Object)this.current, (Object)"Current metadata should not be null when locationProvider is called");
            return LocationProviders.locationsFor((String)this.current.location(), (Map)this.current.properties());
        }

        public String metadataFileLocation(String fileName) {
            return new File(new File(this.current.location(), "metadata"), fileName).getAbsolutePath();
        }

        public long newSnapshotId() {
            long nextSnapshotId;
            this.lastSnapshotId = nextSnapshotId = this.lastSnapshotId + 1L;
            return nextSnapshotId;
        }
    }

    static class TestTable
    extends BaseTable {
        private final TestTableOperations ops;

        private TestTable(TestTableOperations ops, String name) {
            super((TableOperations)ops, name);
            this.ops = ops;
        }

        public TestTableOperations operations() {
            return this.ops;
        }
    }
}

