/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.TestBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;

public class TestAggregatePushDown
extends CatalogTestBase {
    @BeforeAll
    public static void startMetastoreAndSpark() {
        TestBase.metastore = new TestHiveMetastore();
        metastore.start();
        TestBase.hiveConf = metastore.hiveConf();
        TestBase.spark.close();
        TestBase.spark = SparkSession.builder().master("local[2]").config("spark.sql.iceberg.aggregate_pushdown", "true").enableHiveSupport().getOrCreate();
        TestBase.catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
        try {
            catalog.createNamespace(Namespace.of((String[])new String[]{"default"}));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testDifferentDataTypesAggregatePushDownInPartitionedTable() {
        this.testDifferentDataTypesAggregatePushDown(true);
    }

    @TestTemplate
    public void testDifferentDataTypesAggregatePushDownInNonPartitionedTable() {
        this.testDifferentDataTypesAggregatePushDown(false);
    }

    private void testDifferentDataTypesAggregatePushDown(boolean hasPartitionCol) {
        String createTable = hasPartitionCol ? "CREATE TABLE %s (id LONG, int_data INT, boolean_data BOOLEAN, float_data FLOAT, double_data DOUBLE, decimal_data DECIMAL(14, 2), binary_data binary) USING iceberg PARTITIONED BY (id)" : "CREATE TABLE %s (id LONG, int_data INT, boolean_data BOOLEAN, float_data FLOAT, double_data DOUBLE, decimal_data DECIMAL(14, 2), binary_data binary) USING iceberg";
        this.sql(createTable, this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, null, false, null, null, 11.11, X'1111'), (1, null, true, 2.222, 2.222222, 22.22, X'2222'), (2, 33, false, 3.333, 3.333333, 33.33, X'3333'), (2, 44, true, null, 4.444444, 44.44, X'4444'), (3, 55, false, 5.555, 5.555555, 55.55, X'5555'), (3, null, true, null, 6.666666, 66.66, null) ", this.tableName);
        String select = "SELECT count(*), max(id), min(id), count(id), max(int_data), min(int_data), count(int_data), max(boolean_data), min(boolean_data), count(boolean_data), max(float_data), min(float_data), count(float_data), max(double_data), min(double_data), count(double_data), max(decimal_data), min(decimal_data), count(decimal_data), max(binary_data), min(binary_data), count(binary_data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(*)") && explainString.contains("max(id)") && explainString.contains("min(id)") && explainString.contains("count(id)") && explainString.contains("max(int_data)") && explainString.contains("min(int_data)") && explainString.contains("count(int_data)") && explainString.contains("max(boolean_data)") && explainString.contains("min(boolean_data)") && explainString.contains("count(boolean_data)") && explainString.contains("max(float_data)") && explainString.contains("min(float_data)") && explainString.contains("count(float_data)") && explainString.contains("max(double_data)") && explainString.contains("min(double_data)") && explainString.contains("count(double_data)") && explainString.contains("max(decimal_data)") && explainString.contains("min(decimal_data)") && explainString.contains("count(decimal_data)") && explainString.contains("max(binary_data)") && explainString.contains("min(binary_data)") && explainString.contains("count(binary_data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, 3L, 1L, 6L, 55, 33, 3L, true, false, 6L, Float.valueOf(5.555f), Float.valueOf(2.222f), 3L, 6.666666, 2.222222, 5L, new BigDecimal("66.66"), new BigDecimal("11.11"), 6L, new byte[]{85, 85}, new byte[]{17, 17}, 5L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @TestTemplate
    public void testDateAndTimestampWithPartition() {
        this.sql("CREATE TABLE %s (id bigint, data string, d date, ts timestamp) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, '1', date('2021-11-10'), null),(1, '2', date('2021-11-11'), timestamp('2021-11-11 22:22:22')), (2, '3', date('2021-11-12'), timestamp('2021-11-12 22:22:22')), (2, '4', date('2021-11-13'), timestamp('2021-11-13 22:22:22')), (3, '5', null, timestamp('2021-11-14 22:22:22')), (3, '6', date('2021-11-14'), null)", this.tableName);
        String select = "SELECT max(d), min(d), count(d), max(ts), min(ts), count(ts) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(d)") && explainString.contains("min(d)") && explainString.contains("count(d)") && explainString.contains("max(ts)") && explainString.contains("min(ts)") && explainString.contains("count(ts)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{Date.valueOf("2021-11-14"), Date.valueOf("2021-11-10"), 5L, Timestamp.valueOf("2021-11-14 22:22:22.0"), Timestamp.valueOf("2021-11-11 22:22:22.0"), 4L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @TestTemplate
    public void testAggregateNotPushDownIfOneCantPushDown() {
        this.sql("CREATE TABLE %s (id LONG, data DOUBLE) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        String select = "SELECT COUNT(data), SUM(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, 23331.0});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @TestTemplate
    public void testAggregatePushDownWithMetricsMode() {
        this.sql("CREATE TABLE %s (id LONG, data DOUBLE) USING iceberg", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "none");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.column.id", "counts");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.column.data", "none");
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666)", this.tableName);
        String select1 = "SELECT COUNT(data) FROM %s";
        List<Object[]> explain1 = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString1.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual1 = this.sql(select1, this.tableName);
        ArrayList expected1 = Lists.newArrayList();
        expected1.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected1, actual1);
        String select2 = "SELECT COUNT(id) FROM %s";
        List<Object[]> explain2 = this.sql("EXPLAIN " + select2, this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString2.contains("count(id)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual2 = this.sql(select2, this.tableName);
        ArrayList expected2 = Lists.newArrayList();
        expected2.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected2, actual2);
        String select3 = "SELECT COUNT(id), MAX(id) FROM %s";
        explainContainsPushDownAggregates = false;
        List<Object[]> explain3 = this.sql("EXPLAIN " + select3, this.tableName);
        String explainString3 = explain3.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString3.contains("count(id)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual3 = this.sql(select3, this.tableName);
        ArrayList expected3 = Lists.newArrayList();
        expected3.add(new Object[]{6L, 3L});
        this.assertEquals("expected and actual should equal", expected3, actual3);
    }

    @TestTemplate
    public void testAggregateNotPushDownForStringType() {
        this.sql("CREATE TABLE %s (id LONG, data STRING) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, '1111'), (1, '2222'), (2, '3333'), (2, '4444'), (3, '5555'), (3, '6666') ", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "truncate(16)");
        String select1 = "SELECT MAX(id), MAX(data) FROM %s";
        List<Object[]> explain1 = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString1.contains("max(id)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual1 = this.sql(select1, this.tableName);
        ArrayList expected1 = Lists.newArrayList();
        expected1.add(new Object[]{3L, "6666"});
        this.assertEquals("expected and actual should equal", expected1, actual1);
        String select2 = "SELECT COUNT(data) FROM %s";
        List<Object[]> explain2 = this.sql("EXPLAIN " + select2, this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString2.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual2 = this.sql(select2, this.tableName);
        ArrayList expected2 = Lists.newArrayList();
        expected2.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected2, actual2);
        explainContainsPushDownAggregates = false;
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "full");
        String select3 = "SELECT count(data), max(data) FROM %s";
        List<Object[]> explain3 = this.sql("EXPLAIN " + select3, this.tableName);
        String explainString3 = explain3.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString3.contains("count(data)") && explainString3.contains("max(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual3 = this.sql(select3, this.tableName);
        ArrayList expected3 = Lists.newArrayList();
        expected3.add(new Object[]{6L, "6666"});
        this.assertEquals("expected and actual should equal", expected3, actual3);
    }

    @TestTemplate
    public void testAggregatePushDownWithDataFilter() {
        this.testAggregatePushDownWithFilter(false);
    }

    @TestTemplate
    public void testAggregatePushDownWithPartitionFilter() {
        this.testAggregatePushDownWithFilter(true);
    }

    private void testAggregatePushDownWithFilter(boolean partitionFilerOnly) {
        String createTable = !partitionFilerOnly ? "CREATE TABLE %s (id LONG, data INT) USING iceberg" : "CREATE TABLE %s (id LONG, data INT) USING iceberg PARTITIONED BY (id)";
        this.sql(createTable, this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 11), (1, 22), (2, 33), (2, 44), (3, 55), (3, 66) ", this.tableName);
        String select = "SELECT MIN(data) FROM %s WHERE id > 1";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("min(data)")) {
            explainContainsPushDownAggregates = true;
        }
        if (!partitionFilerOnly) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        }
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{33});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @TestTemplate
    public void testAggregateWithComplexType() {
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\")),(2, named_struct(\"c1\", 2, \"c2\", \"v2\")), (3, null)", this.tableName);
        String select1 = "SELECT count(complex), count(id) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(complex)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("count not pushed down for complex types", new Object[0])).isFalse();
        List<Object[]> actual = this.sql(select1, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{2L, 3L});
        this.assertEquals("count not push down", actual, expected);
        String select2 = "SELECT max(complex) FROM %s";
        explain = this.sql("EXPLAIN " + select2, this.tableName);
        explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        explainContainsPushDownAggregates = false;
        if (explainString.contains("max(complex)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("max not pushed down for complex types", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testAggregationPushdownStructInteger() {
        this.sql("CREATE TABLE %s (id BIGINT, struct_with_int STRUCT<c1:BIGINT>) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", NULL))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, named_struct(\"c1\", 3))", this.tableName);
        String query = "SELECT COUNT(%s), MAX(%s), MIN(%s) FROM %s";
        String aggField = "struct_with_int.c1";
        this.assertAggregates(this.sql(query, aggField, aggField, aggField, this.tableName), 2L, 3L, 2L);
        this.assertExplainContains(this.sql("EXPLAIN " + query, aggField, aggField, aggField, this.tableName), "count(struct_with_int.c1)", "max(struct_with_int.c1)", "min(struct_with_int.c1)");
    }

    @TestTemplate
    public void testAggregationPushdownNestedStruct() {
        this.sql("CREATE TABLE %s (id BIGINT, struct_with_int STRUCT<c1:STRUCT<c2:STRUCT<c3:STRUCT<c4:BIGINT>>>>) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", named_struct(\"c2\", named_struct(\"c3\", named_struct(\"c4\", NULL)))))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", named_struct(\"c2\", named_struct(\"c3\", named_struct(\"c4\", 2)))))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, named_struct(\"c1\", named_struct(\"c2\", named_struct(\"c3\", named_struct(\"c4\", 3)))))", this.tableName);
        String query = "SELECT COUNT(%s), MAX(%s), MIN(%s) FROM %s";
        String aggField = "struct_with_int.c1.c2.c3.c4";
        this.assertAggregates(this.sql(query, aggField, aggField, aggField, this.tableName), 2L, 3L, 2L);
        this.assertExplainContains(this.sql("EXPLAIN " + query, aggField, aggField, aggField, this.tableName), "count(struct_with_int.c1.c2.c3.c4)", "max(struct_with_int.c1.c2.c3.c4)", "min(struct_with_int.c1.c2.c3.c4)");
    }

    @TestTemplate
    public void testAggregationPushdownStructTimestamp() {
        this.sql("CREATE TABLE %s (id BIGINT, struct_with_ts STRUCT<c1:TIMESTAMP>) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", NULL))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", timestamp('2023-01-30T22:22:22Z')))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (3, named_struct(\"c1\", timestamp('2023-01-30T22:23:23Z')))", this.tableName);
        String query = "SELECT COUNT(%s), MAX(%s), MIN(%s) FROM %s";
        String aggField = "struct_with_ts.c1";
        this.assertAggregates(this.sql(query, aggField, aggField, aggField, this.tableName), 2L, new Timestamp(1675117403000L), new Timestamp(1675117342000L));
        this.assertExplainContains(this.sql("EXPLAIN " + query, aggField, aggField, aggField, this.tableName), "count(struct_with_ts.c1)", "max(struct_with_ts.c1)", "min(struct_with_ts.c1)");
    }

    @TestTemplate
    public void testAggregationPushdownOnBucketedColumn() {
        this.sql("CREATE TABLE %s (id BIGINT, struct_with_int STRUCT<c1:INT>) USING iceberg PARTITIONED BY (bucket(8, id))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", NULL))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (null, named_struct(\"c1\", 2))", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 3))", this.tableName);
        String query = "SELECT COUNT(%s), MAX(%s), MIN(%s) FROM %s";
        String aggField = "id";
        this.assertAggregates(this.sql(query, aggField, aggField, aggField, this.tableName), 2L, 2L, 1L);
        this.assertExplainContains(this.sql("EXPLAIN " + query, aggField, aggField, aggField, this.tableName), "count(id)", "max(id)", "min(id)");
    }

    private void assertAggregates(List<Object[]> actual, Object expectedCount, Object expectedMax, Object expectedMin) {
        Object actualCount = actual.get(0)[0];
        Object actualMax = actual.get(0)[1];
        Object actualMin = actual.get(0)[2];
        ((ObjectAssert)Assertions.assertThat((Object)actualCount).as("Expected and actual count should equal", new Object[0])).isEqualTo(expectedCount);
        ((ObjectAssert)Assertions.assertThat((Object)actualMax).as("Expected and actual max should equal", new Object[0])).isEqualTo(expectedMax);
        ((ObjectAssert)Assertions.assertThat((Object)actualMin).as("Expected and actual min should equal", new Object[0])).isEqualTo(expectedMin);
    }

    private void assertExplainContains(List<Object[]> explain, String ... expectedFragments) {
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        Arrays.stream(expectedFragments).forEach(fragment -> ((AbstractStringAssert)Assertions.assertThat((String)explainString).as("Expected to find plan fragment in explain plan", new Object[0])).contains(new CharSequence[]{fragment}));
    }

    @TestTemplate
    public void testAggregatePushDownInDeleteCopyOnWrite() {
        this.sql("CREATE TABLE %s (id LONG, data INT) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        this.sql("DELETE FROM %s WHERE data = 1111", this.tableName);
        String select = "SELECT max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") && explainString.contains("min(data)") && explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("min/max/count pushed down for deleted", new Object[0])).isTrue();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6666, 2222, 5L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @TestTemplate
    public void testAggregatePushDownForTimeTravel() {
        this.sql("CREATE TABLE %s (id LONG, data INT) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        List<Object[]> expected1 = this.sql("SELECT count(id) FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 7777), (5, 8888)", this.tableName);
        List<Object[]> expected2 = this.sql("SELECT count(id) FROM %s", this.tableName);
        List<Object[]> explain1 = this.sql("EXPLAIN SELECT count(id) FROM %s VERSION AS OF %s", this.tableName, snapshotId);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates1 = false;
        if (explainString1.contains("count(id)")) {
            explainContainsPushDownAggregates1 = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates1).as("count pushed down", new Object[0])).isTrue();
        List<Object[]> actual1 = this.sql("SELECT count(id) FROM %s VERSION AS OF %s", this.tableName, snapshotId);
        this.assertEquals("count push down", expected1, actual1);
        List<Object[]> explain2 = this.sql("EXPLAIN SELECT count(id) FROM %s", this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates2 = false;
        if (explainString2.contains("count(id)")) {
            explainContainsPushDownAggregates2 = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates2).as("count pushed down", new Object[0])).isTrue();
        List<Object[]> actual2 = this.sql("SELECT count(id) FROM %s", this.tableName);
        this.assertEquals("count push down", expected2, actual2);
    }

    @TestTemplate
    public void testAllNull() {
        this.sql("CREATE TABLE %s (id int, data int) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, null),(1, null), (2, null), (2, null), (3, null), (3, null)", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") && explainString.contains("min(data)") && explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, null, null, 0L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @TestTemplate
    public void testAllNaN() {
        this.sql("CREATE TABLE %s (id int, data float) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('nan')),(1, float('nan')), (2, float('nan')), (2, float('nan')), (3, float('nan')), (3, float('nan'))", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") || explainString.contains("min(data)") || explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NaN), Float.valueOf(Float.NaN), 6L});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @TestTemplate
    public void testNaN() {
        this.sql("CREATE TABLE %s (id int, data float) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('nan')),(1, float('nan')), (2, 2), (2, float('nan')), (3, float('nan')), (3, 1)", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") || explainString.contains("min(data)") || explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should not contain the pushed down aggregates", new Object[0])).isFalse();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NaN), Float.valueOf(1.0f), 6L});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @TestTemplate
    public void testInfinity() {
        this.sql("CREATE TABLE %s (id int, data1 float, data2 double, data3 double) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('-infinity'), double('infinity'), 1.23), (1, float('-infinity'), double('infinity'), -1.23), (1, float('-infinity'), double('infinity'), double('infinity')), (1, float('-infinity'), double('infinity'), 2.23), (1, float('-infinity'), double('infinity'), double('-infinity')), (1, float('-infinity'), double('infinity'), -2.23)", this.tableName);
        String select = "SELECT count(*), max(data1), min(data1), count(data1), max(data2), min(data2), count(data2), max(data3), min(data3), count(data3) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data1)") && explainString.contains("min(data1)") && explainString.contains("count(data1)") && explainString.contains("max(data2)") && explainString.contains("min(data2)") && explainString.contains("count(data2)") && explainString.contains("max(data3)") && explainString.contains("min(data3)") && explainString.contains("count(data3)")) {
            explainContainsPushDownAggregates = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)explainContainsPushDownAggregates).as("explain should contain the pushed down aggregates", new Object[0])).isTrue();
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), 6L, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 6L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 6L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @TestTemplate
    public void testAggregatePushDownForIncrementalScan() {
        this.sql("CREATE TABLE %s (id LONG, data INT) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        long snapshotId1 = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        this.sql("INSERT INTO %s VALUES (4, 7777), (5, 8888)", this.tableName);
        long snapshotId2 = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        this.sql("INSERT INTO %s VALUES (6, -7777), (7, 8888)", this.tableName);
        long snapshotId3 = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        this.sql("INSERT INTO %s VALUES (8, 7777), (9, 9999)", this.tableName);
        Dataset pushdownDs = spark.read().format("iceberg").option("start-snapshot-id", snapshotId2).option("end-snapshot-id", snapshotId3).load(this.tableName).agg(functions.min((String)"data"), new Column[]{functions.max((String)"data"), functions.count((String)"data")});
        String explain1 = pushdownDs.queryExecution().explainString(ExplainMode.fromString((String)"simple"));
        Assertions.assertThat((String)explain1).contains(new CharSequence[]{"LocalTableScan", "min(data)", "max(data)", "count(data)"});
        ArrayList expected1 = Lists.newArrayList();
        expected1.add(new Object[]{-7777, 8888, 2L});
        this.assertEquals("min/max/count push down", expected1, this.rowsToJava(pushdownDs.collectAsList()));
        Dataset unboundedPushdownDs = spark.read().format("iceberg").option("start-snapshot-id", snapshotId1).load(this.tableName).agg(functions.min((String)"data"), new Column[]{functions.max((String)"data"), functions.count((String)"data")});
        String explain2 = unboundedPushdownDs.queryExecution().explainString(ExplainMode.fromString((String)"simple"));
        Assertions.assertThat((String)explain2).contains(new CharSequence[]{"LocalTableScan", "min(data)", "max(data)", "count(data)"});
        ArrayList expected2 = Lists.newArrayList();
        expected2.add(new Object[]{-7777, 9999, 6L});
        this.assertEquals("min/max/count push down", expected2, this.rowsToJava(unboundedPushdownDs.collectAsList()));
    }
}

