/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestAlterTable
extends CatalogTestBase {
    private final TableIdentifier renamedIdent = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"table2");

    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s2", this.tableName);
    }

    @TestTemplate
    public void testAddColumnNotNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s ADD COLUMN c3 INT NOT NULL", this.tableName)).isInstanceOf(SparkException.class)).hasMessage("Unsupported table change: Incompatible change: cannot add required column: c3");
    }

    @TestTemplate
    public void testAddColumn() {
        this.sql("ALTER TABLE %s ADD COLUMN point struct<x: double NOT NULL, y: double NOT NULL> AFTER id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
        this.sql("ALTER TABLE %s ADD COLUMN point.z double COMMENT 'May be null' FIRST", this.tableName);
        Types.StructType expectedSchema2 = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"z", (Type)Types.DoubleType.get(), (String)"May be null"), Types.NestedField.required((int)4, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.DoubleType.get())})), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema2);
    }

    @TestTemplate
    public void testAddColumnWithArray() {
        this.sql("ALTER TABLE %s ADD COLUMN data2 array<struct<a:INT,b:INT,c:int>>", this.tableName);
        this.sql("ALTER TABLE %s ADD COLUMN data2.element.d int", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data2", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)7, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"d", (Type)Types.IntegerType.get())})))});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAddColumnWithMap() {
        this.sql("ALTER TABLE %s ADD COLUMN data2 map<struct<x:INT>, struct<a:INT,b:INT>>", this.tableName);
        this.sql("ALTER TABLE %s ADD COLUMN data2.value.c int", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data2", (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"x", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)9, (String)"c", (Type)Types.IntegerType.get())})))});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s ADD COLUMN data2.key.y int", this.tableName)).isInstanceOf(SparkException.class)).hasMessageStartingWith("Unsupported table change: Cannot add fields to map keys:");
    }

    @TestTemplate
    public void testDropColumn() {
        this.sql("ALTER TABLE %s DROP COLUMN data", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testRenameColumn() {
        this.sql("ALTER TABLE %s RENAME COLUMN id TO row_id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAlterColumnComment() {
        this.sql("ALTER TABLE %s ALTER COLUMN id COMMENT 'Record id'", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get(), (String)"Record id"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAlterColumnType() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count TYPE bigint", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"count", (Type)Types.LongType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAlterColumnDropNotNull() {
        this.sql("ALTER TABLE %s ALTER COLUMN id DROP NOT NULL", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAlterColumnSetNotNull() {
        this.sql("ALTER TABLE %s ALTER COLUMN id SET NOT NULL", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s ALTER COLUMN data SET NOT NULL", this.tableName)).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Cannot change nullable column to non-nullable: data");
    }

    @TestTemplate
    public void testAlterColumnPositionAfter() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count AFTER id", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testAlterColumnPositionFirst() {
        this.sql("ALTER TABLE %s ADD COLUMN count int", this.tableName);
        this.sql("ALTER TABLE %s ALTER COLUMN count FIRST", this.tableName);
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)this.validationCatalog.loadTable(this.tableIdent).schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema);
    }

    @TestTemplate
    public void testTableRename() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)((String)this.catalogConfig.get("type"))).as("need to fix https://github.com/apache/iceberg/issues/11154 before enabling this for the REST catalog", new Object[0])).isNotEqualTo((Object)"rest");
        ((ObjectAssert)Assumptions.assumeThat((Object)this.validationCatalog).as("Hadoop catalog does not support rename", new Object[0])).isNotInstanceOf(HadoopCatalog.class);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Initial name should exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.renamedIdent)).as("New name should not exist", new Object[0])).isFalse();
        this.sql("ALTER TABLE %s RENAME TO %s2", this.tableName, this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Initial name should not exist", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.renamedIdent)).as("New name should exist", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testSetTableProperties() {
        String[] reservedProperties;
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('prop'='value')", this.tableName);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)this.validationCatalog.loadTable(this.tableIdent).properties().get("prop"))).as("Should have the new table property", new Object[0])).isEqualTo("value");
        this.sql("ALTER TABLE %s UNSET TBLPROPERTIES ('prop')", this.tableName);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)this.validationCatalog.loadTable(this.tableIdent).properties().get("prop"))).as("Should not have the removed table property", new Object[0])).isNull();
        for (String reservedProp : reservedProperties = new String[]{"sort-order", "identifier-fields"}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='value')", this.tableName, reservedProp)).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Cannot specify the '%s' because it's a reserved table property", new Object[]{reservedProp});
        }
    }
}

