/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestFilterPushDown
extends TestBaseWithCatalog {
    @Parameter(index=3)
    private PlanningMode planningMode;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, planningMode = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), PlanningMode.LOCAL}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), PlanningMode.DISTRIBUTED}};
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS tmp_view", new Object[0]);
    }

    @TestTemplate
    public void testFilterPushdownWithDecimalValues() {
        this.sql("CREATE TABLE %s (id INT, salary DECIMAL(10, 2), dep STRING)USING iceberg PARTITIONED BY (dep)", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100.01, 'd1')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 100.05, 'd1')", this.tableName);
        this.checkFilters("dep = 'd1' AND salary > 100.03", "isnotnull(salary) AND (salary > 100.03)", "dep IS NOT NULL, salary IS NOT NULL, dep = 'd1', salary > 100.03", (List<Object[]>)ImmutableList.of((Object)this.row(2, new BigDecimal("100.05"), "d1")));
    }

    @TestTemplate
    public void testFilterPushdownWithIdentityTransform() {
        this.sql("CREATE TABLE %s (id INT, salary INT, dep STRING)USING iceberg PARTITIONED BY (dep)", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, 'd1')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, 'd2')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, 'd3')", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 400, 'd4')", this.tableName);
        this.sql("INSERT INTO %s VALUES (5, 500, 'd5')", this.tableName);
        this.sql("INSERT INTO %s VALUES (6, 600, null)", this.tableName);
        this.checkOnlyIcebergFilters("dep IS NULL", "dep IS NULL", (List<Object[]>)ImmutableList.of((Object)this.row(6, 600, null)));
        this.checkOnlyIcebergFilters("dep IS NOT NULL", "dep IS NOT NULL", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2"), (Object)this.row(3, 300, "d3"), (Object)this.row(4, 400, "d4"), (Object)this.row(5, 500, "d5")));
        this.checkOnlyIcebergFilters("dep = 'd3'", "dep IS NOT NULL, dep = 'd3'", (List<Object[]>)ImmutableList.of((Object)this.row(3, 300, "d3")));
        this.checkOnlyIcebergFilters("dep > 'd3'", "dep IS NOT NULL, dep > 'd3'", (List<Object[]>)ImmutableList.of((Object)this.row(4, 400, "d4"), (Object)this.row(5, 500, "d5")));
        this.checkOnlyIcebergFilters("dep >= 'd5'", "dep IS NOT NULL, dep >= 'd5'", (List<Object[]>)ImmutableList.of((Object)this.row(5, 500, "d5")));
        this.checkOnlyIcebergFilters("dep < 'd2'", "dep IS NOT NULL, dep < 'd2'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkOnlyIcebergFilters("dep <= 'd2'", "dep IS NOT NULL, dep <= 'd2'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2")));
        this.checkOnlyIcebergFilters("dep <=> 'd3'", "dep = 'd3'", (List<Object[]>)ImmutableList.of((Object)this.row(3, 300, "d3")));
        this.checkOnlyIcebergFilters("dep IN (null, 'd1')", "dep IN ('d1')", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkOnlyIcebergFilters("dep NOT IN ('d2', 'd4')", "(dep IS NOT NULL AND dep NOT IN ('d2', 'd4'))", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(3, 300, "d3"), (Object)this.row(5, 500, "d5")));
        this.checkOnlyIcebergFilters("dep = 'd1' AND dep IS NOT NULL", "dep = 'd1', dep IS NOT NULL", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkOnlyIcebergFilters("dep = 'd1' OR dep = 'd2' OR dep = 'd3'", "((dep = 'd1' OR dep = 'd2') OR dep = 'd3')", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2"), (Object)this.row(3, 300, "d3")));
        this.checkFilters("dep = 'd1' AND id = 1", "isnotnull(id) AND (id = 1)", "dep IS NOT NULL, id IS NOT NULL, dep = 'd1', id = 1", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkFilters("dep = 'd2' OR id = 1", "(dep = d2) OR (id = 1)", "(dep = 'd2' OR id = 1)", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2")));
        this.checkFilters("dep LIKE 'd1%' AND id = 1", "isnotnull(id) AND (id = 1)", "dep IS NOT NULL, id IS NOT NULL, dep LIKE 'd1%', id = 1", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkFilters("dep NOT LIKE 'd5%' AND (id = 1 OR id = 5)", "(id = 1) OR (id = 5)", "dep IS NOT NULL, NOT (dep LIKE 'd5%'), (id = 1 OR id = 5)", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        this.checkFilters("dep LIKE '%d5' AND id IN (1, 5)", "EndsWith(dep, d5) AND id IN (1,5)", "dep IS NOT NULL, id IN (1, 5)", (List<Object[]>)ImmutableList.of((Object)this.row(5, 500, "d5")));
    }

    @TestTemplate
    public void testFilterPushdownWithHoursTransform() {
        this.sql("CREATE TABLE %s (id INT, price INT, t TIMESTAMP)USING iceberg PARTITIONED BY (hours(t))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, TIMESTAMP '2021-06-30T01:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2021-06-30T02:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, null)", this.tableName);
        this.withDefaultTimeZone("UTC", () -> {
            this.checkOnlyIcebergFilters("t IS NULL", "t IS NULL", (List<Object[]>)ImmutableList.of((Object)this.row(3, 300, null)));
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2021-06-30T02:00:00.000Z'", "t IS NOT NULL, t < 1625018400000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.0Z"))));
            this.checkFilters("t < TIMESTAMP '2021-06-30T01:00:00.001Z'", "t < 2021-06-30 01:00:00.001", "t IS NOT NULL, t < 1625014800001000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.0Z"))));
            this.checkFilters("t <= TIMESTAMP '2021-06-30T01:00:00.000Z'", "t <= 2021-06-30 01:00:00", "t IS NOT NULL, t <= 1625014800000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.0Z"))));
        });
    }

    @TestTemplate
    public void testFilterPushdownWithDaysTransform() {
        this.sql("CREATE TABLE %s (id INT, price INT, t TIMESTAMP)USING iceberg PARTITIONED BY (days(t))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, TIMESTAMP '2021-06-15T01:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2021-06-30T02:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, TIMESTAMP '2021-07-15T10:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 400, null)", this.tableName);
        this.withDefaultTimeZone("UTC", () -> {
            this.checkOnlyIcebergFilters("t IS NULL", "t IS NULL", (List<Object[]>)ImmutableList.of((Object)this.row(4, 400, null)));
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2021-07-05T00:00:00.000Z'", "t IS NOT NULL, t < 1625443200000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-15T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
            this.checkFilters("t < TIMESTAMP '2021-06-30T03:00:00.000Z'", "t < 2021-06-30 03:00:00", "t IS NOT NULL, t < 1625022000000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-15T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
        });
    }

    @TestTemplate
    public void testFilterPushdownWithMonthsTransform() {
        this.sql("CREATE TABLE %s (id INT, price INT, t TIMESTAMP)USING iceberg PARTITIONED BY (months(t))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, TIMESTAMP '2021-06-30T01:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2021-06-30T02:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, TIMESTAMP '2021-07-15T10:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 400, null)", this.tableName);
        this.withDefaultTimeZone("UTC", () -> {
            this.checkOnlyIcebergFilters("t IS NULL", "t IS NULL", (List<Object[]>)ImmutableList.of((Object)this.row(4, 400, null)));
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2021-07-01T00:00:00.000Z'", "t IS NOT NULL, t < 1625097600000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
            this.checkFilters("t < TIMESTAMP '2021-06-30T03:00:00.000Z'", "t < 2021-06-30 03:00:00", "t IS NOT NULL, t < 1625022000000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
        });
    }

    @TestTemplate
    public void testFilterPushdownWithYearsTransform() {
        this.sql("CREATE TABLE %s (id INT, price INT, t TIMESTAMP)USING iceberg PARTITIONED BY (years(t))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, TIMESTAMP '2021-06-30T01:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2021-06-30T02:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2022-09-25T02:00:00.000Z')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, null)", this.tableName);
        this.withDefaultTimeZone("UTC", () -> {
            this.checkOnlyIcebergFilters("t IS NULL", "t IS NULL", (List<Object[]>)ImmutableList.of((Object)this.row(3, 300, null)));
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2022-01-01T00:00:00.000Z'", "t IS NOT NULL, t < 1640995200000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
            this.checkFilters("t < TIMESTAMP '2021-06-30T03:00:00.000Z'", "t < 2021-06-30 03:00:00", "t IS NOT NULL, t < 1625022000000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.000Z")), (Object)this.row(2, 200, this.timestamp("2021-06-30T02:00:00.000Z"))));
        });
    }

    @TestTemplate
    public void testFilterPushdownWithBucketTransform() {
        this.sql("CREATE TABLE %s (id INT, salary INT, dep STRING)USING iceberg PARTITIONED BY (dep, bucket(8, id))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, 'd1')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, 'd2')", this.tableName);
        this.checkFilters("dep = 'd1' AND id = 1", "id = 1", "dep IS NOT NULL, id IS NOT NULL, dep = 'd1'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
    }

    @TestTemplate
    public void testFilterPushdownWithTruncateTransform() {
        this.sql("CREATE TABLE %s (id INT, salary INT, dep STRING)USING iceberg PARTITIONED BY (truncate(1, dep))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, 'd1')", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, 'd2')", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, 'a3')", this.tableName);
        this.checkOnlyIcebergFilters("dep LIKE 'd%'", "dep IS NOT NULL, dep LIKE 'd%'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2")));
        this.checkFilters("dep = 'd1'", "dep = d1", "dep IS NOT NULL", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
    }

    @TestTemplate
    public void testFilterPushdownWithSpecEvolutionAndIdentityTransforms() {
        this.sql("CREATE TABLE %s (id INT, salary INT, dep STRING, sub_dep STRING)USING iceberg PARTITIONED BY (dep)", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, 'd1', 'sd1')", this.tableName);
        this.checkOnlyIcebergFilters("dep = 'd1'", "dep IS NOT NULL, dep = 'd1'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1", "sd1")));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().addField("sub_dep").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, 'd2', 'sd2')", this.tableName);
        this.checkOnlyIcebergFilters("dep = 'd1'", "dep IS NOT NULL, dep = 'd1'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1", "sd1")));
        table.updateSpec().removeField("sub_dep").removeField("dep").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, 300, 'd3', 'sd3')", this.tableName);
        this.checkFilters("dep = 'd1'", "isnotnull(dep) AND (dep = d1)", "dep IS NOT NULL, dep = 'd1'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1", "sd1")));
    }

    @TestTemplate
    public void testFilterPushdownWithSpecEvolutionAndTruncateTransform() {
        this.sql("CREATE TABLE %s (id INT, salary INT, dep STRING)USING iceberg PARTITIONED BY (truncate(2, dep))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100, 'd1')", this.tableName);
        this.checkOnlyIcebergFilters("dep LIKE 'd1%'", "dep IS NOT NULL, dep LIKE 'd1%'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateSpec().removeField((Term)Expressions.truncate((String)"dep", (int)2)).addField((Term)Expressions.truncate((String)"dep", (int)1)).commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, 200, 'd2')", this.tableName);
        this.checkOnlyIcebergFilters("dep LIKE 'd%'", "dep IS NOT NULL, dep LIKE 'd%'", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1"), (Object)this.row(2, 200, "d2")));
        this.checkFilters("dep LIKE 'd1%' AND id = 1", "(isnotnull(id) AND StartsWith(dep, d1)) AND (id = 1)", "dep IS NOT NULL, id IS NOT NULL, dep LIKE 'd1%', id = 1", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, "d1")));
    }

    @TestTemplate
    public void testFilterPushdownWithSpecEvolutionAndTimeTransforms() {
        this.sql("CREATE TABLE %s (id INT, price INT, t TIMESTAMP)USING iceberg PARTITIONED BY (hours(t))", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.withDefaultTimeZone("UTC", () -> {
            this.sql("INSERT INTO %s VALUES (1, 100, TIMESTAMP '2021-06-30T01:00:00.000Z')", this.tableName);
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2021-07-01T00:00:00.000Z'", "t IS NOT NULL, t < 1625097600000000", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100, this.timestamp("2021-06-30T01:00:00.000Z"))));
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            table.updateSpec().removeField((Term)Expressions.hour((String)"t")).addField((Term)Expressions.month((String)"t")).commit();
            this.sql("REFRESH TABLE %s", this.tableName);
            this.sql("INSERT INTO %s VALUES (2, 200, TIMESTAMP '2021-05-30T01:00:00.000Z')", this.tableName);
            this.checkOnlyIcebergFilters("t < TIMESTAMP '2021-06-01T00:00:00.000Z'", "t IS NOT NULL, t < 1622505600000000", (List<Object[]>)ImmutableList.of((Object)this.row(2, 200, this.timestamp("2021-05-30T01:00:00.000Z"))));
        });
    }

    @TestTemplate
    public void testFilterPushdownWithSpecialFloatingPointPartitionValues() {
        this.sql("CREATE TABLE %s (id INT, salary DOUBLE)USING iceberg PARTITIONED BY (salary)", this.tableName);
        this.configurePlanningMode(this.planningMode);
        this.sql("INSERT INTO %s VALUES (1, 100.5)", this.tableName);
        this.sql("INSERT INTO %s VALUES (2, double('NaN'))", this.tableName);
        this.sql("INSERT INTO %s VALUES (3, double('infinity'))", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, double('-infinity'))", this.tableName);
        this.checkOnlyIcebergFilters("salary = 100.5", "salary IS NOT NULL, salary = 100.5", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100.5)));
        this.checkOnlyIcebergFilters("salary = double('NaN')", "salary IS NOT NULL, is_nan(salary)", (List<Object[]>)ImmutableList.of((Object)this.row(2, Double.NaN)));
        this.checkOnlyIcebergFilters("salary != double('NaN')", "salary IS NOT NULL, NOT (is_nan(salary))", (List<Object[]>)ImmutableList.of((Object)this.row(1, 100.5), (Object)this.row(3, Double.POSITIVE_INFINITY), (Object)this.row(4, Double.NEGATIVE_INFINITY)));
        this.checkOnlyIcebergFilters("salary = double('infinity')", "salary IS NOT NULL, salary = Infinity", (List<Object[]>)ImmutableList.of((Object)this.row(3, Double.POSITIVE_INFINITY)));
        this.checkOnlyIcebergFilters("salary = double('-infinity')", "salary IS NOT NULL, salary = -Infinity", (List<Object[]>)ImmutableList.of((Object)this.row(4, Double.NEGATIVE_INFINITY)));
    }

    private void checkOnlyIcebergFilters(String predicate, String icebergFilters, List<Object[]> expectedRows) {
        this.checkFilters(predicate, null, icebergFilters, expectedRows);
    }

    private void checkFilters(String predicate, String sparkFilter, String icebergFilters, List<Object[]> expectedRows) {
        TestBase.Action check = () -> this.assertEquals("Rows must match", expectedRows, this.sql("SELECT * FROM %s WHERE %s ORDER BY id", this.tableName, predicate));
        SparkPlan sparkPlan = this.executeAndKeepPlan(check);
        String planAsString = sparkPlan.toString().replaceAll("#(\\d+L?)", "");
        if (sparkFilter != null) {
            ((AbstractStringAssert)Assertions.assertThat((String)planAsString).as("Post scan filter should match", new Object[0])).contains(new CharSequence[]{"Filter (" + sparkFilter + ")"});
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)planAsString).as("Should be no post scan filter", new Object[0])).doesNotContain(new CharSequence[]{"Filter ("});
        }
        ((AbstractStringAssert)Assertions.assertThat((String)planAsString).as("Pushed filters must match", new Object[0])).contains(new CharSequence[]{"[filters=" + icebergFilters + ","});
    }

    private Timestamp timestamp(String timestampAsString) {
        return Timestamp.from(Instant.parse(timestampAsString));
    }
}

