/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestNamespaceSQL
extends CatalogTestBase {
    private static final Namespace NS = Namespace.of((String[])new String[]{"db"});
    @Parameter(index=3)
    private String fullNamespace;
    @Parameter(index=4)
    private boolean isHadoopCatalog;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, fullNameSpace = {3}, isHadoopCatalog = {4}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties(), SparkCatalogConfig.HIVE.catalogName() + "." + NS.toString(), false}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), SparkCatalogConfig.HADOOP.catalogName() + "." + NS, true}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties(), NS.toString(), false}};
    }

    @AfterEach
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.table", this.fullNamespace);
        this.sql("DROP NAMESPACE IF EXISTS %s", this.fullNamespace);
    }

    @TestTemplate
    public void testCreateNamespace() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testDefaultNamespace() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("Hadoop has no default namespace configured", new Object[0])).isFalse();
        this.sql("USE %s", this.catalogName);
        Object[] current = (Object[])Iterables.getOnlyElement(this.sql("SHOW CURRENT NAMESPACE", new Object[0]));
        ((ObjectAssert)Assertions.assertThat((Object)current[0]).as("Should use the current catalog", new Object[0])).isEqualTo((Object)this.catalogName);
        ((ObjectAssert)Assertions.assertThat((Object)current[1]).as("Should use the configured default namespace", new Object[0])).isEqualTo((Object)"default");
    }

    @TestTemplate
    public void testDropEmptyNamespace() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        this.sql("DROP NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should have been dropped", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testDropNonEmptyNamespace() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Session catalog has flaky behavior", new Object[0])).isNotEqualTo((Object)"spark_catalog");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(TableIdentifier.of((Namespace)NS, (String)"table"))).as("Table should exist", new Object[0])).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP NAMESPACE %s", this.fullNamespace)).isInstanceOf(NamespaceNotEmptyException.class)).hasMessageStartingWith("Namespace db is not empty.");
        this.sql("DROP TABLE %s.table", this.fullNamespace);
    }

    @TestTemplate
    public void testListTables() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        List<Object[]> rows = this.sql("SHOW TABLES IN %s", this.fullNamespace);
        ((ListAssert)Assertions.assertThat(rows).as("Should not list any tables", new Object[0])).hasSize(0);
        this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.fullNamespace);
        Object[] row = (Object[])Iterables.getOnlyElement(this.sql("SHOW TABLES IN %s", this.fullNamespace));
        ((ObjectAssert)Assertions.assertThat((Object)row[0]).as("Namespace should match", new Object[0])).isEqualTo((Object)"db");
        ((ObjectAssert)Assertions.assertThat((Object)row[1]).as("Table name should match", new Object[0])).isEqualTo((Object)"table");
    }

    @TestTemplate
    public void testListNamespace() {
        Set namespaceNames;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        List<Object[]> namespaces = this.sql("SHOW NAMESPACES IN %s", this.catalogName);
        if (this.isHadoopCatalog) {
            ((ListAssert)Assertions.assertThat(namespaces).as("Should have 1 namespace", new Object[0])).hasSize(1);
            namespaceNames = namespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
            ((AbstractCollectionAssert)Assertions.assertThat(namespaceNames).as("Should have only db namespace", new Object[0])).isEqualTo((Object)ImmutableSet.of((Object)"db"));
        } else {
            ((ListAssert)Assertions.assertThat(namespaces).as("Should have 2 namespaces", new Object[0])).hasSize(2);
            namespaceNames = namespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
            ((AbstractCollectionAssert)Assertions.assertThat(namespaceNames).as("Should have default and db namespaces", new Object[0])).isEqualTo((Object)ImmutableSet.of((Object)"default", (Object)"db"));
        }
        List<Object[]> nestedNamespaces = this.sql("SHOW NAMESPACES IN %s", this.fullNamespace);
        Set nestedNames = nestedNamespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat(nestedNames).as("Should not have nested namespaces", new Object[0])).isEmpty();
    }

    @TestTemplate
    public void testCreateNamespaceWithMetadata() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s WITH PROPERTIES ('prop'='value')", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"prop", (Object)"value");
    }

    @TestTemplate
    public void testCreateNamespaceWithComment() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s COMMENT 'namespace doc'", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"comment", (Object)"namespace doc");
    }

    @TestTemplate
    public void testCreateNamespaceWithLocation() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        File location = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)location.delete()).isTrue();
        this.sql("CREATE NAMESPACE %s LOCATION '%s'", this.fullNamespace, location);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"location", (Object)("file:" + location.getPath()));
    }

    @TestTemplate
    public void testSetProperties() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(NS)).as("Namespace should exist", new Object[0])).isTrue();
        Map defaultMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        ((MapAssert)Assertions.assertThat((Map)defaultMetadata).as("Default metadata should not have custom property", new Object[0])).doesNotContainKey((Object)"prop");
        this.sql("ALTER NAMESPACE %s SET PROPERTIES ('prop'='value')", this.fullNamespace);
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"prop", (Object)"value");
    }
}

